/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedRelevantGenerationIdsInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedSyncTransferredInfo;
import java.util.Collection;

@InternalApi
public class EmbeddedRelevantGenerationIdsHandler {
    private final EmbeddedSyncHandler _embeddedHandler;
    private final long _currentGenerationId;
    private EmbeddedRelevantGenerationIdsInfo _info;
    private Collection<EmbeddedSyncTransferredInfo> _allTransferredInfo;

    public EmbeddedRelevantGenerationIdsHandler(EmbeddedSyncHandler embeddedHandler) {
        this._embeddedHandler = embeddedHandler;
        this._currentGenerationId = embeddedHandler.getMainSyncHandler().getCurrentGenerationId();
    }

    public void afterInitializedBlobStoreIO() {
        EmbeddedRelevantGenerationIdsInfo info = this._embeddedHandler.getMainSyncHandler().getListHandler().getIoHandler().getEmbeddedRelevantGenerationIdsInfo();
        if (info == null) {
            info = new EmbeddedRelevantGenerationIdsInfo(this._currentGenerationId);
            this._embeddedHandler.getMainSyncHandler().getListHandler().getIoHandler().insert(info);
        } else {
            info.addCurrentGeneration(this._currentGenerationId);
            this._embeddedHandler.getMainSyncHandler().getListHandler().getIoHandler().update(info);
        }
        this._info = info;
        this._allTransferredInfo = this._embeddedHandler.getMainSyncHandler().getListHandler().getIoHandler().getAllTransferredInfo(this._embeddedHandler, this.getRelevantGenerations());
    }

    public void initialize() {
    }

    public Collection<EmbeddedSyncTransferredInfo> getAllTransferredInfo() {
        return this._allTransferredInfo;
    }

    public boolean isRelevant(long gen) {
        return gen == this._currentGenerationId || this._info.isRelevant(gen);
    }

    public void removeOldGens() {
        if (this._info.removeOldGens(this._currentGenerationId)) {
            this._embeddedHandler.getMainSyncHandler().getListHandler().getIoHandler().update(this._info);
        }
    }

    public Collection<Long> getRelevantGenerations() {
        return this._info.getRelevantGenerations();
    }
}

