/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@InternalApi
public class EmbeddedRelevantGenerationIdsInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private volatile Set<Long> _relevantGens;

    public EmbeddedRelevantGenerationIdsInfo(long current) {
        this._relevantGens = new HashSet<Long>();
        this._relevantGens.add(current);
    }

    public static String getStorageKey() {
        return "SYNC_ADMIN_EBEDDED_RELEVANT_GENS";
    }

    public EmbeddedRelevantGenerationIdsInfo() {
    }

    public boolean isRelevant(long gen) {
        return this._relevantGens.contains(gen);
    }

    public void addCurrentGeneration(long currentGen) {
        this._relevantGens.add(currentGen);
    }

    public boolean removeOldGens(long current) {
        if (this._relevantGens.size() == 1) {
            return false;
        }
        HashSet<Long> relevantGens = new HashSet<Long>();
        relevantGens.add(current);
        this._relevantGens = relevantGens;
        return true;
    }

    public Collection<Long> getRelevantGenerations() {
        return this._relevantGens;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion myversion = (PlatformLogicalVersion)in.readObject();
        this._relevantGens = new HashSet<Long>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            long l = in.readLong();
            this._relevantGens.add(l);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this._relevantGens == null || this._relevantGens.size() == 0) {
            throw new RuntimeException("internal error: no embedded gens info!");
        }
        PlatformLogicalVersion curversion = PlatformLogicalVersion.getLogicalVersion();
        out.writeObject(curversion);
        out.writeInt(this._relevantGens.size());
        Iterator<Long> iter = this._relevantGens.iterator();
        while (iter.hasNext()) {
            out.writeLong(iter.next());
        }
    }
}

