/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncSegment;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.IEmbeddedSyncOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedSyncTransferredInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class EmbeddedSyncListTransferredInfoHandler {
    private final int _segmentNumber;
    private final EmbeddedSyncSegment _segment;
    private final EmbeddedSyncTransferredInfo _currentGenInfo;
    private volatile Map<Long, EmbeddedSyncTransferredInfo> _oldGenerationsInfo;

    public EmbeddedSyncListTransferredInfoHandler(EmbeddedSyncSegment segment) {
        this._segment = segment;
        this._segmentNumber = segment.getSegmentNumber();
        this._currentGenInfo = new EmbeddedSyncTransferredInfo(this._segment.getEmbeddedHandler().getMainSyncHandler().getCurrentGenerationId(), this._segment.getSegmentNumber());
        this._oldGenerationsInfo = new HashMap<Long, EmbeddedSyncTransferredInfo>();
    }

    public void afterInitializedBlobStoreIO(Collection<Long> oldGens) {
        Collection<EmbeddedSyncTransferredInfo> oldGensInfo = this._segment.getEmbeddedHandler().getGensHandler().getAllTransferredInfo();
        if (oldGensInfo != null) {
            for (EmbeddedSyncTransferredInfo oi : oldGensInfo) {
                if (this._segmentNumber != oi.getSegmentNum() % this._segment.getEmbeddedHandler().getNumSegments()) continue;
                this._oldGenerationsInfo.put(oi.getGenerationId(), oi);
            }
        }
        this._segment.getEmbeddedHandler().getMainSyncHandler().getListHandler().getIoHandler().insert(this._currentGenInfo);
    }

    public void initialize() {
    }

    public void updateTranferredInfo(IEmbeddedSyncOpInfo oi) {
        if (this._currentGenInfo.updateTranferredInfo(oi.getSeqInEmbeddedSegment())) {
            this._segment.getEmbeddedHandler().getMainSyncHandler().getListHandler().getIoHandler().update(this._currentGenInfo);
        }
    }

    public boolean isSeqNumberTransferredForSure(long genId, int seqNumWithinSegment) {
        if (genId == this._segment.getEmbeddedHandler().getMainSyncHandler().getCurrentGenerationId()) {
            return this._currentGenInfo.isSeqNumberCellTransferred(seqNumWithinSegment);
        }
        EmbeddedSyncTransferredInfo o = this._oldGenerationsInfo.get(genId);
        if (o == null) {
            return true;
        }
        return o.isSeqNumberCellTransferred(seqNumWithinSegment);
    }

    public void removeOldGenerationsTransferredInfo() {
        Map<Long, EmbeddedSyncTransferredInfo> oldGenerationsInfo = this._oldGenerationsInfo;
        this._oldGenerationsInfo = new HashMap<Long, EmbeddedSyncTransferredInfo>();
        for (EmbeddedSyncTransferredInfo inf : oldGenerationsInfo.values()) {
            this._segment.getEmbeddedHandler().getMainSyncHandler().getListHandler().getIoHandler().remove(inf);
        }
    }
}

