/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin;

import com.gigaspaces.api.InternalApi;

@InternalApi
public class EmbeddedSyncTransferredCellInfo {
    public static final int TRANFERRED_CELL_CAPACITY_LIMIT = 100;
    private final int _fromSeqNumber;
    private final int _uptoSeqNumber;
    private int _numTransferred;

    EmbeddedSyncTransferredCellInfo(int fromSeqNumber, int uptoSeqNumber) {
        this._fromSeqNumber = fromSeqNumber;
        this._uptoSeqNumber = uptoSeqNumber;
    }

    EmbeddedSyncTransferredCellInfo(EmbeddedSyncTransferredCellInfo s1, EmbeddedSyncTransferredCellInfo s2) {
        if (s1.getFromSeqNumber() < s2.getFromSeqNumber()) {
            this._fromSeqNumber = s1.getFromSeqNumber();
            this._uptoSeqNumber = s2.getUptoSeqNumber();
        } else {
            this._fromSeqNumber = s2.getFromSeqNumber();
            this._uptoSeqNumber = s1.getUptoSeqNumber();
        }
        this._numTransferred = s1.getNumTransferred() + s2.getNumTransferred();
    }

    public int getFromSeqNumber() {
        return this._fromSeqNumber;
    }

    public int getUptoSeqNumber() {
        return this._uptoSeqNumber;
    }

    public int getNumTransferred() {
        return this._numTransferred;
    }

    public int addToTransferred() {
        return ++this._numTransferred;
    }

    public boolean isCellFull() {
        return this._numTransferred >= 100;
    }

    public boolean canJoin(EmbeddedSyncTransferredCellInfo other) {
        return this.isCellFull() && other.isCellFull() && (other.getUptoSeqNumber() == this.getFromSeqNumber() - 1 || other.getFromSeqNumber() == this.getUptoSeqNumber() + 1);
    }

    StringBuffer displayInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(" from=").append(this._fromSeqNumber).append(" to=").append(this._uptoSeqNumber).append(" #transferred=").append(this._numTransferred);
        return sb;
    }
}

