/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedSyncTransferredCellInfo;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@InternalApi
public class EmbeddedSyncTransferredInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private long _generationId;
    private int _segmentNum;
    private Map<Integer, EmbeddedSyncTransferredCellInfo> _tranferredCells;
    private TreeMap<Integer, OldGenCellInfo> _integratedCells;
    private int _currentGenerationFullCells;
    private boolean _isCurrentGenId;

    public EmbeddedSyncTransferredInfo(long generationId, int segmentNum) {
        this._generationId = generationId;
        this._segmentNum = segmentNum;
        this._tranferredCells = new HashMap<Integer, EmbeddedSyncTransferredCellInfo>();
        this._isCurrentGenId = true;
    }

    public EmbeddedSyncTransferredInfo() {
    }

    public static String getStorageKey(long generationId, int segmentNum) {
        return "SYNC_ADMIN_EBEDDED_SEGMENT_INFO_" + generationId + "_" + segmentNum;
    }

    public long getGenerationId() {
        return this._generationId;
    }

    public int getSegmentNum() {
        return this._segmentNum;
    }

    public boolean updateTranferredInfo(int seq) {
        int from = seq - seq % 100;
        int to = from + 100 - 1;
        EmbeddedSyncTransferredCellInfo ci = this._tranferredCells.get(from);
        if (ci == null) {
            ci = new EmbeddedSyncTransferredCellInfo(from, to);
            this._tranferredCells.put(from, ci);
        }
        if (ci.isCellFull()) {
            throw new RuntimeException("invalid situation- cell is full segment=" + this._segmentNum + " generation=" + this._generationId);
        }
        ci.addToTransferred();
        if (ci.isCellFull()) {
            ++this._currentGenerationFullCells;
            this.integrateCellsIfPossible(ci);
        }
        return ci.isCellFull();
    }

    private void integrateCellsIfPossible(EmbeddedSyncTransferredCellInfo ci) {
        EmbeddedSyncTransferredCellInfo curFull = ci;
        while (this._tranferredCells.size() > 1) {
            EmbeddedSyncTransferredCellInfo r = null;
            for (EmbeddedSyncTransferredCellInfo cur : this._tranferredCells.values()) {
                if (cur == curFull || !cur.canJoin(curFull)) continue;
                r = cur;
                --this._currentGenerationFullCells;
                break;
            }
            if (r == null) {
                return;
            }
            EmbeddedSyncTransferredCellInfo newCur = new EmbeddedSyncTransferredCellInfo(r, curFull);
            this._tranferredCells.remove(r.getFromSeqNumber());
            this._tranferredCells.remove(curFull.getFromSeqNumber());
            this._tranferredCells.put(newCur.getFromSeqNumber(), newCur);
            curFull = newCur;
        }
    }

    public boolean isSeqNumberCellTransferred(int seqNumber) {
        if (this._integratedCells == null && this._isCurrentGenId) {
            throw new RuntimeException("internal error: invalid call -relevant for old gen only!");
        }
        if (this._integratedCells == null) {
            return true;
        }
        Map.Entry<Integer, OldGenCellInfo> res = this._integratedCells.ceilingEntry(seqNumber);
        return res != null && res.getValue().getFrom() <= seqNumber;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion myversion = (PlatformLogicalVersion)in.readObject();
        this._integratedCells = new TreeMap();
        this._generationId = in.readLong();
        this._segmentNum = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            OldGenCellInfo oi = new OldGenCellInfo(in.readInt(), in.readInt());
            this._integratedCells.put(oi.getUpTo(), oi);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this._integratedCells != null) {
            throw new RuntimeException("internal error: should write new gen only!");
        }
        PlatformLogicalVersion curversion = PlatformLogicalVersion.getLogicalVersion();
        out.writeObject(curversion);
        out.writeLong(this._generationId);
        out.writeInt(this._segmentNum);
        out.writeInt(this._currentGenerationFullCells);
        for (EmbeddedSyncTransferredCellInfo cur : this._tranferredCells.values()) {
            if (!cur.isCellFull()) continue;
            out.writeInt(cur.getFromSeqNumber());
            out.writeInt(cur.getUptoSeqNumber());
        }
    }

    StringBuffer displayInfo() {
        StringBuffer sb = new StringBuffer();
        for (EmbeddedSyncTransferredCellInfo c : this._tranferredCells.values()) {
            sb.append(c.displayInfo());
        }
        return sb;
    }

    void print() {
    }

    public static class OldGenCellInfo {
        private final int _from;
        private final int _upTo;

        OldGenCellInfo(int from, int upTo) {
            this._from = from;
            this._upTo = upTo;
        }

        public int getFrom() {
            return this._from;
        }

        public int getUpTo() {
            return this._upTo;
        }
    }
}

