/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.ioImpl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyOverflowListSegment;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.admin.DirectPersistencySyncAdminInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedRelevantGenerationIdsInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedSyncTransferredInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.ioImpl.IDirectPersistencyIoHandler;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationRequest;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

@InternalApi
public class DirectPersistencyBlobStoreIO
implements IDirectPersistencyIoHandler {
    private final CacheManager _cacheManager;
    private final Logger _logger;
    private final long _currentGenerationId;

    public DirectPersistencyBlobStoreIO(CacheManager cacheManager, Logger logger, long currentGenerationId) {
        this._cacheManager = cacheManager;
        this._logger = logger;
        this._currentGenerationId = currentGenerationId;
    }

    private static String getOpInfoStorageKey(long generationId, long seq) {
        StringBuffer sb = new StringBuffer();
        sb.append(generationId).append("_").append(seq);
        return sb.toString();
    }

    public static String getOverflowSegmentStorageKey(long gen, long seq) {
        StringBuffer sb = new StringBuffer();
        sb.append("OVF_").append(gen).append("_").append(seq);
        return sb.toString();
    }

    @Override
    public void insert(IDirectPersistencyOpInfo entry) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().add((Serializable)((Object)DirectPersistencyBlobStoreIO.getOpInfoStorageKey(entry.getGenerationId(), entry.getSequenceNumber())), entry, BlobStoreObjectType.SYNC, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::add got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void remove(IDirectPersistencyOpInfo entry) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().remove((Serializable)((Object)DirectPersistencyBlobStoreIO.getOpInfoStorageKey(entry.getGenerationId(), entry.getSequenceNumber())), null, BlobStoreObjectType.SYNC, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::remove got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void update(IDirectPersistencyOpInfo entry) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().replace((Serializable)((Object)DirectPersistencyBlobStoreIO.getOpInfoStorageKey(entry.getGenerationId(), entry.getSequenceNumber())), entry, null, BlobStoreObjectType.SYNC, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::replace got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public IDirectPersistencyOpInfo get(long getGenerationId, long sequenceNumber) {
        try {
            return (IDirectPersistencyOpInfo)this._cacheManager.getBlobStoreStorageHandler().get((Serializable)((Object)DirectPersistencyBlobStoreIO.getOpInfoStorageKey(getGenerationId, sequenceNumber)), null, BlobStoreObjectType.SYNC, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::get exception: " + ex);
            throw ex;
        }
    }

    @Override
    public Iterator<IDirectPersistencyOpInfo> iterateOps(boolean currentGeneration) {
        return new DirectPersistencyOpIterBlobStoreIO(this, this._cacheManager, this._logger, currentGeneration);
    }

    @Override
    public void removeOpsBulk(List<IDirectPersistencyOpInfo> ops) {
        LinkedList<BlobStoreBulkOperationRequest> blk = new LinkedList<BlobStoreBulkOperationRequest>();
        for (IDirectPersistencyOpInfo op : ops) {
            blk.add(new BlobStoreRemoveBulkOperationRequest((Serializable)((Object)DirectPersistencyBlobStoreIO.getOpInfoStorageKey(op.getGenerationId(), op.getSequenceNumber())), null, null));
        }
        this._cacheManager.getBlobStoreStorageHandler().executeBulk(blk, BlobStoreObjectType.SYNC, false);
    }

    @Override
    public void insert(DirectPersistencyOverflowListSegment segment) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().add((Serializable)((Object)DirectPersistencyBlobStoreIO.getOverflowSegmentStorageKey(segment.getGenerationId(), segment.getSequenceNumber())), segment, BlobStoreObjectType.SYNC_OVERFLOW, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::add-OVF got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void remove(DirectPersistencyOverflowListSegment segment) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().remove((Serializable)((Object)DirectPersistencyBlobStoreIO.getOverflowSegmentStorageKey(segment.getGenerationId(), segment.getSequenceNumber())), null, BlobStoreObjectType.SYNC_OVERFLOW, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::remove-OVF got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void update(DirectPersistencyOverflowListSegment segment) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().replace((Serializable)((Object)DirectPersistencyBlobStoreIO.getOverflowSegmentStorageKey(segment.getGenerationId(), segment.getSequenceNumber())), segment, null, BlobStoreObjectType.SYNC_OVERFLOW, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::replace_OVF got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public DirectPersistencyOverflowListSegment getOverflowSegment(long generationId, long seq) {
        try {
            return (DirectPersistencyOverflowListSegment)this._cacheManager.getBlobStoreStorageHandler().get((Serializable)((Object)DirectPersistencyBlobStoreIO.getOverflowSegmentStorageKey(generationId, seq)), null, BlobStoreObjectType.SYNC_OVERFLOW, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::getOverflowSegment exception: " + ex);
            throw ex;
        }
    }

    @Override
    public Iterator<DirectPersistencyOverflowListSegment> iterateOverflow(boolean currentGeneration) {
        return new DirectPersistencyOverflowIterBlobStoreIO(this, this._cacheManager, this._logger, currentGeneration);
    }

    @Override
    public void removeOvfBulk(List<DirectPersistencyOverflowListSegment> ovfs) {
        LinkedList<BlobStoreBulkOperationRequest> blk = new LinkedList<BlobStoreBulkOperationRequest>();
        for (DirectPersistencyOverflowListSegment segment : ovfs) {
            blk.add(new BlobStoreRemoveBulkOperationRequest((Serializable)((Object)DirectPersistencyBlobStoreIO.getOverflowSegmentStorageKey(segment.getGenerationId(), segment.getSequenceNumber())), null, null));
        }
        this._cacheManager.getBlobStoreStorageHandler().executeBulk(blk, BlobStoreObjectType.SYNC_OVERFLOW, false);
    }

    @Override
    public void insert(DirectPersistencySyncAdminInfo ai) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().add((Serializable)((Object)DirectPersistencySyncAdminInfo.getStorageKey()), ai, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::add-syncadmin got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void update(DirectPersistencySyncAdminInfo ai) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().replace((Serializable)((Object)DirectPersistencySyncAdminInfo.getStorageKey()), ai, null, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::replace_syncadmin got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public DirectPersistencySyncAdminInfo getSyncAdminIfExists() {
        try {
            return (DirectPersistencySyncAdminInfo)this._cacheManager.getBlobStoreStorageHandler().get((Serializable)((Object)DirectPersistencySyncAdminInfo.getStorageKey()), null, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::getsyncadmin exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void removePhantom(String uid, boolean checkExistance, long generationId, long seq) {
        try {
            BlobStoreEntryLayout el;
            if (checkExistance && (el = (BlobStoreEntryLayout)this._cacheManager.getBlobStoreStorageHandler().get(EmbeddedSyncHandler.getStorageKeyForPhantom(uid), null, BlobStoreObjectType.DATA, null)) == null) {
                return;
            }
            this._cacheManager.getBlobStoreStorageHandler().remove(EmbeddedSyncHandler.getStorageKeyForPhantom(uid), null, BlobStoreObjectType.DATA, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::removePhantom exception: " + ex);
            throw ex;
        }
    }

    private EmbeddedSyncTransferredInfo getEmbeddedTransferredInfo(long generationId, int segment) {
        try {
            return (EmbeddedSyncTransferredInfo)this._cacheManager.getBlobStoreStorageHandler().get((Serializable)((Object)EmbeddedSyncTransferredInfo.getStorageKey(generationId, segment)), null, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::EmbeddedSyncTransferredInfo exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void insert(EmbeddedSyncTransferredInfo ai) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().add((Serializable)((Object)EmbeddedSyncTransferredInfo.getStorageKey(ai.getGenerationId(), ai.getSegmentNum())), ai, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::add-EmbeddedSyncTransferredInfo got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void update(EmbeddedSyncTransferredInfo ai) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().replace((Serializable)((Object)EmbeddedSyncTransferredInfo.getStorageKey(ai.getGenerationId(), ai.getSegmentNum())), ai, null, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::replace_EmbeddedSyncTransferredInfo got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void remove(EmbeddedSyncTransferredInfo ai) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().remove((Serializable)((Object)EmbeddedSyncTransferredInfo.getStorageKey(ai.getGenerationId(), ai.getSegmentNum())), null, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::remove_EmbeddedSyncTransferredInfo got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public EmbeddedRelevantGenerationIdsInfo getEmbeddedRelevantGenerationIdsInfo() {
        try {
            return (EmbeddedRelevantGenerationIdsInfo)this._cacheManager.getBlobStoreStorageHandler().get((Serializable)((Object)EmbeddedRelevantGenerationIdsInfo.getStorageKey()), null, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::getEmbeddedRelevantGenerationIdsInfo exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void update(EmbeddedRelevantGenerationIdsInfo ai) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().replace((Serializable)((Object)EmbeddedRelevantGenerationIdsInfo.getStorageKey()), ai, null, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::replace EmbeddedRelevantGenerationIdsInfo got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public void insert(EmbeddedRelevantGenerationIdsInfo ai) {
        try {
            this._cacheManager.getBlobStoreStorageHandler().add((Serializable)((Object)EmbeddedRelevantGenerationIdsInfo.getStorageKey()), ai, BlobStoreObjectType.ADMIN, null);
        }
        catch (BlobStoreException ex) {
            this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::add-EmbeddedRelevantGenerationIdsInfo got exception: " + ex);
            throw ex;
        }
    }

    @Override
    public List<EmbeddedSyncTransferredInfo> getAllTransferredInfo(EmbeddedSyncHandler h, Collection<Long> generations) {
        LinkedList<EmbeddedSyncTransferredInfo> res = new LinkedList<EmbeddedSyncTransferredInfo>();
        for (long gen : generations) {
            if (gen == h.getMainSyncHandler().getCurrentGenerationId()) continue;
            for (int s = 0; s < h.getNumSegments(); ++s) {
                EmbeddedSyncTransferredInfo oi = this.getEmbeddedTransferredInfo(gen, s);
                if (oi == null) continue;
                res.add(oi);
            }
        }
        return res;
    }

    public static class DirectPersistencyOverflowIterBlobStoreIO
    implements Iterator<DirectPersistencyOverflowListSegment> {
        private final CacheManager _cacheManager;
        private final Logger _logger;
        private boolean _closed;
        private final DataIterator<BlobStoreGetBulkOperationResult> _iter;
        private DirectPersistencyOverflowListSegment _cur;
        private final DirectPersistencyBlobStoreIO _ioMgr;
        private final boolean _isCurrentGeneration;

        public DirectPersistencyOverflowIterBlobStoreIO(DirectPersistencyBlobStoreIO ioMgr, CacheManager cacheManager, Logger logger, boolean isCurrentGeneration) {
            this._cacheManager = cacheManager;
            this._logger = logger;
            this._ioMgr = ioMgr;
            this._isCurrentGeneration = isCurrentGeneration;
            try {
                this._iter = this._cacheManager.getBlobStoreStorageHandler().iterator(BlobStoreObjectType.SYNC_OVERFLOW);
            }
            catch (BlobStoreException ex) {
                this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::create-iterator-OVERFLOW got exception: " + ex);
                this._closed = true;
                throw ex;
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this._cur = null;
                if (this._closed) {
                    return false;
                }
                do {
                    if (!this._iter.hasNext()) {
                        this._iter.close();
                        this._closed = true;
                        return false;
                    }
                    this.getCur();
                } while (this._cur == null);
                return true;
            }
            catch (BlobStoreException ex) {
                this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::iterator-hasnext got exception: " + ex);
                this._closed = true;
                throw ex;
            }
        }

        private void getCur() {
            try {
                boolean curGen;
                DirectPersistencyOverflowListSegment cur = (DirectPersistencyOverflowListSegment)((BlobStoreGetBulkOperationResult)this._iter.next()).getData();
                boolean bl = curGen = cur.getGenerationId() == this._ioMgr._currentGenerationId;
                if (curGen == this._isCurrentGeneration) {
                    this._cur = cur;
                }
                return;
            }
            catch (BlobStoreException ex) {
                this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::iteratorOVF-next got exception: " + ex);
                this._closed = true;
                throw ex;
            }
        }

        @Override
        public DirectPersistencyOverflowListSegment next() {
            if (this._closed) {
                return null;
            }
            return this._cur;
        }

        @Override
        public void remove() {
            if (this._closed || this._cur == null) {
                throw new UnsupportedOperationException("remove- iter inactive");
            }
            this._ioMgr.remove(this._cur);
        }
    }

    public static class DirectPersistencyOpIterBlobStoreIO
    implements Iterator<IDirectPersistencyOpInfo> {
        private final CacheManager _cacheManager;
        private final Logger _logger;
        private boolean _closed;
        private final DataIterator<BlobStoreGetBulkOperationResult> _iter;
        private IDirectPersistencyOpInfo _cur;
        private final DirectPersistencyBlobStoreIO _ioMgr;
        private final boolean _isCurrentGeneration;

        public DirectPersistencyOpIterBlobStoreIO(DirectPersistencyBlobStoreIO ioMgr, CacheManager cacheManager, Logger logger, boolean isCurrentGeneration) {
            this._cacheManager = cacheManager;
            this._logger = logger;
            this._ioMgr = ioMgr;
            this._isCurrentGeneration = isCurrentGeneration;
            try {
                this._iter = this._cacheManager.getBlobStoreStorageHandler().iterator(BlobStoreObjectType.SYNC);
            }
            catch (BlobStoreException ex) {
                this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::create-iterator got exception: " + ex);
                this._closed = true;
                throw ex;
            }
        }

        @Override
        public boolean hasNext() {
            try {
                boolean curGen;
                this._cur = null;
                if (this._closed) {
                    return false;
                }
                IDirectPersistencyOpInfo cur = null;
                BlobStoreGetBulkOperationResult curSync = null;
                do {
                    if (!this._iter.hasNext()) {
                        this.close();
                        return false;
                    }
                    curSync = this.nextSync();
                    if (curSync == null) {
                        this.close();
                        return false;
                    }
                    cur = this.getCur(curSync);
                } while ((curGen = cur.getGenerationId() == this._ioMgr._currentGenerationId) != this._isCurrentGeneration);
                this._cur = cur;
                return true;
            }
            catch (BlobStoreException ex) {
                this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::iterator-hasnext got exception: " + ex);
                this._closed = true;
                throw ex;
            }
        }

        private void close() {
            if (this._closed) {
                return;
            }
            this._iter.close();
            this._closed = true;
        }

        private BlobStoreGetBulkOperationResult nextSync() {
            try {
                return (BlobStoreGetBulkOperationResult)this._iter.next();
            }
            catch (BlobStoreException ex) {
                this._logger.severe("space " + this._cacheManager.getEngine().getFullSpaceName() + " DirectPersistencyBlobStoreIO::iterator-next got exception: " + ex);
                this._closed = true;
                throw ex;
            }
        }

        private IDirectPersistencyOpInfo getCur(BlobStoreGetBulkOperationResult current) {
            return (IDirectPersistencyOpInfo)current.getData();
        }

        @Override
        public IDirectPersistencyOpInfo next() {
            if (this._closed) {
                return null;
            }
            return this._cur;
        }

        @Override
        public void remove() {
            if (this._closed || this._cur == null) {
                throw new UnsupportedOperationException("remove- iter inactive");
            }
            this._ioMgr.remove(this._cur);
        }
    }
}

