/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.cluster.replication.OutgoingReplicationOutOfSyncException;
import com.gigaspaces.cluster.replication.ReplicationException;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.StatisticsHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.BrokenReplicationTopologyException;
import com.gigaspaces.internal.cluster.node.impl.groups.CompletedFuture;
import com.gigaspaces.internal.cluster.node.impl.groups.IAsyncReplicationListener;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceChannelStatistics;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicateFuture;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicatedDataPacketResource;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelDataFilterHelper;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationSourceChannelStatistics;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.ConnectChannelHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.ConnectChannelHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.packets.BatchReplicatedDataPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.ChannelBacklogDroppedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.ConnectChannelPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.IterativeHandshakePacket;
import com.gigaspaces.internal.cluster.node.impl.packets.PingPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.ReplicatedDataPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.UnreliableOperationPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.cluster.node.impl.replica.SynchronizationDonePacket;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectionStateListener;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.cluster.node.replica.CannotExecuteSynchronizeReplicaException;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.SegmentedAtomicInteger;
import com.gigaspaces.internal.utils.threadlocal.PoolFactory;
import com.gigaspaces.internal.utils.threadlocal.ThreadLocalPool;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractReplicationSourceChannel
implements IReplicationSourceChannel,
IConnectionStateListener {
    protected final Logger _specificLogger;
    protected final Logger _specificVerboseLogger;
    private final String _groupName;
    private final String _memberName;
    private final IReplicationRouter _replicationRouter;
    private final String _myLookupName;
    private final IReplicationMonitoredConnection _connection;
    private final IReplicationGroupBacklog _groupBacklog;
    private final IReplicationOutFilter _outFilter;
    private final boolean _isOutFiltered;
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final IReplicationChannelDataFilter _dataFilter;
    private final boolean _isDataFiltered;
    private final IReplicationSourceGroupStateListener _stateListener;
    private final StatisticsHolder<Integer> _throughPutStatistics;
    private volatile long _totalNumberOfReplicatedPackets;
    private final StatisticsHolder<Long> _generatedTrafficStatistics;
    private long _lastSampledGeneratedTraffic;
    private final StatisticsHolder<Long> _receivedTrafficStatistics;
    private long _lastSampledReceivedTraffic;
    private final IReplicationGroupHistory _groupHistory;
    private final long _inconsistentStateDelay;
    private final int _inconsistentStateRetries;
    private final ReplicationStatistics.ReplicationMode _channelType;
    private final Object _customBacklogMetadata;
    private final boolean _isNetworkCompressionEnabled;
    protected final SegmentedAtomicInteger _statisticsCounter = new SegmentedAtomicInteger();
    protected final ThreadLocalPool<ReplicatedDataPacketResource> _packetsPool;
    private volatile ChannelState _channelState = ChannelState.DISCONNECTED;
    private volatile boolean _closed;
    private volatile boolean _synchronizing;
    private volatile boolean _inconsistentDuringHandshakeState;
    private volatile Throwable _inconsistentDuringHandshakeStateReason;
    private volatile int _inconsistentDuringHandshakeStateIteration;
    private volatile ReplicationEndpointDetails _targetEndpointDetails;
    private volatile ConnectionEndpointDetails _delegatorEndpointDetails;
    private volatile boolean _wasEverActive;
    private IAsyncHandler _inconsistentDuringHandshakeStateHandler;
    private IAsyncHandler _iterativeHandshakeHandler;

    public AbstractReplicationSourceChannel(DynamicSourceGroupConfigHolder groupConfig, String groupName, String memberName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationGroupBacklog groupBacklog, IReplicationOutFilter outFilter, IAsyncHandlerProvider asyncHandlerProvider, IReplicationChannelDataFilter dataFilter, IReplicationSourceGroupStateListener stateListener, IReplicationGroupHistory groupHistory, ReplicationStatistics.ReplicationMode channelType, Object customBacklogMetadata) {
        this._groupName = groupName;
        this._replicationRouter = replicationRouter;
        this._memberName = memberName;
        this._stateListener = stateListener;
        this._groupHistory = groupHistory;
        this._channelType = channelType;
        this._customBacklogMetadata = customBacklogMetadata;
        this._myLookupName = replicationRouter.getMyLookupName();
        this._connection = connection;
        this._groupBacklog = groupBacklog;
        this._outFilter = outFilter;
        this._asyncHandlerProvider = asyncHandlerProvider;
        this._dataFilter = dataFilter;
        this._isOutFiltered = this._outFilter != null;
        this._isDataFiltered = this.getDataFilter() != null;
        SourceGroupConfig config = groupConfig.getConfig();
        this._inconsistentStateDelay = config.getInconsistentStateDelay();
        this._inconsistentStateRetries = config.getInconsistentStateRetries();
        this._specificLogger = ReplicationLogUtils.createOutgoingChannelSpecificLogger(this._myLookupName, this._memberName, this._groupName);
        this._specificVerboseLogger = ReplicationLogUtils.createChannelSpecificVerboseLogger(this._myLookupName, this._memberName, this._groupName);
        this._throughPutStatistics = new StatisticsHolder<Integer>(50, 0);
        this._throughPutStatistics.addSample(SystemTime.timeMillis(), 0);
        this._generatedTrafficStatistics = new StatisticsHolder<Long>(50, 0L);
        this._receivedTrafficStatistics = new StatisticsHolder<Long>(50, 0L);
        this._generatedTrafficStatistics.addSample(SystemTime.timeMillis(), 0L);
        this._receivedTrafficStatistics.addSample(SystemTime.timeMillis(), 0L);
        this._isNetworkCompressionEnabled = groupConfig.getConfig().isNetworkCompressionEnabled();
        this._packetsPool = new ThreadLocalPool<ReplicatedDataPacketResource>(new PoolFactory<ReplicatedDataPacketResource>(){

            @Override
            public ReplicatedDataPacketResource create() {
                return new ReplicatedDataPacketResource(AbstractReplicationSourceChannel.this.getGroupName());
            }
        });
    }

    protected void start() {
        this.wrapConnection();
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getMemberName() {
        return this._memberName;
    }

    public String getMyLookupName() {
        return this._myLookupName;
    }

    public IReplicationGroupBacklog getGroupBacklog() {
        return this._groupBacklog;
    }

    public IReplicationMonitoredConnection getConnection() {
        return this._connection;
    }

    public boolean isDataFiltered() {
        return this._isDataFiltered;
    }

    public IReplicationChannelDataFilter getDataFilter() {
        return this._dataFilter;
    }

    protected void logEventInHistory(String event) {
        this._groupHistory.logEvent(this.getMemberName(), event);
    }

    protected synchronized void wrapConnection() {
        this.getConnection().setConnectionStateListener(this);
        if (this.getConnection().getState() == ConnectionState.CONNECTED) {
            this.connectChannel();
        } else {
            this.channelDisconnected();
        }
    }

    @Override
    public synchronized void onConnected(boolean newTarget) {
        if (this._channelState == ChannelState.DISCONNECTED) {
            this.connectChannel();
        }
    }

    @Override
    public synchronized void onDisconnected() {
        if (this._channelState != ChannelState.DISCONNECTED) {
            this.channelDisconnected();
        }
    }

    private synchronized void connectChannel() {
        try {
            IProcessLogHandshakeResponse processLogHandshakeResponse;
            Object handshakeResponse;
            this._specificLogger.fine("Connection established");
            IBacklogMemberState memberState = this.getGroupBacklog().getState(this.getMemberName());
            if (memberState.isBacklogDropped()) {
                this.dispatchBacklogDropped(memberState);
                throw new OutgoingReplicationOutOfSyncException("Replication is out of sync, replication state " + memberState.toLogMessage());
            }
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("Performing handshake " + this.getConnectionDescription());
            }
            IBacklogHandshakeRequest backlogHandshakeRequest = this.getHandshakeRequest();
            ConnectChannelHandshakeRequest channelHandshakeRequest = new ConnectChannelHandshakeRequest(backlogHandshakeRequest);
            ConnectChannelPacket packet = new ConnectChannelPacket(this.getGroupName(), this._replicationRouter.getMyStubHolder(), channelHandshakeRequest);
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("Sending handshake request {" + backlogHandshakeRequest.toLogMessage() + "}");
            }
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("Backlog state {" + this.getGroupBacklog().toLogMessage(this.getMemberName()) + "}");
            }
            if ((handshakeResponse = this.getConnection().dispatch(packet)) instanceof IProcessLogHandshakeResponse) {
                processLogHandshakeResponse = (IProcessLogHandshakeResponse)handshakeResponse;
                this._targetEndpointDetails = ReplicationEndpointDetails.createBackwardEndpointDetails(this.getConnection().getFinalEndpointLookupName(), this.getConnection().getClosestEndpointUniqueId());
            } else {
                ConnectChannelHandshakeResponse connectChannelHandshakeResponse = (ConnectChannelHandshakeResponse)handshakeResponse;
                processLogHandshakeResponse = connectChannelHandshakeResponse.getProcessLogHandshakeResponse();
                this._targetEndpointDetails = connectChannelHandshakeResponse.getTargetEndpointDetails();
            }
            this._delegatorEndpointDetails = this.getConnection().getClosestEndpointDetails();
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("Got handshake response {" + processLogHandshakeResponse.toLogMessage() + "}");
            }
            IHandshakeContext handshakeContext = this.getGroupBacklog().processHandshakeResponse(this.getMemberName(), backlogHandshakeRequest, processLogHandshakeResponse, this.getTargetLogicalVersion(), this._customBacklogMetadata);
            this.logEventInHistory("Handshake executed:" + StringUtils.NEW_LINE + "\trequest: " + (backlogHandshakeRequest != null ? backlogHandshakeRequest.toLogMessage() : null) + StringUtils.NEW_LINE + "\tresponse: " + (processLogHandshakeResponse != null ? processLogHandshakeResponse.toLogMessage() : null) + StringUtils.NEW_LINE + "\tprocess context: " + handshakeContext.toLogMessage());
            ChannelState prevState = this._channelState;
            this._channelState = ChannelState.CONNECTED;
            this._inconsistentDuringHandshakeState = false;
            this._inconsistentDuringHandshakeStateReason = null;
            this._inconsistentDuringHandshakeStateIteration = 0;
            Level logLevel = this.requiresHighLevelLogging() ? Level.INFO : Level.FINE;
            this.logConnectionStateChange(prevState, ChannelState.CONNECTED, logLevel);
            this.handleHandshakeResponse(handshakeContext);
        }
        catch (RemoteException memberState) {
        }
        catch (Throwable e) {
            if (++this._inconsistentDuringHandshakeStateIteration == this._inconsistentStateRetries) {
                this._inconsistentDuringHandshakeStateIteration = 0;
                this.dispatchInconsistentStateEvent(e);
            }
            if (this._inconsistentDuringHandshakeState) {
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.log(Level.FINER, "Error occurred while retrying handshake " + this.getConnectionDescription(), e);
                }
                return;
            }
            if (this._specificLogger.isLoggable(Level.SEVERE)) {
                this._specificLogger.log(Level.SEVERE, "Error occurred while performing handshake, replication is disabled until the error is resolved " + this.getConnectionDescription(), e);
            }
            this.stopIterativeHandshakeProcess();
            this.moveToInconsistentState(e);
        }
    }

    protected void dispatchBacklogDropped(IBacklogMemberState memberState) throws RemoteException {
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("Channel backlog was dropped, notifying target {" + memberState.toLogMessage() + "}");
        }
        ChannelBacklogDroppedPacket backlogDroppedPacket = new ChannelBacklogDroppedPacket(this.getGroupName(), memberState);
        this.getConnection().dispatch(backlogDroppedPacket);
    }

    private void dispatchChannelActivated() {
        if (this._stateListener == null) {
            return;
        }
        this._stateListener.onSourceChannelActivated(this.getGroupName(), this.getMemberName());
    }

    private void dispatchInconsistentStateEvent(Throwable e) {
        if (this._stateListener == null) {
            return;
        }
        if (e instanceof BrokenReplicationTopologyException) {
            this._stateListener.onSourceBrokenReplicationTopology(this.getGroupName(), this.getMemberName(), (BrokenReplicationTopologyException)e);
        }
    }

    private void handleHandshakeResponse(IHandshakeContext handshakeContext) {
        if (handshakeContext.isDone()) {
            this._specificLogger.fine("Handshake completed - channel is active");
            this.moveToActive();
        } else {
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("Handshake is incomplete - iterative handshake activated " + handshakeContext.toLogMessage());
            }
            this._iterativeHandshakeHandler = this._asyncHandlerProvider.start(new IterativeHandshakeHandler(handshakeContext), 1L, "ChannelHandshakeHandler-" + this.getMyLookupName() + "." + this.getGroupName() + "." + this.getMemberName(), false);
        }
    }

    private void moveToActive() {
        ChannelState prevState = this._channelState;
        this._channelState = ChannelState.ACTIVE;
        this.onActiveImpl();
        Level logLevel = this.requiresHighLevelLogging() || this._wasEverActive ? Level.INFO : Level.FINE;
        this.logConnectionStateChange(prevState, ChannelState.ACTIVE, logLevel);
        this._wasEverActive = true;
        this.dispatchChannelActivated();
    }

    private void moveToInconsistentState(Throwable t) {
        this.onDisconnectedImpl();
        this._inconsistentDuringHandshakeStateReason = t;
        this._inconsistentDuringHandshakeState = true;
        this.logEventInHistory("moved to inconsistent state - reason " + t);
        this._inconsistentDuringHandshakeStateHandler = this._asyncHandlerProvider.start(new InconsistentStateHandler(), this._inconsistentStateDelay, "ChannelInconsistentState-" + this.getMyLookupName() + "." + this.getGroupName() + "." + this.getMemberName(), false);
    }

    private void stopIterativeHandshakeProcess() {
        IAsyncHandler iterativeHandshakeHandler = this._iterativeHandshakeHandler;
        if (iterativeHandshakeHandler != null) {
            iterativeHandshakeHandler.stop(5L, TimeUnit.SECONDS);
            this._iterativeHandshakeHandler = null;
        }
    }

    protected abstract void onActiveImpl();

    private synchronized void channelDisconnected() {
        ChannelState prevState = this._channelState;
        this._channelState = ChannelState.DISCONNECTED;
        this.stopIterativeHandshakeProcess();
        Level logLevel = this.requiresHighLevelLogging() || this._wasEverActive ? Level.INFO : Level.FINE;
        this.logConnectionStateChange(prevState, ChannelState.DISCONNECTED, logLevel);
        this.onDisconnectedImpl();
    }

    protected abstract void onDisconnectedImpl();

    private IBacklogHandshakeRequest getHandshakeRequest() {
        return this.getGroupBacklog().getHandshakeRequest(this.getMemberName(), this._customBacklogMetadata);
    }

    public boolean isActive() {
        return this._channelState == ChannelState.ACTIVE && !this.isClosed();
    }

    public ChannelState getChannelState() {
        return this._channelState;
    }

    public boolean pingTarget() {
        if (this._channelState == ChannelState.DISCONNECTED || this.isClosed()) {
            return false;
        }
        try {
            this.getConnection().dispatch(new PingPacket());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public synchronized void close() {
        Level logLevel;
        if (this._closed) {
            return;
        }
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("Closing...");
        }
        this.stopIterativeHandshakeProcess();
        this.stopInconsistentStateHandler();
        this.closeImpl();
        this.getConnection().close();
        this._closed = true;
        Level level = logLevel = this.requiresHighLevelLogging() ? Level.INFO : Level.FINE;
        if (this._specificLogger.isLoggable(logLevel)) {
            this._specificLogger.log(logLevel, "Channel is closed " + this.getConnectionDescription());
        }
        this._specificLogger.finer("Closed");
    }

    private void stopInconsistentStateHandler() {
        IAsyncHandler inconsistentStateHandler = this._inconsistentDuringHandshakeStateHandler;
        if (inconsistentStateHandler != null) {
            inconsistentStateHandler.stop(5L, TimeUnit.SECONDS);
            this._inconsistentDuringHandshakeStateHandler = null;
        }
    }

    protected abstract void closeImpl();

    public synchronized void beginSynchronizing(boolean isDirectPersistencySync) throws CannotExecuteSynchronizeReplicaException {
        if (this.pingTarget()) {
            throw new CannotExecuteSynchronizeReplicaException("replication group [" + this.getGroupName() + "] has a connected channel to [" + this.getMemberName() + "]");
        }
        this.getGroupBacklog().beginSynchronizing(this.getMemberName(), isDirectPersistencySync);
        this._synchronizing = true;
    }

    public synchronized void beginSynchronizing() throws CannotExecuteSynchronizeReplicaException {
        this.beginSynchronizing(false);
    }

    public synchronized void stopSynchronization() {
        if (!this._synchronizing) {
            return;
        }
        this._synchronizing = false;
        this.getGroupBacklog().stopSynchronization(this.getMemberName());
    }

    public boolean isSynchronizing() {
        return this._synchronizing;
    }

    public boolean synchronizationDataGenerated(String uid) {
        return this.getGroupBacklog().synchronizationDataGenerated(this.getMemberName(), uid);
    }

    public void synchronizationCopyStageDone() {
        this.getGroupBacklog().synchronizationCopyStageDone(this.getMemberName());
    }

    public synchronized void signalSynchronizingDone() throws RemoteException {
        this._specificLogger.fine("Signaling to target synchronization is done");
        this.getConnection().dispatch(new SynchronizationDonePacket(this.getGroupName()));
        this.getGroupBacklog().synchronizationDone(this.getMemberName());
        this._synchronizing = false;
    }

    private boolean beforeDelayedReplication(List<IReplicationOrderedPacket> packets) {
        boolean containsDiscardedPacket = false;
        ListIterator<IReplicationOrderedPacket> iterator = packets.listIterator();
        while (iterator.hasNext()) {
            IReplicationOrderedPacket packet = iterator.next();
            boolean stillRelevant = packet.getData().beforeDelayedReplication();
            if (!stillRelevant) {
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("Packet [" + packet.toString() + "] discarded by the channel filter");
                }
                iterator.set(this.getGroupBacklog().replaceWithDiscarded(packet, false));
                if (containsDiscardedPacket) continue;
                containsDiscardedPacket = true;
                continue;
            }
            if (containsDiscardedPacket) continue;
            containsDiscardedPacket = packet.isDiscardedPacket();
        }
        return containsDiscardedPacket;
    }

    protected int replicateBatch(List<IReplicationOrderedPacket> packets) throws RemoteException, ReplicationException {
        if (packets == null || packets.isEmpty()) {
            return 0;
        }
        boolean containsDiscardedPacket = this.invokeBeforeReplicatingChannelDataFilter(packets);
        return this.replicateBatchAfterChannelFilter(packets, containsDiscardedPacket);
    }

    protected int replicate(IReplicationOrderedPacket packet) throws RemoteException, ReplicationException {
        if (packet == null) {
            return 0;
        }
        packet = this.invokeBeforeReplicatingChannelDataFilter(packet);
        return this.replicateAfterChannelFilter(packet);
    }

    protected Future replicateAsync(List<IReplicationOrderedPacket> packets) throws RemoteException {
        if (packets == null || packets.isEmpty()) {
            return CompletedFuture.INSTANCE;
        }
        boolean containsDiscardedPacket = this.invokeBeforeReplicatingChannelDataFilter(packets);
        return this.replicateBatchAsyncAfterChannelFilter(packets, null, containsDiscardedPacket);
    }

    protected Future replicateAsync(IReplicationOrderedPacket packet) throws RemoteException {
        if (packet == null) {
            return CompletedFuture.INSTANCE;
        }
        packet = this.invokeBeforeReplicatingChannelDataFilter(packet);
        return this.replicateAsyncAfterChannelFilter(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int replicateBatchAfterChannelFilter(List<IReplicationOrderedPacket> packets, boolean containsDiscardedPacket) throws RemoteException, ReplicationException {
        this.invokeOutputFilterIfNeeded(packets, containsDiscardedPacket);
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("Replicating filtered packets: " + ReplicationLogUtils.packetsToLogString(packets));
        }
        ReplicatedDataPacketResource replicatedDataPacketResource = this._packetsPool.get();
        int replicatedCompleted = 0;
        try {
            replicatedCompleted = this.dispatchBatchReplicationPacket(packets, replicatedDataPacketResource);
            this._statisticsCounter.add(packets.size());
        }
        finally {
            replicatedDataPacketResource.release();
        }
        return replicatedCompleted;
    }

    private int dispatchBatchReplicationPacket(List<IReplicationOrderedPacket> packets, ReplicatedDataPacketResource replicatedDataPacketResource) throws RemoteException, ReplicationException {
        try {
            BatchReplicatedDataPacket batchPacket = replicatedDataPacketResource.getBatchPacket();
            batchPacket.setBatch(packets);
            Object wiredProcessResult = this.getConnection().dispatch(batchPacket);
            IProcessResult processResult = this._groupBacklog.fromWireForm(wiredProcessResult);
            this.logProcessResultReceivedIfNecessary(processResult, packets);
            this._groupBacklog.processResult(this._memberName, processResult, packets);
            this.invokeAfterReplicatedChannelDataFilter(packets);
            return this.isReplicationCompleted(processResult) ? 1 : 0;
        }
        catch (ReplicationException e) {
            throw e;
        }
        catch (Throwable t) {
            this.trackAndRethrowPendingErrorIfNeeded(t, packets);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int replicateAfterChannelFilter(IReplicationOrderedPacket packet) throws RemoteException, ReplicationException {
        int res = 0;
        packet = this.invokeOutputFilterIfNeeded(packet);
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("Replicating filtered packet: " + packet);
        }
        ReplicatedDataPacketResource replicatedDataPacketResource = this._packetsPool.get();
        try {
            res = this.dispatchReplicationPacket(packet, replicatedDataPacketResource);
            this._statisticsCounter.increment();
        }
        finally {
            replicatedDataPacketResource.release();
        }
        return res;
    }

    private int dispatchReplicationPacket(IReplicationOrderedPacket packet, ReplicatedDataPacketResource replicatedDataPacketResource) throws RemoteException, ReplicationException {
        try {
            ReplicatedDataPacket replicatedPacket = replicatedDataPacketResource.getPacket();
            replicatedPacket.setPacket(packet);
            Object wiredProcessResult = this.getConnection().dispatch(replicatedPacket);
            IProcessResult processResult = this._groupBacklog.fromWireForm(wiredProcessResult);
            this.logProcessResultIfNecessary(processResult, packet);
            this._groupBacklog.processResult(this._memberName, processResult, packet);
            this.invokeAfterReplicatedChannelDataFilter(packet);
            return this.isReplicationCompleted(processResult) ? 1 : 0;
        }
        catch (ReplicationException e) {
            throw e;
        }
        catch (Throwable t) {
            this.trackAndRethrowPendingErrorIfNeeded(t, packet);
            return 0;
        }
    }

    private boolean isReplicationCompleted(IProcessResult processResult) {
        if (GlobalOrderProcessResult.OK.equals(processResult)) {
            return true;
        }
        if (processResult instanceof MultiBucketSingleFileProcessResult) {
            return ((MultiBucketSingleFileProcessResult)processResult).isProcessed();
        }
        return false;
    }

    private void invokeAfterReplicatedChannelDataFilter(IReplicationOrderedPacket packet) {
        if (!this.isDataFiltered()) {
            return;
        }
        if (!packet.isDataPacket()) {
            return;
        }
        IReplicationPacketData<?> packetData = packet.getData();
        if (packetData.isSingleEntryData()) {
            this.getDataFilter().filterAfterReplicatedEntryData(packetData.getSingleEntryData(), this.getTargetLogicalVersion(), this.getGroupBacklog().getDataProducer(), this._specificLogger);
        } else {
            for (IReplicationPacketEntryData entryData : packetData) {
                this.getDataFilter().filterAfterReplicatedEntryData(entryData, this.getTargetLogicalVersion(), this.getGroupBacklog().getDataProducer(), this._specificLogger);
            }
        }
    }

    private void invokeAfterReplicatedChannelDataFilter(List<IReplicationOrderedPacket> packets) {
        if (!this.isDataFiltered()) {
            return;
        }
        for (IReplicationOrderedPacket packet : packets) {
            this.invokeAfterReplicatedChannelDataFilter(packet);
        }
    }

    private void trackPendingErrorIfNeeded(Throwable t, IReplicationOrderedPacket replicatedPacket) {
        if (t instanceof ReplicationException) {
            this.setPendingError(t, replicatedPacket);
        }
        if (t instanceof RuntimeException) {
            this.setPendingError(t, replicatedPacket);
        }
        if (t instanceof Error) {
            this.setPendingError(t, replicatedPacket);
        }
    }

    private void trackPendingErrorIfNeeded(Throwable t, List<IReplicationOrderedPacket> replicatedPackets) {
        if (t instanceof ReplicationException) {
            this.setPendingError(t, replicatedPackets);
        }
        if (t instanceof RuntimeException) {
            this.setPendingError(t, replicatedPackets);
        }
        if (t instanceof Error) {
            this.setPendingError(t, replicatedPackets);
        }
    }

    private void trackAndRethrowPendingErrorIfNeeded(Throwable t, IReplicationOrderedPacket replicatedPacket) throws RemoteException, ReplicationException {
        this.trackPendingErrorIfNeeded(t, replicatedPacket);
        if (t instanceof RemoteException) {
            throw (RemoteException)t;
        }
        if (t instanceof ReplicationException) {
            throw (ReplicationException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    private void trackAndRethrowPendingErrorIfNeeded(Throwable t, List<IReplicationOrderedPacket> replicatedPackets) throws RemoteException, ReplicationException {
        this.trackPendingErrorIfNeeded(t, replicatedPackets);
        if (t instanceof RemoteException) {
            throw (RemoteException)t;
        }
        if (t instanceof ReplicationException) {
            throw (ReplicationException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future replicateBatchAsyncAfterChannelFilter(List<IReplicationOrderedPacket> packets, final IAsyncReplicationListener listener, boolean containsDiscardedPacket) throws RemoteException {
        boolean containsDiscarded = this.invokeOutputFilterIfNeeded(packets, containsDiscardedPacket);
        final List<IReplicationOrderedPacket> finalPackets = packets;
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("Replicating filtered packets: " + ReplicationLogUtils.packetsToLogString(finalPackets));
        }
        final ReplicatedDataPacketResource replicatedDataPacketResource = this._packetsPool.get();
        boolean delegatedToAsync = false;
        try {
            BatchReplicatedDataPacket batchPacket = replicatedDataPacketResource.getBatchPacket();
            batchPacket.setBatch(finalPackets);
            if (this._isNetworkCompressionEnabled) {
                int originalSize = finalPackets.size();
                if (this._specificLogger.isLoggable(Level.FINEST)) {
                    this._specificLogger.finest("Compressing batch packets: " + ReplicationLogUtils.packetsToLogString(finalPackets));
                }
                batchPacket.compressBatch(containsDiscarded);
                if (this._specificLogger.isLoggable(Level.FINEST)) {
                    double compressionRatio = (double)batchPacket.getBatch().size() / (double)originalSize;
                    String msg = batchPacket.isCompressed() ? "Finished batch packets compression. compressionRatio=" + new DecimalFormat("#.##").format(compressionRatio) : "Batch is incompressible.";
                    this._specificLogger.finest(msg);
                }
            } else if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest("Discarded packets network compression is disabled");
            }
            AsyncFuture<Object> processResultFuture = this.getConnection().dispatchAsync(batchPacket);
            final ReplicateFuture resultFuture = new ReplicateFuture();
            processResultFuture.setListener(new AsyncFutureListener<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(AsyncResult<Object> wiredResult) {
                    Throwable error = null;
                    IProcessResult processResult = null;
                    try {
                        Exception exception = wiredResult.getException();
                        if (exception != null) {
                            throw exception;
                        }
                        processResult = AbstractReplicationSourceChannel.this._groupBacklog.fromWireForm(wiredResult.getResult());
                        AbstractReplicationSourceChannel.this.logProcessResultReceivedIfNecessary(processResult, finalPackets);
                        AbstractReplicationSourceChannel.this._groupBacklog.processResult(AbstractReplicationSourceChannel.this._memberName, processResult, finalPackets);
                        AbstractReplicationSourceChannel.this.invokeAfterReplicatedChannelDataFilter(finalPackets);
                        AbstractReplicationSourceChannel.this._statisticsCounter.add(finalPackets.size());
                        resultFuture.releaseOk();
                    }
                    catch (ReplicationException e) {
                        error = e;
                        AbstractReplicationSourceChannel.this.onAsyncReplicateErrorResult((Throwable)e, finalPackets);
                        resultFuture.releaseError(e);
                    }
                    catch (Throwable t) {
                        error = t;
                        AbstractReplicationSourceChannel.this.trackPendingErrorIfNeeded(t, finalPackets);
                        AbstractReplicationSourceChannel.this.onAsyncReplicateErrorResult(t, finalPackets);
                        resultFuture.releaseError(t);
                    }
                    finally {
                        replicatedDataPacketResource.release();
                        if (listener != null) {
                            if (error != null) {
                                listener.onReplicateFailed(error);
                            } else {
                                listener.onReplicateSucceeded(processResult);
                            }
                        }
                    }
                }
            });
            delegatedToAsync = true;
            ReplicateFuture replicateFuture = resultFuture;
            return replicateFuture;
        }
        finally {
            if (!delegatedToAsync) {
                replicatedDataPacketResource.release();
            }
        }
    }

    private void logProcessResultIfNecessary(IProcessResult processResult, IReplicationOrderedPacket packet) {
        if (this._specificVerboseLogger.isLoggable(Level.FINEST)) {
            this._specificVerboseLogger.finest("Received " + processResult.toString() + " for packet replication [packetKey=" + packet.getKey() + "]");
        }
    }

    private void logProcessResultReceivedIfNecessary(IProcessResult processResult, List<IReplicationOrderedPacket> packets) {
        if (this._specificVerboseLogger.isLoggable(Level.FINEST)) {
            String packetsBatchText = packets.isEmpty() ? "EMPTY" : "firstPacketKey=" + packets.get(0).getKey() + ", lastPacketKey=" + packets.get(packets.size() - 1).getEndKey();
            this._specificVerboseLogger.finest("Received " + processResult.toString() + " for packets batch replication [" + packetsBatchText + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future replicateAsyncAfterChannelFilter(IReplicationOrderedPacket packet) throws RemoteException {
        final IReplicationOrderedPacket finalPacket = this.invokeOutputFilterIfNeeded(packet);
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("Replicating filtered packet: " + finalPacket);
        }
        final ReplicatedDataPacketResource replicatedDataPacketResource = this._packetsPool.get();
        boolean delegatedToAsync = false;
        try {
            ReplicatedDataPacket replicatedPacket = replicatedDataPacketResource.getPacket();
            replicatedPacket.setPacket(finalPacket);
            AsyncFuture<Object> processResultFuture = this.getConnection().dispatchAsync(replicatedPacket);
            final ReplicateFuture resultFuture = new ReplicateFuture();
            processResultFuture.setListener(new AsyncFutureListener<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(AsyncResult<Object> wiredResult) {
                    try {
                        Exception exception = wiredResult.getException();
                        if (exception != null) {
                            throw exception;
                        }
                        IProcessResult processResult = AbstractReplicationSourceChannel.this._groupBacklog.fromWireForm(wiredResult.getResult());
                        AbstractReplicationSourceChannel.this.logProcessResultIfNecessary(processResult, finalPacket);
                        AbstractReplicationSourceChannel.this._groupBacklog.processResult(AbstractReplicationSourceChannel.this._memberName, processResult, finalPacket);
                        AbstractReplicationSourceChannel.this.invokeAfterReplicatedChannelDataFilter(finalPacket);
                        AbstractReplicationSourceChannel.this._statisticsCounter.increment();
                        resultFuture.releaseOk();
                    }
                    catch (Throwable t) {
                        AbstractReplicationSourceChannel.this.trackPendingErrorIfNeeded(t, finalPacket);
                        AbstractReplicationSourceChannel.this.onAsyncReplicateErrorResult(t, finalPacket);
                        resultFuture.releaseError(t);
                    }
                    finally {
                        replicatedDataPacketResource.release();
                    }
                }
            });
            delegatedToAsync = true;
            ReplicateFuture replicateFuture = resultFuture;
            return replicateFuture;
        }
        finally {
            if (!delegatedToAsync) {
                replicatedDataPacketResource.release();
            }
        }
    }

    protected abstract void onAsyncReplicateErrorResult(Throwable var1, List<IReplicationOrderedPacket> var2);

    protected abstract void onAsyncReplicateErrorResult(Throwable var1, IReplicationOrderedPacket var2);

    protected void replicateBatchDelayed(List<IReplicationOrderedPacket> packets) throws RemoteException, ReplicationException {
        boolean containsDiscardedPacket = this.beforeDelayedReplication(packets);
        this.replicateBatchAfterChannelFilter(packets, containsDiscardedPacket);
    }

    protected void replicateBatchDelayedAsync(List<IReplicationOrderedPacket> packets, IAsyncReplicationListener listener) throws RemoteException {
        boolean containsDiscardedPacket = this.beforeDelayedReplication(packets);
        this.replicateBatchAsyncAfterChannelFilter(packets, listener, containsDiscardedPacket);
    }

    private boolean invokeOutputFilterIfNeeded(List<IReplicationOrderedPacket> packets, boolean containsDiscardedPacket) {
        if (!this._isOutFiltered) {
            return containsDiscardedPacket;
        }
        ListIterator<IReplicationOrderedPacket> it = packets.listIterator();
        while (it.hasNext()) {
            IReplicationOrderedPacket packet = it.next();
            if (packet.getData().supportsReplicationFilter()) {
                it.set(this.invokeOutputFilter(packet));
                if (containsDiscardedPacket) continue;
                containsDiscardedPacket = packet.isDiscardedPacket();
                continue;
            }
            it.set(packet);
        }
        return containsDiscardedPacket;
    }

    private IReplicationOrderedPacket invokeOutputFilterIfNeeded(IReplicationOrderedPacket packet) {
        if (!this._isOutFiltered || !packet.getData().supportsReplicationFilter()) {
            return packet;
        }
        return this.invokeOutputFilter(packet);
    }

    private IReplicationOrderedPacket invokeOutputFilter(IReplicationOrderedPacket packet) {
        IReplicationOrderedPacket clonedPacket;
        IReplicationOrderedPacket result = clonedPacket = packet.clone();
        IReplicationPacketData<?> data = clonedPacket.getData();
        Iterable<IReplicationFilterEntry> filterEntries = this.getGroupBacklog().getDataProducer().toFilterEntries(data);
        for (IReplicationFilterEntry filterEntry : filterEntries) {
            try {
                this._outFilter.filterOut(filterEntry, this.getMemberName(), this.getGroupName());
            }
            catch (Exception e) {
                if (!this._specificLogger.isLoggable(Level.WARNING)) continue;
                this._specificLogger.log(Level.WARNING, "Replication filter caused an exception when filtering entry [" + filterEntry + "]", e);
            }
        }
        if (data.isEmpty()) {
            if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest("Packet [" + packet.toString() + "] discarded by replication output filter.");
            }
            result = this.getGroupBacklog().replaceWithDiscarded(clonedPacket, false);
        }
        return result;
    }

    private synchronized void setPendingError(Throwable error, List<IReplicationOrderedPacket> replicatedPackets) {
        this._groupBacklog.setPendingError(this.getMemberName(), error, replicatedPackets);
    }

    private synchronized void setPendingError(Throwable error, IReplicationOrderedPacket replicatedPacket) {
        this._groupBacklog.setPendingError(this.getMemberName(), error, replicatedPacket);
    }

    private void logConnectionStateChange(ChannelState oldState, ChannelState newState, Level logLevel) {
        String msg = oldState != newState ? "Channel state changed from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState) : "Channel state is " + (Object)((Object)newState);
        msg = msg + " " + this.getConnectionDescription();
        this.logEventInHistory(msg);
        if (this._specificLogger.isLoggable(logLevel)) {
            this._specificLogger.log(logLevel, msg);
        }
    }

    private String getConnectionDescription() {
        return "[target=" + ReplicationLogUtils.toShortLookupName(this.getMemberName()) + ", target url=" + this.getConnection().getConnectionUrl() + ", target machine connection url=" + this.getConnection().getClosestEndpointAddress() + "]";
    }

    protected List<IReplicationOrderedPacket> getPendingPackets(int batchSize) {
        return this._groupBacklog.getPackets(this.getMemberName(), batchSize, this.getDataFilter(), this.getTargetLogicalVersion(), this._specificLogger);
    }

    private boolean invokeBeforeReplicatingChannelDataFilter(List<IReplicationOrderedPacket> packets) {
        boolean containsDiscardedPacket = false;
        if (!this.isDataFiltered()) {
            return containsDiscardedPacket;
        }
        ListIterator<IReplicationOrderedPacket> iterator = packets.listIterator();
        IReplicationOrderedPacket previousDiscardedPacket = null;
        while (iterator.hasNext()) {
            IReplicationOrderedPacket packet = iterator.next();
            IReplicationOrderedPacket filterPacket = ReplicationChannelDataFilterHelper.filterPacket(this.getDataFilter(), this.getTargetLogicalVersion(), packet, this.getGroupBacklog().getDataProducer(), this.getGroupBacklog(), previousDiscardedPacket, this._specificLogger, this._memberName);
            if (previousDiscardedPacket == filterPacket) {
                iterator.remove();
            }
            if (previousDiscardedPacket == null) {
                iterator.set(filterPacket);
                if (filterPacket.isDiscardedPacket()) {
                    previousDiscardedPacket = filterPacket;
                }
            } else if (previousDiscardedPacket != filterPacket) {
                iterator.set(filterPacket);
                IReplicationOrderedPacket iReplicationOrderedPacket = previousDiscardedPacket = filterPacket.isDiscardedPacket() ? filterPacket : null;
            }
            if (containsDiscardedPacket) continue;
            containsDiscardedPacket = filterPacket.isDiscardedPacket();
        }
        return containsDiscardedPacket;
    }

    private IReplicationOrderedPacket invokeBeforeReplicatingChannelDataFilter(IReplicationOrderedPacket packet) {
        if (!this.isDataFiltered()) {
            return packet;
        }
        IReplicationOrderedPacket filterPacket = ReplicationChannelDataFilterHelper.filterPacket(this.getDataFilter(), this.getTargetLogicalVersion(), packet, this.getGroupBacklog().getDataProducer(), this.getGroupBacklog(), null, this._specificLogger, this._memberName);
        return filterPacket;
    }

    public void sampleStatistics() {
        long currentTime = SystemTime.timeMillis();
        int operationsDone = this._statisticsCounter.get();
        this._statisticsCounter.reset();
        long intervalFromLastSample = currentTime - this._throughPutStatistics.getLastTimeStamp();
        if (intervalFromLastSample == 0L) {
            return;
        }
        int sampleTP = (int)((float)operationsDone / (float)intervalFromLastSample * 1000.0f);
        this._throughPutStatistics.addSample(currentTime, sampleTP);
        long generatedTraffic = this.getConnection().getGeneratedTraffic();
        long generatedTrafficTP = -1L;
        if (generatedTraffic >= this._lastSampledGeneratedTraffic) {
            generatedTrafficTP = (long)((float)(generatedTraffic - this._lastSampledGeneratedTraffic) / (float)intervalFromLastSample * 1000.0f);
            this._generatedTrafficStatistics.addSample(currentTime, generatedTrafficTP);
        }
        this._lastSampledGeneratedTraffic = generatedTraffic;
        long receivedTraffic = this.getConnection().getReceivedTraffic();
        long receivedTrafficTP = -1L;
        if (receivedTraffic >= this._lastSampledReceivedTraffic) {
            receivedTrafficTP = (long)((float)(receivedTraffic - this._lastSampledReceivedTraffic) / (float)intervalFromLastSample * 1000.0f);
            this._receivedTrafficStatistics.addSample(currentTime, receivedTrafficTP);
        }
        this._lastSampledReceivedTraffic = receivedTraffic;
        this._totalNumberOfReplicatedPackets += (long)operationsDone;
        if (this._specificVerboseLogger.isLoggable(Level.FINEST)) {
            this._specificVerboseLogger.finest("sampled packets throughput [" + sampleTP + "] generated traffic throughput [" + generatedTrafficTP + "] received traffic throughput [" + receivedTrafficTP + "]");
        }
    }

    protected int getLastSampledTP() {
        return this._throughPutStatistics.getLastSample();
    }

    protected int getSampleTPBefore(long timeBefore, TimeUnit unit) {
        return this._throughPutStatistics.getSampleBefore(timeBefore, unit);
    }

    public boolean isInconsistent() {
        return this._inconsistentDuringHandshakeState || this._groupBacklog.getState(this.getMemberName()).isInconsistent();
    }

    protected Throwable getInconsistencyReason() {
        if (this._inconsistentDuringHandshakeStateReason != null) {
            return this._inconsistentDuringHandshakeStateReason;
        }
        IBacklogMemberState memberState = this._groupBacklog.getState(this.getMemberName());
        if (!memberState.isInconsistent()) {
            return null;
        }
        return memberState.getInconsistencyReason();
    }

    public IReplicationSourceChannelStatistics getStatistics() {
        long lastConfirmedKey = this.getGroupBacklog().getState(this.getMemberName()).getLastConfirmedKey();
        long generatedTraffic = this.getConnection().getGeneratedTraffic();
        long receivedTraffic = this.getConnection().getReceivedTraffic();
        long generatedTrafficTP = this._generatedTrafficStatistics.getLastSample();
        long receivedTrafficTP = this._receivedTrafficStatistics.getLastSample();
        int lastSampledTP = this.getLastSampledTP();
        long generatedTrafficPerPacket = lastSampledTP == 0 ? 0L : (long)((double)generatedTrafficTP / (double)lastSampledTP);
        ReplicationEndpointDetails endpointDetails = this.getTargetReplicationEndpointDetails();
        ConnectionEndpointDetails delegatorDetails = this.getConnection().getClosestEndpointDetails();
        if (delegatorDetails == null) {
            delegatorDetails = this._delegatorEndpointDetails;
        }
        if (delegatorDetails != null && endpointDetails != null && delegatorDetails.equals(endpointDetails.getConnectionDetails())) {
            delegatorDetails = null;
        }
        return new ReplicationSourceChannelStatistics(this.getMemberName(), this._channelType, this.getConnection().getState(), this.isActive(), lastConfirmedKey, lastSampledTP, this._totalNumberOfReplicatedPackets, this.isInconsistent() ? this.getInconsistencyReason() : null, generatedTraffic, receivedTraffic, generatedTrafficTP, receivedTrafficTP, generatedTrafficPerPacket, this.getGroupBacklog().size(this.getMemberName()), this.getChannelOpertingMode(), endpointDetails, delegatorDetails);
    }

    public void registerWith(MetricRegistrator metricRegister) {
        metricRegister.register("total-replicated-packets", new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return AbstractReplicationSourceChannel.this._totalNumberOfReplicatedPackets;
            }
        });
        metricRegister.register("generated-traffic-bytes", new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return AbstractReplicationSourceChannel.this.getConnection().getGeneratedTraffic();
            }
        });
        metricRegister.register("received-traffic-bytes", new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return AbstractReplicationSourceChannel.this.getConnection().getReceivedTraffic();
            }
        });
        metricRegister.register("retained-size-packets", new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return AbstractReplicationSourceChannel.this.getGroupBacklog().size(AbstractReplicationSourceChannel.this.getMemberName());
            }
        });
    }

    public abstract ReplicationStatistics.ReplicationOperatingMode getChannelOpertingMode();

    public abstract void flushPendingReplication();

    public void replicate(IReplicationUnreliableOperation operation) {
        if (operation == null) {
            return;
        }
        if (this.isActive()) {
            if (this.isDataFiltered() && !this.getDataFilter().filterBeforeReplicatingUnreliableOperation(operation, this.getTargetLogicalVersion())) {
                if (this._specificLogger.isLoggable(Level.FINEST)) {
                    this._specificLogger.finest("Filtered unreliable operation: " + operation);
                }
                return;
            }
            if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest("Replicating unreliable operation: " + operation);
            }
            try {
                this.getConnection().dispatch(new UnreliableOperationPacket(this.getGroupName(), operation));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public String dumpState() {
        return "Channel [" + this.getMemberName() + "] state [" + (Object)((Object)this._channelState) + "]:" + StringUtils.NEW_LINE + "Type [" + this.getClass().getName() + "]" + StringUtils.NEW_LINE + "last measured send packets throughput [" + this.getLastSampledTP() + "]" + StringUtils.NEW_LINE + "inconsistent [" + this.isInconsistent() + "]" + StringUtils.NEW_LINE + "synchronizing [" + this.isSynchronizing() + "]" + this.onDumpState() + StringUtils.NEW_LINE + this.getConnection().dumpState() + StringUtils.NEW_LINE + "latest history:" + StringUtils.NEW_LINE + this.dumpHistory();
    }

    protected String onDumpState() {
        return "";
    }

    private String dumpHistory() {
        return this._groupHistory.outputDescendingEvents(this.getMemberName());
    }

    public ReplicationEndpointDetails getTargetReplicationEndpointDetails() {
        return this._targetEndpointDetails;
    }

    protected PlatformLogicalVersion getTargetLogicalVersion() {
        PlatformLogicalVersion result = null;
        ReplicationEndpointDetails targetEndpointDetails = this._targetEndpointDetails;
        if (targetEndpointDetails != null) {
            result = targetEndpointDetails.getPlatformLogicalVersion();
        }
        PlatformLogicalVersion connectionTargetLogicalVersion = this._connection.getClosestEndpointLogicalVersion();
        if (result == null) {
            return connectionTargetLogicalVersion;
        }
        return PlatformLogicalVersion.minimum((PlatformLogicalVersion)connectionTargetLogicalVersion, (PlatformLogicalVersion)result);
    }

    private boolean requiresHighLevelLogging() {
        if (this._channelType == null) {
            return true;
        }
        switch (this._channelType) {
            case ACTIVE_SPACE: 
            case BACKUP_SPACE: 
            case MIRROR: 
            case GATEWAY: {
                return true;
            }
            case DURABLE_NOTIFICATION: 
            case LOCAL_VIEW: {
                return false;
            }
        }
        return true;
    }

    private class IterativeHandshakeHandler
    extends AsyncCallable {
        private final IHandshakeContext _handshakeContext;

        public IterativeHandshakeHandler(IHandshakeContext handshakeContext) {
            this._handshakeContext = handshakeContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            AbstractReplicationSourceChannel abstractReplicationSourceChannel = AbstractReplicationSourceChannel.this;
            synchronized (abstractReplicationSourceChannel) {
                if (AbstractReplicationSourceChannel.this.isClosed()) {
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                if (AbstractReplicationSourceChannel.this._channelState == ChannelState.DISCONNECTED) {
                    AbstractReplicationSourceChannel.this._iterativeHandshakeHandler = null;
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                IHandshakeIteration nextHandshakeIteration = AbstractReplicationSourceChannel.this.getGroupBacklog().getNextHandshakeIteration(AbstractReplicationSourceChannel.this.getMemberName(), this._handshakeContext);
                try {
                    AbstractReplicationSourceChannel.this.getConnection().dispatch(new IterativeHandshakePacket(AbstractReplicationSourceChannel.this.getGroupName(), nextHandshakeIteration));
                    if (!this._handshakeContext.isDone()) {
                        if (AbstractReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                            AbstractReplicationSourceChannel.this._specificLogger.finer("Handshake is incomplete: " + this._handshakeContext.toLogMessage());
                        }
                        return IAsyncHandlerProvider.CycleResult.CONTINUE;
                    }
                    AbstractReplicationSourceChannel.this._specificLogger.fine("Handshake completed - channel is active");
                    AbstractReplicationSourceChannel.this.moveToActive();
                    AbstractReplicationSourceChannel.this._iterativeHandshakeHandler = null;
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                catch (RemoteException e) {
                    AbstractReplicationSourceChannel.this._iterativeHandshakeHandler = null;
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                catch (Throwable t) {
                    if (AbstractReplicationSourceChannel.this._specificLogger.isLoggable(Level.SEVERE)) {
                        AbstractReplicationSourceChannel.this._specificLogger.log(Level.SEVERE, "Error occurred while executing iterative handshake, replication is disabled until the error is resolved " + AbstractReplicationSourceChannel.this.getConnectionDescription(), t);
                    }
                    AbstractReplicationSourceChannel.this.moveToInconsistentState(t);
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
            }
        }
    }

    private class InconsistentStateHandler
    extends AsyncCallable {
        private InconsistentStateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            AbstractReplicationSourceChannel abstractReplicationSourceChannel = AbstractReplicationSourceChannel.this;
            synchronized (abstractReplicationSourceChannel) {
                if (AbstractReplicationSourceChannel.this.isClosed()) {
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                AbstractReplicationSourceChannel.this._specificLogger.finest("Inconsistent state handler waken up");
                if (!AbstractReplicationSourceChannel.this._inconsistentDuringHandshakeState) {
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                AbstractReplicationSourceChannel.this.connectChannel();
                if (!AbstractReplicationSourceChannel.this._inconsistentDuringHandshakeState) {
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                AbstractReplicationSourceChannel.this._specificLogger.finest("Channel is still at inconsistent state, waiting for next retry");
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
        }
    }

    public static enum ChannelState {
        CONNECTED,
        ACTIVE,
        DISCONNECTED;

    }
}

