/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.cluster.replication.ConsistencyLevelViolationException;
import com.gigaspaces.internal.cluster.node.impl.EventsTracer;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.MemberAddedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.SourceChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceChannelStatistics;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStatistics;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationSourceGroupStatistics;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.GroupConsistencyLevelPolicy;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractReplicationSourceGroup<T extends SourceGroupConfig>
implements IReplicationSourceGroup,
IReplicationGroupHistory,
DynamicSourceGroupConfigHolder.IDynamicSourceGroupStateListener {
    protected final Logger _specificLogger;
    private final IReplicationRouter _replicationRouter;
    private final DynamicSourceGroupConfigHolder _groupConfigHolder;
    private final Map<String, AbstractReplicationSourceChannel> _channels;
    private final IReplicationGroupBacklog _groupBacklog;
    private final String _myLookupName;
    private final IReplicationOutFilter _outFilter;
    protected final Object _channelCreationLock = new Object();
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final IReplicationSourceGroupStateListener _stateListener;
    private final ConcurrentMap<String, EventsTracer<String>> _groupChannelsHistory;
    private final EventsTracer<String> _groupHistory;
    private volatile boolean _closed;

    public AbstractReplicationSourceGroup(DynamicSourceGroupConfigHolder groupConfigHolder, IReplicationRouter replicationRouter, IReplicationGroupBacklog groupBacklog, String myLookupName, IReplicationOutFilter outFilter, IAsyncHandlerProvider asyncHandlerProvider, IReplicationSourceGroupStateListener stateListener) {
        this.validateGroupConsistencyLevelPolicy(groupConfigHolder.getConfig().getGroupConsistencyLevelPolicy(), groupConfigHolder.getConfig());
        this._groupConfigHolder = groupConfigHolder;
        this._replicationRouter = replicationRouter;
        this._groupBacklog = groupBacklog;
        this._myLookupName = myLookupName;
        this._outFilter = outFilter;
        this._asyncHandlerProvider = asyncHandlerProvider;
        this._stateListener = stateListener;
        this._channels = new CopyOnUpdateMap<String, AbstractReplicationSourceChannel>();
        this._groupChannelsHistory = new CopyOnUpdateMap<String, EventsTracer<String>>();
        this._groupHistory = new EventsTracer(this._groupConfigHolder.getConfig().getHistoryLength());
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.group." + this._groupConfigHolder.getConfig().getName());
        this._groupBacklog.setGroupHistory(this);
        this._groupConfigHolder.addListener(this);
    }

    protected void validateGroupConsistencyLevelPolicy(GroupConsistencyLevelPolicy groupConsistencyLevelPolicy, T sourceGroupConfig) {
        if (GroupConsistencyLevelPolicy.isEmptyPolicy(groupConsistencyLevelPolicy)) {
            return;
        }
        throw new IllegalArgumentException("Replication group of type [" + this.getClass() + "] does not support consistency level policy [" + groupConsistencyLevelPolicy.getClass() + "]");
    }

    @Override
    public void logEvent(String memberName, String event) {
        EventsTracer<String> eventsTracer = this.getEventsTracer(memberName);
        eventsTracer.logEvent(event);
    }

    @Override
    public void logGroupEvent(String event) {
        this._groupHistory.logEvent(event);
    }

    private EventsTracer<String> getEventsTracer(String memberName) {
        EventsTracer<String> previous;
        EventsTracer eventsTracer = (EventsTracer)this._groupChannelsHistory.get(memberName);
        if (eventsTracer == null && (previous = this._groupChannelsHistory.putIfAbsent(memberName, eventsTracer = new EventsTracer(this.getConfigHolder().getConfig().getHistoryLength()))) != null) {
            return previous;
        }
        return eventsTracer;
    }

    @Override
    public String outputDescendingEvents(String memberName) {
        return this.getEventsTracer(memberName).outputDescendingEvents();
    }

    public EventsTracer<String> getChannelHistory(String memberName) {
        return (EventsTracer)this._groupChannelsHistory.get(memberName);
    }

    public String getMyLookupName() {
        return this._myLookupName;
    }

    public IReplicationOutFilter getOutFilter() {
        return this._outFilter;
    }

    public IReplicationSourceGroupStateListener getStateListener() {
        return this._stateListener;
    }

    public IAsyncHandlerProvider getAsyncHandlerProvider() {
        return this._asyncHandlerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReplicationChannels() {
        Object object = this._channelCreationLock;
        synchronized (object) {
            SourceGroupConfig config = this._groupConfigHolder.getConfig();
            for (String memberLookupName : config.getMembersLookupNames()) {
                this.createChannel(memberLookupName, false, config, false, null);
                if (!this._specificLogger.isLoggable(Level.FINEST)) continue;
                this._specificLogger.finest(this.getLogPrefix() + "created channel to " + memberLookupName);
            }
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finest(this.getLogPrefix() + "created all channels");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeReplicationChannels() {
        Object object = this._channelCreationLock;
        synchronized (object) {
            for (AbstractReplicationSourceChannel channel : this._channels.values()) {
                channel.close();
                if (!this._specificLogger.isLoggable(Level.FINEST)) continue;
                this._specificLogger.finest(this.getLogPrefix() + "closed channel to " + channel.getMemberName());
            }
            this._channels.clear();
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finest(this.getLogPrefix() + "closed all channels");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberAdded(MemberAddedEvent memberAddedEvent, SourceGroupConfig newConfig) {
        Object object = this._channelCreationLock;
        synchronized (object) {
            this._groupBacklog.memberAdded(memberAddedEvent, newConfig);
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("adding new member [" + memberAddedEvent.getMemberName() + "] to replication group");
            }
            this.onMemberAdded(memberAddedEvent, newConfig);
            this.logGroupEvent("new member [" + memberAddedEvent.getMemberName() + "] added to group");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberRemoved(String memberName, SourceGroupConfig newConfig) {
        Object object = this._channelCreationLock;
        synchronized (object) {
            AbstractReplicationSourceChannel channel;
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("removing member [" + memberName + "] from replication group");
            }
            if ((channel = this._channels.remove(memberName)) != null) {
                channel.close();
            }
            this._groupBacklog.memberRemoved(memberName, newConfig);
            this.onMemberRemoved(memberName, newConfig);
            this.logGroupEvent("removed member [" + memberName + "] from group");
        }
    }

    protected void onMemberRemoved(String memberName, SourceGroupConfig newConfig) {
    }

    protected void onMemberAdded(MemberAddedEvent memberAddedEvent, SourceGroupConfig newConfig) {
        this.createChannel(memberAddedEvent.getMemberName(), true, newConfig, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTemporaryChannel(String memberName, Object customBacklogMetadata) {
        Object object = this._channelCreationLock;
        synchronized (object) {
            this.createChannel(memberName, false, this.getConfigHolder().getConfig(), true, customBacklogMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeTemporaryChannel(String sourceMemberName) {
        Object object = this._channelCreationLock;
        synchronized (object) {
            AbstractReplicationSourceChannel channel = this._channels.remove(sourceMemberName);
            if (channel != null) {
                channel.close();
                this.onCloseTemporaryChannel(sourceMemberName, channel);
            }
        }
    }

    protected abstract void onCloseTemporaryChannel(String var1, AbstractReplicationSourceChannel var2);

    protected void createChannel(String memberLookupName, boolean dynamicMember, SourceGroupConfig config, boolean connectSynchronously, Object customBacklogMetadata) {
        IReplicationMonitoredConnection connection = connectSynchronously ? this._replicationRouter.getMemberConnection(memberLookupName) : this._replicationRouter.getMemberConnectionAsync(memberLookupName);
        AbstractReplicationSourceChannel channel = this.createChannel(memberLookupName, this._replicationRouter, connection, config.getFilter(memberLookupName), this, dynamicMember, config, customBacklogMetadata);
        this._channels.put(memberLookupName, channel);
    }

    @Override
    public int execute(IReplicationGroupOutContext groupContext) {
        int completed = this.executeImpl(groupContext);
        groupContext.clear();
        return completed;
    }

    protected abstract int executeImpl(IReplicationGroupOutContext var1);

    @Override
    public void execute(IReplicationUnreliableOperation operation) {
        for (AbstractReplicationSourceChannel channel : this._channels.values()) {
            channel.replicate(operation);
        }
    }

    protected abstract AbstractReplicationSourceChannel createChannel(String var1, IReplicationRouter var2, IReplicationMonitoredConnection var3, IReplicationChannelDataFilter var4, IReplicationGroupHistory var5, boolean var6, SourceGroupConfig var7, Object var8);

    @Override
    public String getGroupName() {
        return this._groupConfigHolder.getConfig().getName();
    }

    @Override
    public DynamicSourceGroupConfigHolder getConfigHolder() {
        return this._groupConfigHolder;
    }

    protected AbstractReplicationSourceChannel getChannel(String memberLookupName) {
        return this._channels.get(memberLookupName);
    }

    @Override
    public void beginSynchronizing(String synchronizingMemberLookupName, Object synchronizingSourceUniqueId, boolean isDirectPersistencySync) {
        AbstractReplicationSourceChannel channel = this.getChannelSafe(synchronizingMemberLookupName);
        channel.beginSynchronizing(isDirectPersistencySync);
    }

    @Override
    public void beginSynchronizing(String synchronizingMemberLookupName, Object synchronizingSourceUniqueId) {
        this.beginSynchronizing(synchronizingMemberLookupName, synchronizingSourceUniqueId, false);
    }

    protected AbstractReplicationSourceChannel getChannelSafe(String synchronizingMemberLookupName) {
        AbstractReplicationSourceChannel channel = this._channels.get(synchronizingMemberLookupName);
        if (channel == null) {
            throw new IllegalArgumentException("No channel to specified member exists [" + synchronizingMemberLookupName + "], existing channels are " + Arrays.toString(this._channels.keySet().toArray()));
        }
        return channel;
    }

    @Override
    public boolean synchronizationDataGenerated(String synchronizingMemberLookupName, String uid) {
        AbstractReplicationSourceChannel channel = this.getChannelSafe(synchronizingMemberLookupName);
        return channel.synchronizationDataGenerated(uid);
    }

    @Override
    public void synchronizationCopyStageDone(String synchronizingMemberLookupName) {
        AbstractReplicationSourceChannel channel = this.getChannelSafe(synchronizingMemberLookupName);
        channel.synchronizationCopyStageDone();
    }

    @Override
    public void stopSynchronization(String synchronizingMemberLookupName) {
        AbstractReplicationSourceChannel channel = this._channels.get(synchronizingMemberLookupName);
        if (channel != null) {
            channel.stopSynchronization();
        }
    }

    @Override
    public boolean checkChannelConnected(String sourceMemberLookupName) {
        AbstractReplicationSourceChannel channel = this.getChannelSafe(sourceMemberLookupName);
        return channel.pingTarget();
    }

    @Override
    public ReplicationEndpointDetails getChannelEndpointDetails(String sourceMemberLookupName) {
        AbstractReplicationSourceChannel channel = this._channels.get(sourceMemberLookupName);
        return channel != null ? channel.getTargetReplicationEndpointDetails() : null;
    }

    @Override
    public IReplicationGroupBacklog getGroupBacklog() {
        return this._groupBacklog;
    }

    @Override
    public void close() {
        if (this._closed) {
            return;
        }
        this.onClose();
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("closing replication group");
        }
        for (AbstractReplicationSourceChannel channel : this._channels.values()) {
            channel.close();
        }
        this.getGroupBacklog().close();
        this._closed = true;
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("replication group closed");
        }
    }

    protected void onClose() {
    }

    @Override
    public Map<String, Boolean> getChannelsStatus() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Map.Entry<String, AbstractReplicationSourceChannel> entry : this._channels.entrySet()) {
            result.put(entry.getKey(), entry.getValue().isActive());
        }
        return result;
    }

    protected String getLogPrefix() {
        return "Replication [" + this._myLookupName + "]: ";
    }

    @Override
    public void setActive(MetricRegistrator metricRegistrator) {
    }

    @Override
    public void setPassive(boolean closeProxy) {
    }

    public Map<String, AbstractReplicationSourceChannel> getChannels() {
        return this._channels;
    }

    @Override
    public void sampleStatistics() {
        for (AbstractReplicationSourceChannel channel : this._channels.values()) {
            channel.sampleStatistics();
        }
    }

    @Override
    public IReplicationSourceGroupStatistics getStatistics() {
        LinkedList<IReplicationSourceChannelStatistics> channelStats = new LinkedList<IReplicationSourceChannelStatistics>();
        for (AbstractReplicationSourceChannel channel : this._channels.values()) {
            channelStats.add(channel.getStatistics());
        }
        return new ReplicationSourceGroupStatistics(channelStats);
    }

    @Override
    public void registerWith(MetricRegistrator metricRegister) {
        for (AbstractReplicationSourceChannel channel : this._channels.values()) {
            channel.registerWith(metricRegister.extend(channel.getMemberName()));
        }
    }

    @Override
    public void monitorConsistencyLevel() throws ConsistencyLevelViolationException {
    }

    @Override
    public boolean flushPendingReplication(long timeout, TimeUnit units) {
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine(this.getLogPrefix() + "flushing pending replication");
        }
        Collection<AbstractReplicationSourceChannel> channels = this._channels.values();
        for (AbstractReplicationSourceChannel sourceChannel : channels) {
            sourceChannel.flushPendingReplication();
        }
        long remainingTime = units.toMillis(timeout);
        int sleepTime = 50;
        long runningTime = 0L;
        while (remainingTime >= 0L) {
            boolean done = true;
            long weightToReplicate = 0L;
            for (AbstractReplicationSourceChannel sourceChannel : channels) {
                long channelBacklogWeight = this.getGroupBacklog().getWeight(sourceChannel.getMemberName());
                if (!sourceChannel.isActive() || channelBacklogWeight <= 0L) continue;
                done = false;
                weightToReplicate = Math.max(channelBacklogWeight, weightToReplicate);
            }
            if (done) {
                if (this._specificLogger.isLoggable(Level.FINE)) {
                    this._specificLogger.fine(this.getLogPrefix() + "flushing pending replication completed");
                }
                return true;
            }
            if (remainingTime == 0L) {
                if (this._specificLogger.isLoggable(Level.WARNING)) {
                    this._specificLogger.log(Level.WARNING, this.getLogPrefix() + "failed flush of pending replication due to incomplete replication:" + this.buildingPendingReplicationMsg());
                }
                return false;
            }
            if (remainingTime <= 0L) continue;
            try {
                if (runningTime % 5000L == 0L && this._specificLogger.isLoggable(Level.INFO)) {
                    this._specificLogger.info(this.getLogPrefix() + "waiting for replication of " + weightToReplicate + " weight to complete [Time remaining " + JSpaceUtilities.formatMillis(remainingTime) + "]:" + this.buildingPendingReplicationMsg());
                }
                Thread.sleep(50L);
                runningTime += 50L;
                remainingTime -= 50L;
            }
            catch (InterruptedException e) {
                if (this._specificLogger.isLoggable(Level.WARNING)) {
                    this._specificLogger.log(Level.WARNING, this.getLogPrefix() + "failed replication orderly shutdown", e);
                }
                Thread.currentThread().interrupt();
                return false;
            }
        }
        if (this._specificLogger.isLoggable(Level.WARNING)) {
            this._specificLogger.log(Level.WARNING, this.getLogPrefix() + "failed flush of pending replication due to incomplete replication:" + this.buildingPendingReplicationMsg());
        }
        return false;
    }

    protected void scanAndRemoveDroppedMembers() {
        SourceGroupConfig config = this.getConfigHolder().getConfig();
        BacklogConfig backlogConfig = config.getBacklogConfig();
        for (String memberName : this.getPotentialRemovedMembers(config)) {
            try {
                long timeDisconnected;
                Long timeOfDisconnection;
                AbstractReplicationSourceChannel channel;
                IBacklogMemberState state;
                if (backlogConfig.isLimited(memberName) && config.getBacklogConfig().getLimitReachedPolicy(memberName) == BacklogConfig.LimitReachedPolicy.DROP_MEMBER && (state = this._groupBacklog.getState(memberName)).isBacklogDropped()) {
                    String msg = "member [" + memberName + "] backlog is dropped due to capacity limitations, this member will be removed from the group";
                    if (this._specificLogger.isLoggable(Level.INFO)) {
                        this._specificLogger.info(msg);
                    }
                    this.logGroupEvent(msg);
                    this.getConfigHolder().removeMember(memberName);
                    this._replicationRouter.getAdmin().removeRemoteStubHolder(memberName);
                    continue;
                }
                Object channelConfig = config.getChannelConfig(memberName);
                if (channelConfig == null || ((SourceChannelConfig)channelConfig).getMaxAllowedDisconnectionTimeBeforeDrop() == -1L || (channel = this.getChannel(memberName)) == null || channel.getConnection().getState() != ConnectionState.DISCONNECTED || (timeOfDisconnection = channel.getConnection().getTimeOfDisconnection()) == null || (timeDisconnected = SystemTime.timeMillis() - timeOfDisconnection) <= ((SourceChannelConfig)channelConfig).getMaxAllowedDisconnectionTimeBeforeDrop()) continue;
                String msg = "member [" + memberName + "] is disconnected for [" + timeDisconnected + "ms] and is being dropped due to disconnection time limitations [" + ((SourceChannelConfig)channelConfig).getMaxAllowedDisconnectionTimeBeforeDrop() + "ms], this member will be removed from the group";
                if (this._specificLogger.isLoggable(Level.INFO)) {
                    this._specificLogger.info(msg);
                }
                this.logGroupEvent(msg);
                this.getConfigHolder().removeMember(memberName);
                this._replicationRouter.getAdmin().removeRemoteStubHolder(memberName);
            }
            catch (Exception e) {
                if (!this._specificLogger.isLoggable(Level.WARNING)) continue;
                this._specificLogger.log(Level.WARNING, "Caught exception when scanning for dropped members [" + memberName + "]", e);
            }
        }
    }

    protected String[] getPotentialRemovedMembers(SourceGroupConfig config) {
        return new String[0];
    }

    private String buildingPendingReplicationMsg() {
        StringBuilder msg = new StringBuilder();
        for (AbstractReplicationSourceChannel channel : this._channels.values()) {
            long missingPackets;
            if (!channel.isActive() || (missingPackets = this.getGroupBacklog().size(channel.getMemberName())) <= 0L) continue;
            msg.append(StringUtils.NEW_LINE);
            msg.append("\ttarget: ");
            msg.append(channel.getMemberName());
            msg.append(" has ");
            msg.append(missingPackets);
            msg.append(" replication packets remaining. Last confirmed key [" + channel.getStatistics().getLastConfirmedKey() + "]");
        }
        return msg.toString();
    }

    @Override
    public String dumpState() {
        StringBuilder dump = new StringBuilder("Replication Source Group [");
        dump.append(this.getGroupName());
        dump.append("]");
        dump.append(StringUtils.NEW_LINE + "{");
        dump.append(StringUtils.NEW_LINE);
        dump.append("Type [");
        dump.append(this.getClass().getName());
        dump.append("]");
        dump.append(StringUtils.NEW_LINE);
        dump.append("GroupConfig [");
        dump.append(this.getConfigHolder().getConfig());
        dump.append("]");
        dump.append(StringUtils.NEW_LINE);
        dump.append("Channels:");
        Collection<AbstractReplicationSourceChannel> channels = this._channels.values();
        for (AbstractReplicationSourceChannel channel : channels) {
            dump.append(StringUtils.NEW_LINE);
            dump.append(channel.dumpState());
        }
        dump.append(StringUtils.NEW_LINE);
        dump.append("Backlog:");
        dump.append(StringUtils.NEW_LINE);
        dump.append(this.getGroupBacklog().dumpState());
        dump.append(StringUtils.NEW_LINE);
        dump.append("Group History:");
        dump.append(StringUtils.NEW_LINE);
        dump.append(this._groupHistory.outputDescendingEvents());
        dump.append(StringUtils.NEW_LINE);
        dump.append("}");
        return dump.toString();
    }
}

