/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelOutOfSync;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.packets.CheckSourceChannelPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectionStateListener;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectivityCheckListener;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractReplicationTargetChannel
implements IReplicationInFilterCallback,
IReplicationTargetChannel,
IConnectionStateListener,
IConnectivityCheckListener {
    protected final Logger _specificLogger;
    protected final Logger _specificVerboseLogger;
    private final String _myLookupName;
    private final ReplicationEndpointDetails _sourceEndpointDetails;
    private final IReplicationTargetProcessLog _processLog;
    private final IReplicationInFilter _inFilter;
    private final String _groupName;
    private final boolean _isInFiltered;
    private final IReplicationMonitoredConnection _sourceConnection;
    private final Object _myUniqueId;
    private final IReplicationTargetGroupStateListener _groupStateListener;
    private final IReplicationGroupHistory _groupHistory;
    private final ReplicationStatistics.ReplicationMode _channelType;
    private final Object _channelStateLock = new Object();
    private final Object _lastProcessSampleLock = new Object();
    private boolean _connected;
    private boolean _wasEverActive;
    private volatile boolean _outOfSync;
    private long _lastProcessTimeStamp = -1L;

    public AbstractReplicationTargetChannel(TargetGroupConfig groupConfig, String myLookupName, Object myUniqueId, ReplicationEndpointDetails sourceEndpointDetails, IReplicationMonitoredConnection sourceConnection, String groupName, IReplicationTargetProcessLog processLog, IReplicationInFilter inFilter, IReplicationTargetGroupStateListener groupStateListener, IReplicationGroupHistory groupHistory, boolean wasEverActive) {
        this._myLookupName = myLookupName;
        this._myUniqueId = myUniqueId;
        this._sourceEndpointDetails = sourceEndpointDetails;
        this._sourceConnection = sourceConnection;
        this._groupName = groupName;
        this._processLog = processLog;
        this._inFilter = inFilter;
        this._groupStateListener = groupStateListener;
        this._groupHistory = groupHistory;
        this._wasEverActive = wasEverActive;
        this._channelType = groupConfig.getGroupChannelType();
        this._isInFiltered = this._inFilter != null;
        this._specificLogger = ReplicationLogUtils.createIncomingChannelSpecificLogger(this.getSourceLookupName(), this._myLookupName, this._groupName);
        this._specificVerboseLogger = ReplicationLogUtils.createChannelSpecificVerboseLogger(this.getSourceLookupName(), this._myLookupName, this._groupName);
        this._sourceConnection.setConnectionStateListener(this);
        if (this._sourceConnection.supportsConnectivityCheckEvents()) {
            this._sourceConnection.setConnectivityCheckListener(this);
        }
    }

    @Override
    public IReplicationTargetProcessLog getProcessLog() {
        return this._processLog;
    }

    public String getSourceLookupName() {
        return this._sourceEndpointDetails.getLookupName();
    }

    public String getMyLookupName() {
        return this._myLookupName;
    }

    public Object getSourceUniqueId() {
        return this._sourceEndpointDetails.getUniqueId();
    }

    public Object processBatch(List<IReplicationOrderedPacket> packets) {
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("Incoming packets: " + ReplicationLogUtils.packetsToLogString(packets));
        }
        this.updateLastProcessTimeStamp();
        IProcessResult processResult = this._processLog.processBatch(this.getSourceLookupName(), packets, this._isInFiltered ? this : null);
        this.logProcessResultIfNecessary(processResult, packets);
        return this._processLog.toWireForm(processResult);
    }

    public Object processIdleStateData(IIdleStateData idleStateData) {
        if (this._specificVerboseLogger.isLoggable(Level.FINEST)) {
            this._specificVerboseLogger.finest("incoming idle state data replication: " + idleStateData);
        }
        this.updateLastProcessTimeStamp();
        IProcessResult processResult = this._processLog.processIdleStateData(this.getSourceLookupName(), idleStateData, this._isInFiltered ? this : null);
        this.logProcessResultIfNecessary(processResult, Collections.emptyList());
        return this._processLog.toWireForm(processResult);
    }

    private void logProcessResultIfNecessary(IProcessResult processResult, List<IReplicationOrderedPacket> packets) {
        if (this._specificVerboseLogger.isLoggable(Level.FINEST)) {
            String packetsBatchText = packets.isEmpty() ? "IDLE-STATE" : "firstPacketKey=" + packets.get(0).getKey() + ", lastPacketKey=" + packets.get(packets.size() - 1).getEndKey();
            this._specificVerboseLogger.finest("Returning " + processResult.toString() + " for received packets batch [" + packetsBatchText + "]");
        }
    }

    private void updateLastProcessTimeStamp() {
        this._lastProcessTimeStamp = SystemTime.timeMillis();
    }

    public Object process(IReplicationOrderedPacket packet) {
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("Incoming packet: " + packet);
        }
        this.updateLastProcessTimeStamp();
        IProcessResult processResult = this._processLog.process(this.getSourceLookupName(), packet, this._isInFiltered ? this : null);
        if (this._specificVerboseLogger.isLoggable(Level.FINEST)) {
            this._specificVerboseLogger.finest("Returning " + processResult.toString() + " for received packet [packetKey=" + packet.getKey() + "]");
        }
        return this._processLog.toWireForm(processResult);
    }

    @Override
    public void invokeInFilter(IReplicationInContext context, IReplicationPacketData<?> data) {
        if (!data.supportsReplicationFilter()) {
            return;
        }
        Iterable<IReplicationFilterEntry> filterEntries = this._processLog.getDataConsumer().toFilterEntries(context, data);
        for (IReplicationFilterEntry filterEntry : filterEntries) {
            this._inFilter.filterIn(filterEntry, this.getSourceLookupName(), this._groupName);
        }
        if (data.isEmpty() && this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("Input filter discarded packet " + data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcessLogHandshakeResponse performHandshake(IBacklogHandshakeRequest handshakeRequest) {
        Object object = this._channelStateLock;
        synchronized (object) {
            IProcessLogHandshakeResponse handshakeResponse;
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("Received handshake request {" + handshakeRequest.toLogMessage() + "}");
            }
            try {
                handshakeResponse = this._processLog.performHandshake(this.getSourceLookupName(), handshakeRequest);
            }
            catch (IncomingReplicationOutOfSyncException e) {
                String msg = "Channel is out of sync:" + StringUtils.NEW_LINE + "[  source space: " + this.getSourceLookupName() + "  ] " + StringUtils.NEW_LINE + "[  target space: " + this._myLookupName + "  ] " + StringUtils.NEW_LINE + "[  replication group name: " + this._groupName + " ]" + StringUtils.NEW_LINE + "Handshake request details [" + handshakeRequest.toLogMessage() + "]" + StringUtils.NEW_LINE + "ProcessLog state [" + this._processLog.toLogMessage() + "]";
                if (this._groupStateListener != null && this._groupStateListener.onTargetChannelOutOfSync(this._groupName, this.getSourceLookupName(), e)) {
                    handshakeResponse = this._processLog.resync(handshakeRequest);
                    this.logEventInHistory(msg + StringUtils.NEW_LINE + "Reason - " + e + StringUtils.NEW_LINE + "Outcome: Resynchronized channel and dropped missing packets");
                    if (this._specificLogger.isLoggable(Level.SEVERE)) {
                        this._specificLogger.log(Level.SEVERE, msg + StringUtils.NEW_LINE + "Outcome: Resynchronized channel and dropped missing packets", e);
                    }
                }
                this.logEventInHistory(msg + StringUtils.NEW_LINE + "Reason - " + e);
                this._specificLogger.log(Level.SEVERE, msg, e);
                throw new ReplicationChannelOutOfSync(e.getMessage(), e);
            }
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("Handshake response {" + handshakeResponse.toLogMessage() + "}");
            }
            this.logEventInHistory("Handshake executed:" + StringUtils.NEW_LINE + "\trequest: " + (handshakeRequest != null ? handshakeRequest.toLogMessage() : null) + StringUtils.NEW_LINE + "\tresponse: " + (handshakeResponse != null ? handshakeResponse.toLogMessage() : null));
            String msg = "Channel established " + this.getConnectionDescription();
            this.logEventInHistory(msg);
            Level logLevel = this.requiresHighLevelLogging() || this._wasEverActive ? Level.INFO : Level.FINE;
            this._specificLogger.log(logLevel, msg);
            this._wasEverActive = true;
            if (!this._connected) {
                this._connected = true;
                if (this._groupStateListener != null) {
                    this._groupStateListener.onTargetChannelConnected(this._groupName, this.getSourceLookupName(), this.getSourceUniqueId());
                }
            }
            return handshakeResponse;
        }
    }

    public void processHandshakeIteration(IHandshakeIteration handshakeIteration) {
        boolean detailed = this._specificLogger.isLoggable(Level.FINEST);
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("Received handshake iteration {" + handshakeIteration.toLogMessage(detailed) + "}");
        }
        this.updateLastProcessTimeStamp();
        this._processLog.processHandshakeIteration(this.getSourceLookupName(), handshakeIteration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long channelCloseTimeout, TimeUnit unit) {
        try {
            if (!this._processLog.close(channelCloseTimeout, unit) && this._specificLogger.isLoggable(Level.WARNING)) {
                this._specificLogger.warning("Channel was not closed gracefully, close operation timed-out");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this._sourceConnection.close();
        }
    }

    public boolean isSourceAttached() {
        boolean sourceAttached = false;
        try {
            sourceAttached = this._sourceConnection.dispatch(new CheckSourceChannelPacket(this._groupName, this._myUniqueId, false));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sourceAttached;
    }

    public void onChannelBacklogDropped(String groupName, IBacklogMemberState memberState, IReplicationTargetGroupStateListener listener) {
        if (this._outOfSync) {
            return;
        }
        this._outOfSync = true;
        String msg = "Channel is out of sync, backlog was dropped by source {" + memberState.toLogMessage() + "}";
        this.logEventInHistory(msg);
        if (listener != null) {
            this._specificLogger.severe(msg);
            listener.onTargetChannelBacklogDropped(groupName, this.getSourceLookupName(), memberState);
        }
    }

    protected String onDumpState() {
        return "";
    }

    public String dumpState() {
        return "Channel [" + this.getSourceLookupName() + ", " + this.getSourceUniqueId() + "]" + StringUtils.NEW_LINE + "Type [" + this.getClass().getName() + "]" + StringUtils.NEW_LINE + "Process log: " + this._processLog.dumpState() + this.onDumpState() + StringUtils.NEW_LINE + "latest history:" + StringUtils.NEW_LINE + this._groupHistory.outputDescendingEvents(this.getSourceLookupName());
    }

    protected void logEventInHistory(String event) {
        this._groupHistory.logEvent(this.getSourceLookupName(), event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnected(boolean newTarget) {
        Object object = this._channelStateLock;
        synchronized (object) {
            if (this._connected) {
                return;
            }
            try {
                if (!this._sourceConnection.dispatch(new CheckSourceChannelPacket(this._groupName, this._myUniqueId, true)).booleanValue()) {
                    return;
                }
            }
            catch (RemoteException e) {
                return;
            }
            this._connected = true;
            String msg = "Channel reestablished connection to source " + this.getConnectionDescription();
            this.logEventInHistory(msg);
            Level logLevel = this.requiresHighLevelLogging() || this._wasEverActive ? Level.INFO : Level.FINE;
            this._specificLogger.log(logLevel, msg);
            if (this._groupStateListener != null) {
                this._groupStateListener.onTargetChannelConnected(this._groupName, this.getSourceLookupName(), this.getSourceUniqueId());
            }
        }
    }

    @Override
    public void afterSuccessfulConnectivityCheck() {
        try {
            if (!this._sourceConnection.dispatch(new CheckSourceChannelPacket(this._groupName, this._myUniqueId, true)).booleanValue()) {
                this.onDisconnected();
            } else {
                this.onConnected(false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnected() {
        Object object = this._channelStateLock;
        synchronized (object) {
            if (!this._connected) {
                return;
            }
            this._connected = false;
            String msg = "Channel lost connection to source " + this.getConnectionDescription();
            this.logEventInHistory(msg);
            this._specificLogger.info(msg);
            if (this._groupStateListener != null) {
                this._groupStateListener.onTargetChannelSourceDisconnected(this._groupName, this.getSourceLookupName(), this.getSourceUniqueId());
            }
        }
    }

    private String getConnectionDescription() {
        return "[source=" + ReplicationLogUtils.toShortLookupName(this.getSourceLookupName()) + ", source url=" + this._sourceConnection.getConnectionUrl() + ", source machine connection url=" + this._sourceConnection.getClosestEndpointAddress() + "]";
    }

    public Object getSourceEndpointAddress() {
        return this._sourceConnection.getClosestEndpointAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastProcessTimeStamp() {
        Object object = this._lastProcessSampleLock;
        synchronized (object) {
            return this._lastProcessTimeStamp;
        }
    }

    private boolean requiresHighLevelLogging() {
        if (this._channelType == null) {
            return true;
        }
        switch (this._channelType) {
            case ACTIVE_SPACE: 
            case BACKUP_SPACE: 
            case MIRROR: 
            case GATEWAY: {
                return true;
            }
            case DURABLE_NOTIFICATION: 
            case LOCAL_VIEW: {
                return false;
            }
        }
        return true;
    }
}

