/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.EventsTracer;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.IncompatibleReplicationSourceException;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationSourceAlreadyAttachedException;
import com.gigaspaces.internal.cluster.node.impl.groups.UnknownReplicationSourceException;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.ConnectChannelHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.ConnectChannelHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaState;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.j_spaces.core.exception.ClosedResourceException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractReplicationTargetGroup
implements IReplicationTargetGroup,
IReplicationGroupHistory {
    protected static final Logger _loggerReplica = Logger.getLogger("com.gigaspaces.replication.replica");
    protected final Logger _specificLogger;
    private final IReplicationRouter _replicationRouter;
    private final Map<String, AbstractReplicationTargetChannel> _channels;
    private final TargetGroupConfig _groupConfig;
    private final IReplicationInFacade _replicationInFacade;
    private final IReplicationInFilter _inFilter;
    protected final int _channelCloseTimeout;
    private final Map<String, SpaceReplicaState> _spaceReplicaStates;
    private final IReplicationTargetGroupStateListener _listener;
    private final Map<String, EventsTracer<String>> _groupChannelHistory;
    private final EventsTracer<String> _groupHistory;
    private final Object _historyLock = new Object();
    private boolean _closed;

    public AbstractReplicationTargetGroup(TargetGroupConfig groupConfig, IReplicationRouter replicationRouter, IReplicationInFacade replicationInFacade, IReplicationInFilter inFilter, IReplicationTargetGroupStateListener stateListener) {
        this._groupConfig = groupConfig;
        this._replicationRouter = replicationRouter;
        this._replicationInFacade = replicationInFacade;
        this._inFilter = inFilter;
        this._listener = stateListener;
        this._channelCloseTimeout = this._groupConfig.getChannelCloseTimeout();
        this._channels = new CopyOnUpdateMap<String, AbstractReplicationTargetChannel>();
        this._spaceReplicaStates = new HashMap<String, SpaceReplicaState>();
        this._groupChannelHistory = this.createGroupHistory();
        this._groupHistory = new EventsTracer(this._groupConfig.getHistoryLength());
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.group." + this._groupConfig.getName());
    }

    private Map<String, EventsTracer<String>> createGroupHistory() {
        HashMap<String, EventsTracer<String>> history = new HashMap<String, EventsTracer<String>>();
        if (!this._groupConfig.isUnbounded() && !this._groupConfig.isSupportDynamicMembers()) {
            String[] membersLookupNames;
            for (String memberName : membersLookupNames = this._groupConfig.getMembersLookupNames()) {
                history.put(memberName, new EventsTracer(this._groupConfig.getHistoryLength()));
            }
        }
        return history;
    }

    @Override
    public void logEvent(String memberName, String event) {
        EventsTracer<String> eventsTracer = this.getEventsTracer(memberName);
        eventsTracer.logEvent(event);
    }

    @Override
    public void logGroupEvent(String event) {
        this._groupHistory.logEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventsTracer<String> getEventsTracer(String memberName) {
        Object object = this._historyLock;
        synchronized (object) {
            EventsTracer<String> eventsTracer = this._groupChannelHistory.get(memberName);
            if (eventsTracer == null) {
                throw new IllegalArgumentException("Unknown member name " + memberName + ", valid members are " + Arrays.toString(this._groupConfig.getMembersLookupNames()));
            }
            return eventsTracer;
        }
    }

    @Override
    public String outputDescendingEvents(String memberName) {
        return this.getEventsTracer(memberName).outputDescendingEvents();
    }

    protected IReplicationRouter getReplicationRouter() {
        return this._replicationRouter;
    }

    @Override
    public synchronized IReplicationTargetChannel getChannel(String sourceMemberLookupName) {
        this.validNotClosed();
        return this._channels.get(sourceMemberLookupName);
    }

    @Override
    public synchronized ConnectChannelHandshakeResponse connectChannel(RouterStubHolder sourceRouterStubHolder, ConnectChannelHandshakeRequest handshakeRequest) {
        this.validNotClosed();
        AbstractReplicationTargetChannel channel = this._channels.get(sourceRouterStubHolder.getMyEndpointDetails().getLookupName());
        if (channel == null || !channel.getSourceUniqueId().equals(sourceRouterStubHolder.getMyEndpointDetails().getUniqueId())) {
            channel = this.createNewChannel(handshakeRequest.getBacklogHandshakeRequest(), sourceRouterStubHolder);
        }
        IProcessLogHandshakeResponse processLogHandshakeResponse = channel.performHandshake(handshakeRequest.getBacklogHandshakeRequest());
        return new ConnectChannelHandshakeResponse(this._replicationRouter.getMyEndpointDetails(), processLogHandshakeResponse);
    }

    @Override
    public synchronized void onChannelBacklogDropped(String sourceMemberLookupName, Object sourceUniqueId, IBacklogMemberState memberState) {
        this.validNotClosed();
        AbstractReplicationTargetChannel channel = this._channels.get(sourceMemberLookupName);
        if (channel != null && channel.getSourceUniqueId().equals(sourceUniqueId)) {
            IReplicationTargetGroupStateListener listener = this._listener;
            channel.onChannelBacklogDropped(this.getGroupName(), memberState, listener);
        } else if (this._specificLogger.isLoggable(Level.WARNING)) {
            this._specificLogger.warning("Received channel backlog dropped notification from a wrong source [" + sourceMemberLookupName + ", " + sourceUniqueId + "], ignoring it.");
        }
    }

    @Override
    public void processHandshakeIteration(String sourceMemberLookupName, Object sourceUniqueId, IHandshakeIteration handshakeIteration) {
        this.validNotClosed();
        AbstractReplicationTargetChannel channel = this.getCorrespondingChannel(sourceMemberLookupName, sourceUniqueId);
        channel.processHandshakeIteration(handshakeIteration);
    }

    private AbstractReplicationTargetChannel createNewChannel(IBacklogHandshakeRequest handshakeRequest, RouterStubHolder sourceRouterStubHolder) {
        this.validateConnectChannel(sourceRouterStubHolder.getMyEndpointDetails().getLookupName(), sourceRouterStubHolder.getMyEndpointDetails().getUniqueId());
        IReplicationMonitoredConnection sourceConnection = this.createConnectionToSource(sourceRouterStubHolder);
        AbstractReplicationTargetChannel channel = this.createNewChannelImpl(sourceRouterStubHolder.getMyEndpointDetails(), sourceConnection, handshakeRequest, this);
        AbstractReplicationTargetChannel previousChannel = this._channels.put(sourceRouterStubHolder.getMyEndpointDetails().getLookupName(), channel);
        this.createHistoryTracerIfNeeded(sourceRouterStubHolder.getMyEndpointDetails().getLookupName());
        if (previousChannel != null) {
            previousChannel.close(this._channelCloseTimeout, TimeUnit.SECONDS);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHistoryTracerIfNeeded(String memberLookupName) {
        if (!this._groupConfig.isUnbounded() && !this._groupConfig.isSupportDynamicMembers()) {
            return;
        }
        Object object = this._historyLock;
        synchronized (object) {
            if (this._groupChannelHistory.containsKey(memberLookupName)) {
                return;
            }
            EventsTracer eventsTracer = new EventsTracer(this._groupConfig.getHistoryLength());
            this._groupChannelHistory.put(memberLookupName, eventsTracer);
        }
    }

    protected abstract AbstractReplicationTargetChannel createNewChannelImpl(ReplicationEndpointDetails var1, IReplicationMonitoredConnection var2, IBacklogHandshakeRequest var3, IReplicationGroupHistory var4);

    private void validateConnectChannel(String sourceMemberName, Object sourceUniqueId) {
        if (!this._groupConfig.isUnbounded()) {
            this.validateUnknownMember(sourceMemberName);
        }
        this.validateDuplicateChannel(sourceMemberName, sourceUniqueId);
        this.validateConnectChannelImpl(sourceMemberName);
        this.validateConnectionPlugable(sourceMemberName, sourceUniqueId);
    }

    private void validateConnectionPlugable(String sourceMemberName, Object sourceUniqueId) {
        if (this._listener != null) {
            this._listener.onTargetChannelCreationValidation(this.getGroupName(), sourceMemberName, sourceUniqueId);
        }
    }

    private void validateUnknownMember(String sourceMemberName) {
        if (this._groupConfig.isSupportDynamicMembers()) {
            List<String> list = Arrays.asList(this._groupConfig.getMembersLookupNames());
            for (String memberName : list) {
                if (!sourceMemberName.matches(memberName)) continue;
                return;
            }
            throw new UnknownReplicationSourceException("Replication group " + this._groupConfig.getName() + " does not contain matching dynamic member definition of " + sourceMemberName + ", known dynamic member definitions are " + Arrays.toString(this._groupConfig.getMembersLookupNames()));
        }
        if (!Arrays.asList(this._groupConfig.getMembersLookupNames()).contains(sourceMemberName)) {
            throw new UnknownReplicationSourceException("Replication group " + this._groupConfig.getName() + " does not contain member " + sourceMemberName + ", known member are " + Arrays.toString(this._groupConfig.getMembersLookupNames()));
        }
    }

    private void validateDuplicateChannel(String sourceMemberName, Object sourceUniqueId) throws ReplicationSourceAlreadyAttachedException {
        AbstractReplicationTargetChannel channel = this._channels.get(sourceMemberName);
        if (channel != null && channel.getSourceUniqueId().equals(sourceUniqueId)) {
            return;
        }
        if (channel != null && channel.isSourceAttached()) {
            throw new ReplicationSourceAlreadyAttachedException("Replication group " + this._groupConfig.getName() + " member " + sourceMemberName + " source is already attached [" + channel.getSourceEndpointAddress() + "]");
        }
    }

    private IReplicationMonitoredConnection createConnectionToSource(RouterStubHolder sourceRouterStubHolder) {
        IReplicationMonitoredConnection sourceConnection = this._replicationRouter.getDirectConnection(sourceRouterStubHolder);
        return sourceConnection;
    }

    @Override
    public Object processBatch(String sourceMemberLookupName, Object sourceUniqueId, List<IReplicationOrderedPacket> packets) {
        this.validNotClosed();
        AbstractReplicationTargetChannel channel = this.getCorrespondingChannel(sourceMemberLookupName, sourceUniqueId);
        return channel.processBatch(packets);
    }

    @Override
    public Object processIdleStateData(String sourceMemberLookupName, Object sourceUniqueId, IIdleStateData idleStateData) {
        this.validNotClosed();
        AbstractReplicationTargetChannel channel = this.getCorrespondingChannel(sourceMemberLookupName, sourceUniqueId);
        return channel.processIdleStateData(idleStateData);
    }

    private void validNotClosed() {
        if (this._closed) {
            throw new ClosedResourceException("Replication group " + this.getGroupName() + " is closed");
        }
    }

    @Override
    public Object process(String sourceMemberLookupName, Object sourceUniqueId, IReplicationOrderedPacket packet) {
        this.validNotClosed();
        AbstractReplicationTargetChannel channel = this.getCorrespondingChannel(sourceMemberLookupName, sourceUniqueId);
        return channel.process(packet);
    }

    @Override
    public void processUnreliableOperation(String sourceMemberLookupName, Object sourceUniqueId, IReplicationUnreliableOperation operation) {
        block3: {
            this.validNotClosed();
            this.getCorrespondingChannel(sourceMemberLookupName, sourceUniqueId);
            try {
                if (this._specificLogger.isLoggable(Level.FINEST)) {
                    this._specificLogger.finest("incoming replication of unreliable operation: " + operation);
                }
                operation.execute(sourceMemberLookupName, this.getReplicationInFacade());
            }
            catch (Exception e) {
                if (!this._specificLogger.isLoggable(Level.WARNING)) break block3;
                this._specificLogger.log(Level.WARNING, "error occurred while processing operation " + operation, e);
            }
        }
    }

    private AbstractReplicationTargetChannel getCorrespondingChannel(String sourceMemberLookupName, Object sourceUniqueId) {
        AbstractReplicationTargetChannel channel = this._channels.get(sourceMemberLookupName);
        if (channel == null) {
            throw new IncompatibleReplicationSourceException("Replication group " + this.getGroupName() + " received process invocation from " + sourceMemberLookupName + " when there is no open channel from that source");
        }
        if (!channel.getSourceUniqueId().equals(sourceUniqueId)) {
            throw new IncompatibleReplicationSourceException("Replication group " + this.getGroupName() + " received process invocation from " + sourceMemberLookupName + " with incompatible id, received " + sourceUniqueId + " expecting " + channel.getSourceUniqueId());
        }
        return channel;
    }

    @Override
    public String getGroupName() {
        return this._groupConfig.getName();
    }

    public IReplicationInFilter getInFilter() {
        return this._inFilter;
    }

    public TargetGroupConfig getGroupConfig() {
        return this._groupConfig;
    }

    protected void closeChannel(AbstractReplicationTargetChannel channel) {
        if (channel != null) {
            this._channels.remove(channel.getSourceLookupName());
            channel.close(this._channelCloseTimeout, TimeUnit.SECONDS);
        }
    }

    @Override
    public synchronized void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        for (AbstractReplicationTargetChannel channel : this._channels.values()) {
            this.closeChannel(channel);
        }
    }

    @Override
    public long getLastProcessTimeStamp(String replicaSourceLookupName) {
        AbstractReplicationTargetChannel channel = this._channels.get(replicaSourceLookupName);
        if (channel != null) {
            return channel.getLastProcessTimeStamp();
        }
        return -1L;
    }

    @Override
    public synchronized void addSynchronizeState(String sourceMemberLookupName, SpaceReplicaState spaceReplicaState) {
        this._spaceReplicaStates.put(sourceMemberLookupName, spaceReplicaState);
    }

    @Override
    public synchronized void synchronizationDone(String sourceMemberLookupName, Object sourceUniqueId) {
        SpaceReplicaState spaceReplicaState = this._spaceReplicaStates.remove(sourceMemberLookupName);
        if (spaceReplicaState != null) {
            AbstractReplicationTargetChannel channel = this._channels.get(sourceMemberLookupName);
            if (channel == null) {
                if (_loggerReplica.isLoggable(Level.WARNING)) {
                    _loggerReplica.warning(this._replicationRouter.getMyLookupName() + " received synchronization done signal from source with no open channel [" + sourceMemberLookupName + "]");
                }
            } else if (!channel.getSourceUniqueId().equals(sourceUniqueId) && _loggerReplica.isLoggable(Level.WARNING)) {
                _loggerReplica.warning(this._replicationRouter.getMyLookupName() + " received synchronization done signal from source with wrong id [" + sourceMemberLookupName + "] expected id [" + channel.getSourceUniqueId() + "] actual [" + sourceUniqueId + "]");
            }
            if (_loggerReplica.isLoggable(Level.FINE)) {
                _loggerReplica.fine(this._replicationRouter.getMyLookupName() + " synchronization done with source [" + sourceMemberLookupName + "]");
            }
            spaceReplicaState.updateSynchronizationDone();
        } else if (_loggerReplica.isLoggable(Level.WARNING)) {
            _loggerReplica.warning(this._replicationRouter.getMyLookupName() + " received synchronization done signal when there's no pending synchronization in progress [" + sourceMemberLookupName + "]");
        }
    }

    public boolean isFiltered() {
        return this._inFilter != null;
    }

    public IReplicationTargetGroupStateListener getStateListener() {
        return this._listener;
    }

    @Override
    public void setActive() {
    }

    @Override
    public void setPassive() {
    }

    protected abstract void validateConnectChannelImpl(String var1);

    public IReplicationInFacade getReplicationInFacade() {
        return this._replicationInFacade;
    }

    @Override
    public String dumpState() {
        StringBuilder dump = new StringBuilder("Replication target Group [");
        dump.append(this.getGroupName());
        dump.append("]");
        dump.append(StringUtils.NEW_LINE + "{");
        dump.append(StringUtils.NEW_LINE);
        dump.append("Type [");
        dump.append(this.getClass().getName());
        dump.append("]");
        dump.append(StringUtils.NEW_LINE);
        dump.append("Channels:");
        for (AbstractReplicationTargetChannel channel : this._channels.values()) {
            dump.append(StringUtils.NEW_LINE);
            dump.append(channel.dumpState());
        }
        dump.append(StringUtils.NEW_LINE);
        dump.append("Group History:");
        dump.append(StringUtils.NEW_LINE);
        dump.append(this._groupHistory.outputDescendingEvents());
        dump.append(StringUtils.NEW_LINE);
        dump.append("}");
        return dump.toString();
    }
}

