/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelEntryDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryDataContentExtractor;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.logging.Logger;

@InternalApi
public class GeneralReplicationChannelDataFilter
extends AbstractReplicationChannelDataFilter {
    private static final GeneralReplicationChannelDataFilter _filter = new GeneralReplicationChannelDataFilter();

    public static GeneralReplicationChannelDataFilter getInstance() {
        return _filter;
    }

    protected GeneralReplicationChannelDataFilter() {
    }

    public ReplicationChannelEntryDataFilterResult filterBeforeReplicatingEntryData(IReplicationPacketEntryData entryData, PlatformLogicalVersion targetLogicalVersion, IReplicationPacketEntryDataContentExtractor contentExtractor, Logger contextLogger, IReplicationPacketData data) {
        switch (entryData.getOperationType()) {
            case ENTRY_LEASE_EXPIRED: 
            case NOTIFY_TEMPLATE_LEASE_EXPIRED: 
            case REMOVE_ENTRY: {
                break;
            }
            case CHANGE: {
                if (!targetLogicalVersion.lessThan(PlatformLogicalVersion.v9_1_0)) break;
                return ReplicationChannelEntryDataFilterResult.CONVERT_UPDATE;
            }
        }
        return ReplicationChannelEntryDataFilterResult.PASS;
    }

    @Override
    public ReplicationChannelDataFilterResult filterBeforeReplicatingData(IReplicationPacketData<?> data, PlatformLogicalVersion targetLogicalVersion, Logger contextLogger) {
        return ReplicationChannelDataFilterResult.PASS;
    }

    @Override
    public boolean filterBeforeReplicatingUnreliableOperation(IReplicationUnreliableOperation operation, PlatformLogicalVersion targetLogicalVersion) {
        return true;
    }

    @Override
    public Object[] getConstructionArgument() {
        return null;
    }
}

