/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.MemberAddedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.GeneralReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelEntryDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryDataContentExtractor;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationEntryDataConversionMetadata;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.Map;
import java.util.logging.Logger;

@InternalApi
public class ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter
extends GeneralReplicationChannelDataFilter
implements DynamicSourceGroupConfigHolder.IDynamicSourceGroupStateListener {
    private final Object _lock = new Object();
    private final CopyOnUpdateMap<ReplicationStatistics.ReplicationMode, Integer> _targetCount = new CopyOnUpdateMap();
    private final CopyOnUpdateMap<String, ReplicationStatistics.ReplicationMode> _memberReplicationMode = new CopyOnUpdateMap();
    private final boolean _requiresEvictionReplicationProtection;

    public ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter(boolean requiresEvictionReplicationProtection) {
        this._requiresEvictionReplicationProtection = requiresEvictionReplicationProtection;
    }

    @Override
    public ReplicationChannelEntryDataFilterResult filterBeforeReplicatingEntryData(IReplicationPacketEntryData entryData, PlatformLogicalVersion targetLogicalVersion, IReplicationPacketEntryDataContentExtractor contentExtractor, Logger contextLogger, IReplicationPacketData data) {
        boolean isPartOfTwoPhasePrepare = !data.isSingleEntryData() && data.getMultipleOperationType() == ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_PREPARE;
        ReplicationChannelEntryDataFilterResult filterResult = super.filterBeforeReplicatingEntryData(entryData, targetLogicalVersion, contentExtractor, contextLogger, data);
        switch (filterResult.getFilterOperation()) {
            case CONVERT: 
            case FILTER_DATA: 
            case FILTER_PACKET: {
                return filterResult;
            }
            case PASS: {
                if (entryData.isTransient() || !ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.mayNeedConversion(this._targetCount, this._requiresEvictionReplicationProtection, isPartOfTwoPhasePrepare)) {
                    return filterResult;
                }
                if ((entryData.getOperationType() == ReplicationSingleOperationType.UPDATE || entryData.getOperationType() == ReplicationSingleOperationType.CHANGE) && ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.convertUpdate(this._targetCount, this._requiresEvictionReplicationProtection, isPartOfTwoPhasePrepare)) {
                    return ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.UPDATE).requiresReliableAsyncFullContent());
                }
                if (entryData.getOperationType() == ReplicationSingleOperationType.CANCEL_LEASE && ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.convertLeaseCancelled(this._targetCount)) {
                    return ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.CANCEL_LEASE).requiresFullEntryData());
                }
                if (entryData.getOperationType() == ReplicationSingleOperationType.ENTRY_LEASE_EXPIRED && ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.convertLeaseExpired(this._targetCount)) {
                    return ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.ENTRY_LEASE_EXPIRED).requiresFullEntryData());
                }
                if (entryData.getOperationType() != ReplicationSingleOperationType.REMOVE_ENTRY || !ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.convertRemove(this._targetCount)) break;
                return ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.REMOVE_ENTRY).requiresFullEntryData());
            }
        }
        return filterResult;
    }

    @Override
    public void memberAdded(MemberAddedEvent memberAddedParam, SourceGroupConfig newConfig) {
        if (memberAddedParam.getCustomData() instanceof AsyncChannelConfig) {
            AsyncChannelConfig config = (AsyncChannelConfig)memberAddedParam.getCustomData();
            switch (config.getChannelType()) {
                case LOCAL_VIEW: {
                    this.increaseCount(memberAddedParam.getMemberName(), ReplicationStatistics.ReplicationMode.LOCAL_VIEW);
                    break;
                }
                case DURABLE_NOTIFICATION: {
                    this.increaseCount(memberAddedParam.getMemberName(), ReplicationStatistics.ReplicationMode.DURABLE_NOTIFICATION);
                    break;
                }
            }
        }
    }

    @Override
    public void memberRemoved(String memberName, SourceGroupConfig newConfig) {
        this.decreaseCount(memberName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCount(String memberName, ReplicationStatistics.ReplicationMode replicationMode) {
        Object object = this._lock;
        synchronized (object) {
            this._memberReplicationMode.put(memberName, replicationMode);
            Integer count = this._targetCount.get((Object)replicationMode);
            if (count == null) {
                count = 0;
            }
            this._targetCount.put(replicationMode, count + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseCount(String memberName) {
        Object object = this._lock;
        synchronized (object) {
            ReplicationStatistics.ReplicationMode replicationMode = this._memberReplicationMode.get(memberName);
            if (replicationMode == null) {
                return;
            }
            Integer count = this._targetCount.get((Object)replicationMode);
            if (count == null) {
                return;
            }
            if (count == 1) {
                this._targetCount.remove((Object)replicationMode);
            } else {
                this._targetCount.put(replicationMode, count - 1);
            }
            this._memberReplicationMode.remove(memberName);
        }
    }

    private static boolean convertUpdate(Map<ReplicationStatistics.ReplicationMode, Integer> targetCount, boolean requiresEvictionReplicationProtection, boolean partOfTwoPhasePrepare) {
        return ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.durableNoticationExists(targetCount) || ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.localViewExists(targetCount) || requiresEvictionReplicationProtection && partOfTwoPhasePrepare;
    }

    private static boolean convertRemove(Map<ReplicationStatistics.ReplicationMode, Integer> targetCount) {
        return ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.durableNoticationExists(targetCount);
    }

    private static boolean convertLeaseExpired(Map<ReplicationStatistics.ReplicationMode, Integer> targetCount) {
        return ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.durableNoticationExists(targetCount);
    }

    private static boolean convertLeaseCancelled(CopyOnUpdateMap<ReplicationStatistics.ReplicationMode, Integer> targetCount) {
        return ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.durableNoticationExists(targetCount);
    }

    private static boolean mayNeedConversion(Map<ReplicationStatistics.ReplicationMode, Integer> targetCount, boolean requiresEvictionReplicationProtection, boolean partOfTwoPhasePrepare) {
        return ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.durableNoticationExists(targetCount) || ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter.localViewExists(targetCount) || requiresEvictionReplicationProtection && partOfTwoPhasePrepare;
    }

    private static boolean durableNoticationExists(Map<ReplicationStatistics.ReplicationMode, Integer> targetCount) {
        return targetCount.containsKey((Object)ReplicationStatistics.ReplicationMode.DURABLE_NOTIFICATION);
    }

    private static boolean localViewExists(Map<ReplicationStatistics.ReplicationMode, Integer> targetCount) {
        return targetCount.containsKey((Object)ReplicationStatistics.ReplicationMode.LOCAL_VIEW);
    }
}

