/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelEntryDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketEntryDataConversionException;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationChannelDataFilterHelper {
    public static <T extends IReplicationOrderedPacket> T filterPacket(IReplicationChannelDataFilter filter, PlatformLogicalVersion targetMemberVersion, T packet, IReplicationPacketDataProducer dataProducer, IReplicationGroupBacklog groupBacklog, T previousDiscardedPacket, Logger logger, String targetMemberName) {
        if (!packet.isDataPacket()) {
            return (T)packet;
        }
        if (packet.getData().isSingleEntryData()) {
            return ReplicationChannelDataFilterHelper.filterSingleEntryDataPacket(filter, targetMemberVersion, packet, dataProducer, groupBacklog, previousDiscardedPacket, logger, targetMemberName);
        }
        ReplicationChannelDataFilterResult filterResult = filter.filterBeforeReplicatingData(packet.getData(), targetMemberVersion, logger);
        switch (filterResult.getFilterOperation()) {
            case PASS: {
                break;
            }
            case FILTER_DATA: {
                return ReplicationChannelDataFilterHelper.discardPacket(packet, previousDiscardedPacket, groupBacklog, targetMemberVersion, logger, targetMemberName, false);
            }
            case FILTER_PACKET: {
                return ReplicationChannelDataFilterHelper.discardPacket(packet, previousDiscardedPacket, groupBacklog, targetMemberVersion, logger, targetMemberName, true);
            }
            case CONVERT: {
                try {
                    IReplicationPacketData<?> convertedData = dataProducer.convertData(packet.getData(), filterResult.getConvertToOperation(), targetMemberVersion);
                    packet = packet.cloneWithNewData(convertedData);
                    break;
                }
                catch (ReplicationPacketEntryDataConversionException e) {
                    throw new ReplicationInternalSpaceException(e.getMessage(), e);
                }
            }
        }
        if (!filter.filterBeforeReplicatingEntryDataHasSideEffects() && !ReplicationChannelDataFilterHelper.shouldFilterData(filter, targetMemberVersion, packet, dataProducer, logger)) {
            return (T)packet;
        }
        IReplicationPacketData<?> data = packet.getData();
        IReplicationPacketData<?> newData = dataProducer.createEmptyMultipleEntryData(data);
        for (IReplicationPacketEntryData entryData : data) {
            ReplicationChannelEntryDataFilterResult filterResult2 = filter.filterBeforeReplicatingEntryData(entryData, targetMemberVersion, dataProducer, logger, data);
            switch (filterResult2.getFilterOperation()) {
                case FILTER_DATA: 
                case FILTER_PACKET: {
                    break;
                }
                case PASS: {
                    newData.add(entryData);
                    break;
                }
                case CONVERT: {
                    try {
                        IReplicationPacketEntryData convertedEntryData = dataProducer.convertEntryData(entryData, filterResult2.getConversionMetadata(), targetMemberVersion);
                        newData.add(convertedEntryData);
                        break;
                    }
                    catch (ReplicationPacketEntryDataConversionException e) {
                        throw new ReplicationInternalSpaceException(e.getMessage(), e);
                    }
                }
            }
        }
        packet = packet.cloneWithNewData(newData);
        if (newData.isEmpty()) {
            return (T)ReplicationChannelDataFilterHelper.discardPacket(packet, previousDiscardedPacket, groupBacklog, targetMemberVersion, logger, targetMemberName, false);
        }
        return (T)packet;
    }

    protected static <T extends IReplicationOrderedPacket> boolean shouldFilterData(IReplicationChannelDataFilter filter, PlatformLogicalVersion targetMemberVersion, T packet, IReplicationPacketDataProducer dataProducer, Logger logger) {
        for (IReplicationPacketEntryData entryData : packet.getData()) {
            if (filter.filterBeforeReplicatingEntryData(entryData, targetMemberVersion, dataProducer, logger, packet.getData()).getFilterOperation() == IReplicationChannelDataFilter.FilterOperation.PASS) continue;
            return true;
        }
        return false;
    }

    protected static <T extends IReplicationOrderedPacket> T filterSingleEntryDataPacket(IReplicationChannelDataFilter filter, PlatformLogicalVersion targetMemberVersion, T packet, IReplicationPacketDataProducer dataProducer, IReplicationGroupBacklog groupBacklog, T previousDiscardedPacket, Logger logger, String targetMemberName) {
        ReplicationChannelEntryDataFilterResult filterResult = filter.filterBeforeReplicatingEntryData(packet.getData().getSingleEntryData(), targetMemberVersion, dataProducer, logger, packet.getData());
        switch (filterResult.getFilterOperation()) {
            case PASS: {
                return packet;
            }
            case FILTER_DATA: {
                return ReplicationChannelDataFilterHelper.discardPacket(packet, previousDiscardedPacket, groupBacklog, targetMemberVersion, logger, targetMemberName, false);
            }
            case FILTER_PACKET: {
                return ReplicationChannelDataFilterHelper.discardPacket(packet, previousDiscardedPacket, groupBacklog, targetMemberVersion, logger, targetMemberName, true);
            }
            case CONVERT: {
                try {
                    IReplicationPacketData<?> convertedData = dataProducer.convertSingleEntryData(packet.getData(), filterResult.getConversionMetadata(), targetMemberVersion);
                    return (T)packet.cloneWithNewData(convertedData);
                }
                catch (ReplicationPacketEntryDataConversionException e) {
                    throw new ReplicationInternalSpaceException(e.getMessage(), e);
                }
            }
        }
        throw new ReplicationInternalSpaceException("illegal filter operation " + (Object)((Object)filterResult.getFilterOperation()));
    }

    private static <T extends IReplicationOrderedPacket> T discardPacket(T packet, T previousDiscardedPacket, IReplicationGroupBacklog groupBacklog, PlatformLogicalVersion targetMemberVersion, Logger logger, String targetMemberName, boolean forceDiscard) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Packet [" + packet.toString() + "] discarded by the channel filter.");
        }
        if (previousDiscardedPacket == null || !groupBacklog.supportDiscardMerge()) {
            return (T)groupBacklog.replaceWithDiscarded(packet, forceDiscard);
        }
        boolean merged = groupBacklog.mergeWithDiscarded(previousDiscardedPacket, packet, targetMemberName);
        if (!merged) {
            return (T)groupBacklog.replaceWithDiscarded(packet, forceDiscard);
        }
        return previousDiscardedPacket;
    }
}

