/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.NoSuchReplicationGroupExistException;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@InternalApi
public class ReplicationNodeGroupsHolder {
    private final Map<String, IReplicationSourceGroup> _replicationSourceGroups = new CopyOnUpdateMap<String, IReplicationSourceGroup>();
    private final Map<String, IReplicationTargetGroup> _replicationTargetGroups = new CopyOnUpdateMap<String, IReplicationTargetGroup>();
    private final Map<ReplicationNodeMode, Set<IReplicationSourceGroup>> _modeSourceGroups = new EnumMap<ReplicationNodeMode, Set<IReplicationSourceGroup>>(ReplicationNodeMode.class);
    private final Map<ReplicationNodeMode, Set<IReplicationTargetGroup>> _modeTargetGroups = new EnumMap<ReplicationNodeMode, Set<IReplicationTargetGroup>>(ReplicationNodeMode.class);
    private volatile IReplicationSourceGroup[] _replicationSourceGroupsArray = new IReplicationSourceGroup[0];
    private volatile IReplicationTargetGroup[] _replicationTargetGroupsArray = new IReplicationTargetGroup[0];

    public synchronized void addSourceGroup(IReplicationSourceGroup group, ReplicationNodeMode nodeMode) {
        this._replicationSourceGroups.put(group.getGroupName(), group);
        Set<IReplicationSourceGroup> modeGroups = this._modeSourceGroups.get((Object)nodeMode);
        if (modeGroups == null) {
            modeGroups = new HashSet<IReplicationSourceGroup>();
            this._modeSourceGroups.put(nodeMode, modeGroups);
        }
        modeGroups.add(group);
        this.reconstructSourceGroupsArray();
    }

    public synchronized void addTargetGroup(IReplicationTargetGroup group, ReplicationNodeMode nodeMode) {
        this._replicationTargetGroups.put(group.getGroupName(), group);
        Set<IReplicationTargetGroup> modeGroups = this._modeTargetGroups.get((Object)nodeMode);
        if (modeGroups == null) {
            modeGroups = new HashSet<IReplicationTargetGroup>();
            this._modeTargetGroups.put(nodeMode, modeGroups);
        }
        modeGroups.add(group);
        this.reconstructTargetGroupsArray();
    }

    public synchronized IReplicationTargetGroup addIfAbsentTargetGroup(IReplicationTargetGroup group, ReplicationNodeMode nodeMode) {
        IReplicationTargetGroup prevGroup = this._replicationTargetGroups.get(group.getGroupName());
        if (prevGroup != null) {
            return prevGroup;
        }
        this.addTargetGroup(group, nodeMode);
        return group;
    }

    public synchronized void closeSourceGroups(ReplicationNodeMode nodeMode) {
        Set<IReplicationSourceGroup> groups = this._modeSourceGroups.get((Object)nodeMode);
        if (groups != null) {
            for (IReplicationSourceGroup sourceGroup : groups) {
                this._replicationSourceGroups.remove(sourceGroup.getGroupName());
                sourceGroup.close();
            }
            groups.clear();
        }
        this.reconstructSourceGroupsArray();
    }

    public synchronized void closeTargetGroups(ReplicationNodeMode nodeMode) {
        Set<IReplicationTargetGroup> groups = this._modeTargetGroups.get((Object)nodeMode);
        if (groups != null) {
            for (IReplicationTargetGroup targetGroup : groups) {
                this._replicationTargetGroups.remove(targetGroup.getGroupName());
                targetGroup.close();
            }
            groups.clear();
        }
        this.reconstructTargetGroupsArray();
    }

    private void reconstructSourceGroupsArray() {
        IReplicationSourceGroup[] groupsArray = new IReplicationSourceGroup[this._replicationSourceGroups.size()];
        int index = 0;
        for (IReplicationSourceGroup sourceGroup : this._replicationSourceGroups.values()) {
            groupsArray[index++] = sourceGroup;
        }
        this._replicationSourceGroupsArray = groupsArray;
    }

    private void reconstructTargetGroupsArray() {
        IReplicationTargetGroup[] groupsArray = new IReplicationTargetGroup[this._replicationTargetGroups.size()];
        int index = 0;
        for (IReplicationTargetGroup targetGroup : this._replicationTargetGroups.values()) {
            groupsArray[index++] = targetGroup;
        }
        this._replicationTargetGroupsArray = groupsArray;
    }

    public IReplicationSourceGroup getSourceGroup(String groupName) throws NoSuchReplicationGroupExistException {
        IReplicationSourceGroup sourceGroup = this._replicationSourceGroups.get(groupName);
        if (sourceGroup != null) {
            return sourceGroup;
        }
        sourceGroup = this._replicationSourceGroups.get(groupName = this.getBackwardMatchingGroupName(groupName, this._replicationSourceGroups.keySet()));
        if (sourceGroup != null) {
            return sourceGroup;
        }
        throw new NoSuchReplicationGroupExistException(groupName, "There is no replication source group under the name " + groupName + ". Registered groups = " + this._replicationSourceGroups.keySet() + ".");
    }

    public IReplicationTargetGroup getTargetGroup(String groupName) throws NoSuchReplicationGroupExistException {
        IReplicationTargetGroup targetGroup = this._replicationTargetGroups.get(groupName);
        if (targetGroup != null) {
            return targetGroup;
        }
        targetGroup = this._replicationTargetGroups.get(groupName = this.getBackwardMatchingGroupName(groupName, this._replicationTargetGroups.keySet()));
        if (targetGroup != null) {
            return targetGroup;
        }
        throw new NoSuchReplicationGroupExistException(groupName, "There is no replication target group under the name " + groupName + ". Registered groups = " + this._replicationTargetGroups.keySet() + ".");
    }

    private String getBackwardMatchingGroupName(String groupName, Set<String> groupNames) {
        if (groupName.startsWith("primary-backup-sync") || groupName.startsWith("primary-backup-async")) {
            boolean syncGroup = groupName.startsWith("primary-backup-sync");
            String groupNameWithPartitionPrefix = null;
            for (String existingGroupName : groupNames) {
                if ((!syncGroup || !existingGroupName.startsWith("primary-backup-sync")) && (syncGroup || !existingGroupName.startsWith("primary-backup-async"))) continue;
                if (groupNameWithPartitionPrefix != null) {
                    return groupName;
                }
                groupNameWithPartitionPrefix = existingGroupName;
            }
            return groupNameWithPartitionPrefix != null ? groupNameWithPartitionPrefix : groupName;
        }
        return groupName;
    }

    public IReplicationSourceGroup[] getSourceGroups() {
        return this._replicationSourceGroupsArray;
    }

    public IReplicationTargetGroup[] getTargetGroups() {
        return this._replicationTargetGroupsArray;
    }

    public synchronized void close() {
        for (IReplicationSourceGroup sourceGroup : this.getSourceGroups()) {
            sourceGroup.close();
        }
        for (IReplicationTargetGroup targetGroup : this.getTargetGroups()) {
            targetGroup.close();
        }
    }

    public String dumpState() {
        StringBuilder dump = new StringBuilder("---- Source Groups ----");
        IReplicationSourceGroup[] sourceGroups = this.getSourceGroups();
        if (sourceGroups.length == 0) {
            dump.append(StringUtils.NEW_LINE);
            dump.append("NONE");
        }
        for (IReplicationSourceGroup sourceGroup : sourceGroups) {
            dump.append(StringUtils.NEW_LINE);
            dump.append(sourceGroup.dumpState());
        }
        dump.append(StringUtils.NEW_LINE);
        dump.append("---- Target Groups ----");
        IReplicationTargetGroup[] targetGroups = this.getTargetGroups();
        if (targetGroups.length == 0) {
            dump.append(StringUtils.NEW_LINE);
            dump.append("NONE");
        }
        for (IReplicationTargetGroup targetGroup : targetGroups) {
            dump.append(StringUtils.NEW_LINE);
            dump.append(targetGroup.dumpState());
        }
        return dump.toString();
    }
}

