/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.async;

import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandlerBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationAsyncProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;

public abstract class AbstractAsyncReplicationTargetGroup
extends AbstractReplicationTargetGroup {
    private final IReplicationAsyncProcessLogBuilder _processLogBuilder;
    private final IReplicationProcessLogExceptionHandlerBuilder _exceptionHandlerBuilder;

    public AbstractAsyncReplicationTargetGroup(TargetGroupConfig groupConfig, IReplicationRouter replicationRouter, IReplicationAsyncProcessLogBuilder processLogBuilder, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandlerBuilder exceptionHandlerBuilder, IReplicationInFilter inFilter, IReplicationTargetGroupStateListener stateListener) {
        super(groupConfig, replicationRouter, replicationInFacade, inFilter, stateListener);
        this._processLogBuilder = processLogBuilder;
        this._exceptionHandlerBuilder = exceptionHandlerBuilder;
    }

    protected AsyncReplicationTargetChannel createChannel(ReplicationEndpointDetails sourceEndpointDetails, IReplicationMonitoredConnection sourceConnection, IBacklogHandshakeRequest handshakeRequest, IReplicationGroupHistory groupHistory) {
        IReplicationProcessLogExceptionHandler exceptionHandler = this._exceptionHandlerBuilder.createExceptionHandler(sourceConnection, sourceEndpointDetails.getLookupName(), this.getGroupName());
        IReplicationAsyncTargetProcessLog processLog = this.createProcessLog(this._processLogBuilder, sourceEndpointDetails.getLookupName(), this.getReplicationInFacade(), exceptionHandler, handshakeRequest, groupHistory);
        return new AsyncReplicationTargetChannel(this.getGroupConfig(), this.getReplicationRouter().getMyLookupName(), this.getReplicationRouter().getMyUniqueId(), sourceEndpointDetails, sourceConnection, this.getGroupName(), processLog, this.getInFilter(), this.getStateListener(), groupHistory, false);
    }

    protected abstract IReplicationAsyncTargetProcessLog createProcessLog(IReplicationAsyncProcessLogBuilder var1, String var2, IReplicationInFacade var3, IReplicationProcessLogExceptionHandler var4, IBacklogHandshakeRequest var5, IReplicationGroupHistory var6);
}

