/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.async.IAsyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.utils.Textualizer;

@InternalApi
public class AsyncReplicationGroupOutContext
extends ReplicationGroupOutContext
implements IAsyncReplicationGroupOutContext {
    private int _packetCount;
    private long _weight;

    public AsyncReplicationGroupOutContext(String groupName) {
        super(groupName);
    }

    @Override
    public void addOrderedPacket(IReplicationOrderedPacket packet) {
        ++this._packetCount;
        this._weight += (long)packet.getWeight();
        super.afterAddingOrderedPacket(packet);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this._packetCount;
    }

    @Override
    public void clear() {
        this._packetCount = 0;
        this._weight = 0L;
    }

    @Override
    public long getWeight() {
        return this._weight;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("packetCount", this.size());
        textualizer.append("weightCount", this.getWeight());
    }
}

