/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.cluster.replication.ReplicationException;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IAsyncReplicationListener;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicateFuture;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicatedDataPacketResource;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.IdleStateDataReplicatedPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.kernel.JSpaceUtilities;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

@InternalApi
public class AsyncReplicationSourceChannel
extends AbstractReplicationSourceChannel {
    private final int _batchSize;
    private final long _intervalMilis;
    private final IAsyncHandlerProvider _asyncProvider;
    private final Object _pendingCountLock = new Object();
    private final AtomicLong _pendingCount = new AtomicLong();
    private final int _intervalOperations;
    private final Object _asyncDispatcherLifeCycle = new Object();
    private volatile IAsyncHandler _asyncHandler;

    public AsyncReplicationSourceChannel(DynamicSourceGroupConfigHolder groupConfig, String groupName, String memberName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationGroupBacklog groupBacklog, IReplicationOutFilter outFilter, int batchSize, long intervalMilis, int intervalOperations, IAsyncHandlerProvider asyncHandlerProvider, IReplicationChannelDataFilter dataFilter, IReplicationSourceGroupStateListener stateListener, IReplicationGroupHistory groupHistory, ReplicationStatistics.ReplicationMode channelType, Object customBacklogMetadata) {
        this(groupConfig, groupName, memberName, replicationRouter, connection, groupBacklog, outFilter, batchSize, intervalMilis, intervalOperations, asyncHandlerProvider, true, dataFilter, stateListener, groupHistory, channelType, customBacklogMetadata);
    }

    public AsyncReplicationSourceChannel(DynamicSourceGroupConfigHolder groupConfig, String groupName, String memberName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationGroupBacklog groupBacklog, IReplicationOutFilter outFilter, int batchSize, long intervalMilis, int intervalOperations, IAsyncHandlerProvider asyncHandlerProvider, boolean autoStart, IReplicationChannelDataFilter dataFilter, IReplicationSourceGroupStateListener stateListener, IReplicationGroupHistory groupHistory, ReplicationStatistics.ReplicationMode channelType, Object customBacklogMetadata) {
        super(groupConfig, groupName, memberName, replicationRouter, connection, groupBacklog, outFilter, asyncHandlerProvider, dataFilter, stateListener, groupHistory, channelType, customBacklogMetadata);
        this._batchSize = batchSize;
        this._intervalMilis = intervalMilis;
        this._intervalOperations = intervalOperations;
        this._asyncProvider = asyncHandlerProvider;
        if (autoStart) {
            this.start();
        }
    }

    @Override
    protected void start() {
        super.start();
        this._asyncHandler = this._asyncProvider.start(new AsyncDispatcher(), this._intervalMilis, "AsyncChannel-" + this.getMyLookupName() + "." + this.getGroupName() + "." + this.getMemberName(), false);
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    @Override
    protected void onActiveImpl() {
        IAsyncHandler asyncHandler = this._asyncHandler;
        if (asyncHandler != null) {
            asyncHandler.wakeUp();
        }
    }

    @Override
    protected void onDisconnectedImpl() {
    }

    @Override
    protected void closeImpl() {
        this._asyncHandler.stop(3L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IReplicationGroupOutContext groupContext) {
        long currentPending = this._pendingCount.addAndGet(groupContext.getWeight());
        if (currentPending >= (long)this._intervalOperations) {
            Object object = this._pendingCountLock;
            synchronized (object) {
                if (this._pendingCount.get() == 0L) {
                    return;
                }
                if (this._specificLogger.isLoggable(Level.FINEST)) {
                    this._specificLogger.finest("Reached interval operations [" + this._pendingCount + "/" + this._intervalOperations + "], waking up async dispatcher");
                }
                this._pendingCount.set(0L);
                this._asyncHandler.wakeUp();
            }
        }
    }

    protected List<IReplicationOrderedPacket> getPendingPackets() {
        return super.getPendingPackets(this.getBatchSize());
    }

    @Override
    public void flushPendingReplication() {
        IAsyncHandler asyncHandler = this._asyncHandler;
        if (asyncHandler != null) {
            asyncHandler.wakeUp();
        }
    }

    @Override
    public ReplicationStatistics.ReplicationOperatingMode getChannelOpertingMode() {
        return ReplicationStatistics.ReplicationOperatingMode.ASYNC;
    }

    @Override
    protected void onAsyncReplicateErrorResult(Throwable t, IReplicationOrderedPacket finalPacket) {
    }

    @Override
    protected void onAsyncReplicateErrorResult(Throwable t, List<IReplicationOrderedPacket> finalPackets) {
    }

    public class AsyncDispatcher
    extends AsyncCallable
    implements IAsyncReplicationListener {
        private List<IReplicationOrderedPacket> _currentCyclePackets;
        private IIdleStateData _currentCycleIdleStateData;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            if (!AsyncReplicationSourceChannel.this.isActive()) {
                if (AsyncReplicationSourceChannel.this._specificVerboseLogger.isLoggable(Level.FINEST)) {
                    AsyncReplicationSourceChannel.this._specificVerboseLogger.finest("AsyncDispatcher idle cycle. Channel is not active");
                }
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
            IBacklogMemberState memberState = AsyncReplicationSourceChannel.this.getGroupBacklog().getState(AsyncReplicationSourceChannel.this.getMemberName());
            if (memberState.isBacklogDropped()) {
                block20: {
                    try {
                        AsyncReplicationSourceChannel.this.dispatchBacklogDropped(memberState);
                    }
                    catch (RemoteException e) {
                        if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                            AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "Caught remote exception while asynchronous dispatcher notifies target of backlog dropped", e);
                        }
                    }
                    catch (Throwable t) {
                        if (!AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.SEVERE)) break block20;
                        AsyncReplicationSourceChannel.this._specificLogger.log(Level.SEVERE, "Error in replication when attempting notify target of backlog dropped", t);
                    }
                }
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
            this._currentCyclePackets = AsyncReplicationSourceChannel.this.getPendingPackets();
            if (this._currentCyclePackets == null || this._currentCyclePackets.isEmpty()) {
                if (AsyncReplicationSourceChannel.this._specificVerboseLogger.isLoggable(Level.FINEST)) {
                    AsyncReplicationSourceChannel.this._specificVerboseLogger.finest("AsyncDispatcher idle cycle. No pending packets to replicate.");
                }
                if (AsyncReplicationSourceChannel.this.isSynchronizing()) {
                    AsyncReplicationSourceChannel.this.signalSynchronizingDone();
                }
                this._currentCycleIdleStateData = AsyncReplicationSourceChannel.this.getGroupBacklog().getIdleStateData(AsyncReplicationSourceChannel.this.getMemberName(), AsyncReplicationSourceChannel.this.getTargetLogicalVersion());
                if (this._currentCycleIdleStateData != null && !this._currentCycleIdleStateData.isEmpty()) {
                    return this.replicateIdleStateData(this._currentCycleIdleStateData);
                }
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
            if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINEST)) {
                AsyncReplicationSourceChannel.this._specificLogger.finest("AsyncDispatcher cycle. Replicating [" + this._currentCyclePackets.size() + "] pending packets.");
            }
            Object object = AsyncReplicationSourceChannel.this._asyncDispatcherLifeCycle;
            synchronized (object) {
                try {
                    AsyncReplicationSourceChannel.this.replicateBatchDelayedAsync(this._currentCyclePackets, this);
                    return IAsyncHandlerProvider.CycleResult.SUSPEND;
                }
                catch (RemoteException e) {
                    if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                        AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "AsyncDispatcher cycle error.", e);
                    }
                    this._currentCyclePackets = null;
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
                catch (Throwable t) {
                    if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                        AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINER, "AsyncDispatcher cycle error while replicating " + this._currentCyclePackets + "." + StringUtils.NEW_LINE + AsyncReplicationSourceChannel.this.getGroupBacklog().toLogMessage(AsyncReplicationSourceChannel.this.getMemberName()), t);
                    }
                    this._currentCyclePackets = null;
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IAsyncHandlerProvider.CycleResult replicateIdleStateData(IIdleStateData idleStateData) {
            Object object = AsyncReplicationSourceChannel.this._asyncDispatcherLifeCycle;
            synchronized (object) {
                try {
                    this.replicateIdleStateDataAsync(idleStateData, this);
                    return IAsyncHandlerProvider.CycleResult.SUSPEND;
                }
                catch (RemoteException e) {
                    if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                        AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "AsyncDispatcher idle state cycle error.", e);
                    }
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
                catch (Throwable t) {
                    if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                        AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINER, "AsyncDispatcher cycle error while replicating idle state data." + StringUtils.NEW_LINE + AsyncReplicationSourceChannel.this.getGroupBacklog().toLogMessage(AsyncReplicationSourceChannel.this.getMemberName()), t);
                    }
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replicateIdleStateDataAsync(final IIdleStateData idleStateData, final IAsyncReplicationListener listener) throws RemoteException {
            if (AsyncReplicationSourceChannel.this._specificVerboseLogger.isLoggable(Level.FINEST)) {
                AsyncReplicationSourceChannel.this._specificVerboseLogger.finest("replicating idle state data: " + idleStateData);
            }
            final ReplicatedDataPacketResource replicatedDataPacketResource = (ReplicatedDataPacketResource)AsyncReplicationSourceChannel.this._packetsPool.get();
            boolean delegatedToAsync = false;
            try {
                IdleStateDataReplicatedPacket idleStateDataPacket = replicatedDataPacketResource.getIdleStateDataPacket();
                idleStateDataPacket.setIdleStateData(idleStateData);
                AsyncFuture<Object> processResultFuture = AsyncReplicationSourceChannel.this.getConnection().dispatchAsync(idleStateDataPacket);
                final ReplicateFuture resultFuture = new ReplicateFuture();
                processResultFuture.setListener(new AsyncFutureListener<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResult(AsyncResult<Object> wiredResult) {
                        Throwable error = null;
                        IProcessResult processResult = null;
                        try {
                            Exception exception = wiredResult.getException();
                            if (exception != null) {
                                throw exception;
                            }
                            processResult = AsyncReplicationSourceChannel.this.getGroupBacklog().fromWireForm(wiredResult.getResult());
                            AsyncReplicationSourceChannel.this.getGroupBacklog().processIdleStateDataResult(AsyncReplicationSourceChannel.this.getMemberName(), processResult, idleStateData);
                            resultFuture.releaseOk();
                        }
                        catch (ReplicationException e) {
                            error = e;
                            resultFuture.releaseError(e);
                        }
                        catch (Throwable t) {
                            error = t;
                            AsyncDispatcher.this.trackPendingErrorIfNeeded(t, idleStateData);
                            resultFuture.releaseError(t);
                        }
                        finally {
                            replicatedDataPacketResource.release();
                            if (listener != null) {
                                if (error != null) {
                                    listener.onReplicateFailed(error);
                                } else {
                                    listener.onReplicateSucceeded(processResult);
                                }
                            }
                        }
                    }
                });
                delegatedToAsync = true;
            }
            finally {
                if (!delegatedToAsync) {
                    replicatedDataPacketResource.release();
                }
            }
        }

        private void trackPendingErrorIfNeeded(Throwable t, IIdleStateData idleStateData) {
            if (t instanceof ReplicationException) {
                AsyncReplicationSourceChannel.this.getGroupBacklog().setPendingError(AsyncReplicationSourceChannel.this.getMemberName(), t, idleStateData);
            }
            if (t instanceof RuntimeException) {
                AsyncReplicationSourceChannel.this.getGroupBacklog().setPendingError(AsyncReplicationSourceChannel.this.getMemberName(), t, idleStateData);
            }
            if (t instanceof Error) {
                AsyncReplicationSourceChannel.this.getGroupBacklog().setPendingError(AsyncReplicationSourceChannel.this.getMemberName(), t, idleStateData);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReplicateFailed(Throwable error) {
            Object object = AsyncReplicationSourceChannel.this._asyncDispatcherLifeCycle;
            synchronized (object) {
                List<IReplicationOrderedPacket> packets = this._currentCyclePackets;
                IIdleStateData idleStateData = this._currentCycleIdleStateData;
                this._currentCyclePackets = null;
                this._currentCycleIdleStateData = null;
                if (error instanceof RemoteException) {
                    if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                        AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "AsyncDispatcher cycle error.", error);
                    }
                } else if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                    AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINER, "AsyncDispatcher cycle error while replicating " + (packets != null ? packets : idleStateData) + "." + StringUtils.NEW_LINE + AsyncReplicationSourceChannel.this.getGroupBacklog().toLogMessage(AsyncReplicationSourceChannel.this.getMemberName()), JSpaceUtilities.getRootCauseException(error));
                }
                this.getHandler().resume();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReplicateSucceeded(IProcessResult processResult) {
            Object object = AsyncReplicationSourceChannel.this._asyncDispatcherLifeCycle;
            synchronized (object) {
                block11: {
                    GlobalOrderProcessResult typedResult;
                    List<IReplicationOrderedPacket> packets = this._currentCyclePackets;
                    List<IReplicationOrderedPacket> idleStateData = this._currentCyclePackets;
                    this._currentCyclePackets = null;
                    this._currentCycleIdleStateData = null;
                    long remainingWeight = AsyncReplicationSourceChannel.this.getGroupBacklog().getWeight(AsyncReplicationSourceChannel.this.getMemberName());
                    if (remainingWeight >= (long)AsyncReplicationSourceChannel.this._intervalOperations) {
                        this.getHandler().resumeNow();
                        return;
                    }
                    if (processResult != null && processResult instanceof GlobalOrderProcessResult && !(typedResult = (GlobalOrderProcessResult)processResult).isProcessed() && typedResult.getError() == null) {
                        if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                            AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINER, "Replication was not fully processed, probably due to unconsolidated transactions, resuming replication.");
                        }
                        this.getHandler().resumeNow();
                        return;
                    }
                    if (AsyncReplicationSourceChannel.this.isSynchronizing()) {
                        try {
                            AsyncReplicationSourceChannel.this.signalSynchronizingDone();
                        }
                        catch (RemoteException e) {
                            if (AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                                AsyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "AsyncDispatcher cycle error.", e);
                            }
                        }
                        catch (Throwable t) {
                            if (!AsyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.SEVERE)) break block11;
                            AsyncReplicationSourceChannel.this._specificLogger.log(Level.SEVERE, "AsyncDispatcher cycle error while replicating " + (packets != null ? packets : idleStateData) + "." + StringUtils.NEW_LINE + AsyncReplicationSourceChannel.this.getGroupBacklog().toLogMessage(AsyncReplicationSourceChannel.this.getMemberName()), t);
                        }
                    }
                }
                this.getHandler().resume();
            }
        }
    }
}

