/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.async.IReplicationAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.async.IAsyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class AsyncReplicationSourceGroup
extends AbstractReplicationSourceGroup<SourceGroupConfig>
implements IReplicationSourceGroup {
    private final IReplicationAsyncGroupBacklog _groupBacklog;
    private final Map<String, AsyncReplicationSourceChannel> _channelsMap;
    private final CopyOnWriteArrayList<AsyncReplicationSourceChannel> _channels;
    private final int _batchSize;
    private final long _interval;
    private final int _intervalOperations;
    private final IAsyncHandler _droppedTargetScanner;

    public AsyncReplicationSourceGroup(DynamicSourceGroupConfigHolder groupConfig, IReplicationRouter replicationRouter, IReplicationAsyncGroupBacklog groupBacklog, String myLookupName, IReplicationOutFilter outFilter, int batchSize, long intervalMilis, int intervalOperations, IAsyncHandlerProvider asyncProvider, IReplicationSourceGroupStateListener stateListener) {
        super(groupConfig, replicationRouter, groupBacklog, myLookupName, outFilter, asyncProvider, stateListener);
        this._batchSize = batchSize;
        this._interval = intervalMilis;
        this._intervalOperations = intervalOperations;
        this._groupBacklog = groupBacklog;
        this._channelsMap = new CopyOnUpdateMap<String, AsyncReplicationSourceChannel>();
        this._channels = new CopyOnWriteArrayList();
        this.createReplicationChannels();
        this._droppedTargetScanner = this.getAsyncHandlerProvider().start(new DroppedTargetScanner(), this._interval, "DroppedTargetScanner-" + groupConfig.getConfig().getName(), false);
    }

    @Override
    protected AbstractReplicationSourceChannel createChannel(String memberLookupName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationChannelDataFilter dataFilter, IReplicationGroupHistory groupHistory, boolean dynamicMember, SourceGroupConfig groupConfig, Object customBacklogMetadata) {
        AsyncSourceGroupConfig asyncGroupConfig = (AsyncSourceGroupConfig)groupConfig;
        int batchSize = this._batchSize;
        long intervalMilis = this._interval;
        int intervalOperations = this._intervalOperations;
        ReplicationStatistics.ReplicationMode channelType = ReplicationStatistics.ReplicationMode.ACTIVE_SPACE;
        AsyncChannelConfig specificConfig = (AsyncChannelConfig)asyncGroupConfig.getChannelConfig(memberLookupName);
        if (specificConfig != null) {
            batchSize = specificConfig.getBatchSize();
            intervalMilis = specificConfig.getIntervalMilis();
            intervalOperations = specificConfig.getIntervalOperations();
            channelType = specificConfig.getChannelType();
        }
        AsyncReplicationSourceChannel channel = new AsyncReplicationSourceChannel(this.getConfigHolder(), this.getGroupName(), memberLookupName, replicationRouter, connection, this._groupBacklog, this.getOutFilter(), batchSize, intervalMilis, intervalOperations, this.getAsyncHandlerProvider(), dataFilter, this.getStateListener(), groupHistory, channelType, customBacklogMetadata);
        this._channelsMap.put(memberLookupName, channel);
        this._channels.add(channel);
        return channel;
    }

    @Override
    protected void onCloseTemporaryChannel(String sourceMemberName, AbstractReplicationSourceChannel channel) {
        this._channels.remove(channel);
        this._channelsMap.remove(sourceMemberName);
    }

    @Override
    public void beforeExecute(ReplicationOutContext replicationContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        IAsyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.add(groupContext, entryHolder, operationType);
    }

    @Override
    public void beforeTransactionExecute(ReplicationOutContext replicationContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        IAsyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.addTransaction(groupContext, transaction, lockedEntries, operationType);
    }

    @Override
    public void beforeExecuteGeneric(ReplicationOutContext replicationContext, Object operationData, ReplicationSingleOperationType operationType) {
        IAsyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.addGeneric(groupContext, operationData, operationType);
    }

    @Override
    public int executeImpl(IReplicationGroupOutContext groupContext) {
        if (groupContext.isEmpty()) {
            return 0;
        }
        IAsyncReplicationGroupOutContext asyncGroupContext = (IAsyncReplicationGroupOutContext)groupContext;
        for (AsyncReplicationSourceChannel channel : this._channels) {
            channel.execute(asyncGroupContext);
        }
        return 0;
    }

    private IAsyncReplicationGroupOutContext getGroupContext(ReplicationOutContext replicationContext) {
        IAsyncReplicationGroupOutContext groupContext = (IAsyncReplicationGroupOutContext)replicationContext.getGroupContext(this.getGroupName());
        if (groupContext == null) {
            groupContext = new AsyncReplicationGroupOutContext(this.getGroupName());
            replicationContext.setGroupContext(groupContext);
        }
        return groupContext;
    }

    @Override
    protected AbstractReplicationSourceChannel getChannel(String memberLookupName) {
        return super.getChannel(memberLookupName);
    }

    @Override
    protected String[] getPotentialRemovedMembers(SourceGroupConfig config) {
        return config.getMembersLookupNames();
    }

    @Override
    protected void onClose() {
        this._droppedTargetScanner.stop(3L, TimeUnit.SECONDS);
        super.onClose();
    }

    public class DroppedTargetScanner
    extends AsyncCallable {
        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            AsyncReplicationSourceGroup.this.scanAndRemoveDroppedMembers();
            return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
        }
    }
}

