/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.async.IReplicationAsyncBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.async.IReplicationAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicAsyncSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;

@InternalApi
public class AsyncReplicationSourceGroupBuilder
extends AbstractReplicationSourceGroupBuilder<SourceGroupConfig> {
    private long _intervalMilis;
    private IAsyncHandlerProvider _asyncHandlerProvider;
    private int _batchSize;
    private IReplicationAsyncBacklogBuilder _backlogBuilder;
    private int _intervalOperations;

    public AsyncReplicationSourceGroupBuilder(DynamicAsyncSourceGroupConfigHolder groupConfig) {
        super(groupConfig);
    }

    public void setIntervalMilis(long intervalMilis) {
        this._intervalMilis = intervalMilis;
    }

    public void setIntervalOperations(int intervalOperations) {
        this._intervalOperations = intervalOperations;
    }

    public void setAsyncHandlerProvider(IAsyncHandlerProvider asyncHandlerProvider) {
        this._asyncHandlerProvider = asyncHandlerProvider;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
    }

    public void setBacklogBuilder(IReplicationAsyncBacklogBuilder backlogBuilder) {
        this._backlogBuilder = backlogBuilder;
    }

    @Override
    protected IReplicationSourceGroup createGroupImpl(DynamicSourceGroupConfigHolder groupConfig, IReplicationRouter replicationRouter, IReplicationOutFilter outFilter, IReplicationSourceGroupStateListener stateListener) {
        IReplicationAsyncGroupBacklog groupBacklog = this._backlogBuilder.createAsyncGroupBacklog(groupConfig);
        return new AsyncReplicationSourceGroup(groupConfig, replicationRouter, groupBacklog, replicationRouter.getMyLookupName(), outFilter, this._batchSize, this._intervalMilis, this._intervalOperations, this._asyncHandlerProvider, stateListener);
    }

    public String toString() {
        return "AsyncReplicationSourceGroupBuilder [_groupConfig=" + this.getGroupConfig() + ", _intervalMilis=" + this._intervalMilis + ", _asyncHandlerProvider=" + this._asyncHandlerProvider + ", _batchSize=" + this._batchSize + ", _backlogBuilder=" + this._backlogBuilder + "]";
    }
}

