/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ConsistencyLevelViolationException;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.GroupConsistencyLevelPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationSourceChannel;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.LinkedList;

@InternalApi
public class SyncMembersInSyncConsistencyLevelPolicy
extends GroupConsistencyLevelPolicy {
    private int _minNumberOfSyncMembers = -1;

    public SyncMembersInSyncConsistencyLevelPolicy minNumberOfSyncMembers(int minNumberOfSyncMembers) {
        if (minNumberOfSyncMembers <= 1) {
            throw new IllegalArgumentException("minNumberOfSyncMembers must be larger than 1");
        }
        this._minNumberOfSyncMembers = minNumberOfSyncMembers;
        return this;
    }

    public int getMinNumberOfSyncMembers() {
        return this._minNumberOfSyncMembers;
    }

    public boolean isAllSyncMembersNeedsToBeInSync() {
        return this._minNumberOfSyncMembers == -1;
    }

    public void checkConsistencyLevel(SyncReplicationSourceChannel[] syncChannels, String myMemberName) throws ConsistencyLevelViolationException {
        int numberOfInSyncMembers = 1;
        for (SyncReplicationSourceChannel syncChannel : syncChannels) {
            ReplicationStatistics.ReplicationOperatingMode channelOpertingMode = syncChannel.getChannelOpertingMode();
            if (this.isAllSyncMembersNeedsToBeInSync()) {
                if (channelOpertingMode == ReplicationStatistics.ReplicationOperatingMode.SYNC) continue;
                throw new ConsistencyLevelViolationException("Replication member [" + syncChannel.getMemberName() + "] is not in synchronous state while consistency level policy states that all synchronous members must be in synchronous state");
            }
            if (channelOpertingMode != ReplicationStatistics.ReplicationOperatingMode.SYNC || ++numberOfInSyncMembers < this.getMinNumberOfSyncMembers()) continue;
            return;
        }
        if (!this.isAllSyncMembersNeedsToBeInSync()) {
            LinkedList<String> insyncMembers = new LinkedList<String>();
            insyncMembers.add(myMemberName);
            LinkedList<String> outOfSyncMembers = new LinkedList<String>();
            numberOfInSyncMembers = 1;
            for (SyncReplicationSourceChannel syncChannel : syncChannels) {
                ReplicationStatistics.ReplicationOperatingMode channelOpertingMode = syncChannel.getChannelOpertingMode();
                if (channelOpertingMode == ReplicationStatistics.ReplicationOperatingMode.SYNC) {
                    if (++numberOfInSyncMembers >= this.getMinNumberOfSyncMembers()) {
                        return;
                    }
                    insyncMembers.add(syncChannel.getMemberName());
                    continue;
                }
                outOfSyncMembers.add(syncChannel.getMemberName());
            }
            throw new ConsistencyLevelViolationException("The minimal number of synchronous members in synchronous state required by the consistency level policy is not met, [" + insyncMembers.size() + "/" + (syncChannels.length + 1) + "] members are currently in synchronous state while the policy requires at least " + this.getMinNumberOfSyncMembers() + " member to be in synchronous state. The members in synchronous state are " + insyncMembers + ". The members which are not in synchronous state are " + outOfSyncMembers);
        }
    }

    public void checkConsistencyLevel(SyncReplicationSourceChannel syncChannel) {
        if (syncChannel.getChannelOpertingMode() != ReplicationStatistics.ReplicationOperatingMode.SYNC) {
            throw new ConsistencyLevelViolationException("Replication member [" + syncChannel.getMemberName() + "] is not in synchronous state while consistency level policy states that it must be in synchronous state");
        }
    }
}

