/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.config.SourceChannelConfig;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class AsyncChannelConfig
extends SourceChannelConfig {
    private static final long serialVersionUID = 1L;
    private int _batchSize;
    private long _intervalMilis;
    private int _intervalOperations;
    private ReplicationStatistics.ReplicationMode _channelType;

    public AsyncChannelConfig() {
    }

    public AsyncChannelConfig(int batchSize, long intervalMilis, int intervalOperations, ReplicationStatistics.ReplicationMode channelType) {
        this(batchSize, intervalMilis, intervalOperations, channelType, -1L);
    }

    public AsyncChannelConfig(int batchSize, long intervalMilis, int intervalOperations, ReplicationStatistics.ReplicationMode channelType, long maxAllowedDisconnectionTimeBeforeDrop) {
        super(maxAllowedDisconnectionTimeBeforeDrop);
        this._batchSize = batchSize;
        this._intervalMilis = intervalMilis;
        this._intervalOperations = intervalOperations;
        this._channelType = channelType;
    }

    public ReplicationStatistics.ReplicationMode getChannelType() {
        return this._channelType;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public long getIntervalMilis() {
        return this._intervalMilis;
    }

    public int getIntervalOperations() {
        return this._intervalOperations;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._batchSize);
        out.writeLong(this._intervalMilis);
        out.writeInt(this._intervalOperations);
        out.writeByte(this._channelType.getCode());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._batchSize = in.readInt();
        this._intervalMilis = in.readLong();
        this._intervalOperations = in.readInt();
        this._channelType = ReplicationStatistics.ReplicationMode.fromCode(in.readByte());
    }
}

