/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncMemberData;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class FetchReliableAsyncMissingMemberDataPacket
extends AbstractGroupNameReplicationPacket<ReliableAsyncMemberData> {
    private static final long serialVersionUID = 1L;
    private String _missingMemberName;

    public FetchReliableAsyncMissingMemberDataPacket() {
    }

    public FetchReliableAsyncMissingMemberDataPacket(String groupName, String missingMemberName) {
        super(groupName);
        this._missingMemberName = missingMemberName;
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeRepetitiveString(out, this._missingMemberName);
    }

    @Override
    protected void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._missingMemberName = IOUtils.readRepetitiveString(in);
    }

    @Override
    public ReliableAsyncMemberData accept(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationSourceGroup sourceGroup = incomingReplicationFacade.getReplicationSourceGroup(this.getGroupName());
        DynamicSourceGroupConfigHolder configHolder = sourceGroup.getConfigHolder();
        SourceGroupConfig config = configHolder.getConfig();
        if (!Arrays.asList(config.getMembersLookupNames()).contains(this._missingMemberName)) {
            config = configHolder.getConfigWithMemberBeingAdded();
        }
        if (!(config != null && Arrays.asList(config.getMembersLookupNames()).contains(this._missingMemberName) || Arrays.asList((config = configHolder.getConfig()).getMembersLookupNames()).contains(this._missingMemberName))) {
            return null;
        }
        ReliableAsyncSourceGroupConfig reliableAsyncSourceGroupConfig = (ReliableAsyncSourceGroupConfig)config;
        IReplicationChannelDataFilter filter = config.getFilter(this._missingMemberName);
        DynamicSourceGroupMemberLifeCycle lifeCycle = config.getLifeCycle(this._missingMemberName);
        BacklogMemberLimitationConfig memberLimitations = config.getBacklogConfig().getBacklogMemberLimitation(this._missingMemberName);
        AsyncChannelConfig asyncChannelConfig = (AsyncChannelConfig)reliableAsyncSourceGroupConfig.getChannelConfig(this._missingMemberName);
        RouterStubHolder routerStubHolder = incomingReplicationFacade.getRemoteRouterStub(this._missingMemberName);
        return new ReliableAsyncMemberData(memberLimitations, filter, lifeCycle, routerStubHolder, asyncChannelConfig);
    }

    public String getMissingMemberLookupName() {
        return this._missingMemberName;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("missingMemberName", this._missingMemberName);
    }
}

