/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelEntryDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryDataContentExtractor;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.logging.Logger;

@InternalApi
public class GatewayChannelDataFilter
extends ReliableAsyncChannelDataFilter {
    private final boolean _sendChangeAsUpdate;

    public GatewayChannelDataFilter(boolean replicateChangeAsUpdate) {
        this._sendChangeAsUpdate = replicateChangeAsUpdate;
    }

    public ReplicationChannelEntryDataFilterResult filterBeforeReplicatingEntryData(IReplicationPacketEntryData entryData, PlatformLogicalVersion targetLogicalVersion, IReplicationPacketEntryDataContentExtractor contentExtractor, Logger contextLogger, IReplicationPacketData data) {
        if (entryData.isFromGateway()) {
            return ReplicationChannelEntryDataFilterResult.FILTER_PACKET;
        }
        switch (entryData.getOperationType()) {
            case WRITE: 
            case UPDATE: 
            case REMOVE_ENTRY: 
            case DATA_TYPE_INTRODUCE: 
            case DATA_TYPE_ADD_INDEX: 
            case DISCARD: {
                return ReplicationChannelEntryDataFilterResult.PASS;
            }
            case CANCEL_LEASE: 
            case EXTEND_ENTRY_LEASE: {
                if (!targetLogicalVersion.greaterOrEquals(PlatformLogicalVersion.v9_1_0)) break;
                return ReplicationChannelEntryDataFilterResult.PASS;
            }
            case CHANGE: {
                if (this._sendChangeAsUpdate || targetLogicalVersion.lessThan(PlatformLogicalVersion.v9_5_0)) {
                    return ReplicationChannelEntryDataFilterResult.CONVERT_UPDATE;
                }
                return ReplicationChannelEntryDataFilterResult.PASS;
            }
        }
        return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
    }

    @Override
    public ReplicationChannelDataFilterResult filterBeforeReplicatingData(IReplicationPacketData<?> data, PlatformLogicalVersion targetLogicalVersion, Logger contextLogger) {
        ReplicationChannelDataFilterResult filterResult = super.filterBeforeReplicatingData(data, targetLogicalVersion, contextLogger);
        return data.isFromGateway() ? ReplicationChannelDataFilterResult.FILTER_PACKET : filterResult;
    }

    @Override
    public boolean filterBeforeReplicatingUnreliableOperation(IReplicationUnreliableOperation operation, PlatformLogicalVersion targetLogicalVersion) {
        return false;
    }

    @Override
    public Object[] getConstructionArgument() {
        return new Object[]{this._sendChangeAsUpdate};
    }
}

