/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.impl.config.IMirrorChannelReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelEntryDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryDataContentExtractor;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.Collection;
import java.util.logging.Logger;

@InternalApi
public class MirrorChannelDataFilter
extends ReliableAsyncChannelDataFilter {
    private final IMirrorChannelReplicationSettings _mirrorPolicy;

    public MirrorChannelDataFilter(IMirrorChannelReplicationSettings mirrorPolicy) {
        this._mirrorPolicy = mirrorPolicy;
    }

    public ReplicationChannelEntryDataFilterResult filterBeforeReplicatingEntryData(IReplicationPacketEntryData entryData, PlatformLogicalVersion targetLogicalVersion, IReplicationPacketEntryDataContentExtractor contentExtractor, Logger contextLogger, IReplicationPacketData data) {
        if (entryData.isTransient()) {
            return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
        }
        switch (entryData.getOperationType()) {
            case WRITE: 
            case UPDATE: 
            case REMOVE_ENTRY: 
            case DATA_TYPE_INTRODUCE: 
            case DATA_TYPE_ADD_INDEX: 
            case DISCARD: {
                return ReplicationChannelEntryDataFilterResult.PASS;
            }
            case CHANGE: {
                if (!this._mirrorPolicy.supportsChange()) {
                    return ReplicationChannelEntryDataFilterResult.CONVERT_UPDATE;
                }
                Collection mutators = (Collection)contentExtractor.getCustomContent(entryData);
                for (SpaceEntryMutator spaceEntryMutator : mutators) {
                    if (this._mirrorPolicy.getSupportedChangeOperations().contains(spaceEntryMutator.getName())) continue;
                    return ReplicationChannelEntryDataFilterResult.CONVERT_UPDATE;
                }
                return ReplicationChannelEntryDataFilterResult.PASS;
            }
        }
        return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
    }

    @Override
    public boolean filterBeforeReplicatingUnreliableOperation(IReplicationUnreliableOperation operation, PlatformLogicalVersion targetLogicalVersion) {
        switch (operation.getOperationType()) {
            case NotificationSent: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object[] getConstructionArgument() {
        return null;
    }
}

