/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReplicationReliableAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.Collection;
import java.util.List;

@InternalApi
public class ReliableAsyncReplicationSourceChannel
extends AsyncReplicationSourceChannel {
    private final IReplicationReliableAsyncGroupBacklog _groupBacklog;
    private final AbstractReplicationSourceChannel[] _keeperSyncChannels;
    private final IReplicationReliableAsyncGroupBacklog.KeeperMemberState[] _keeperMembersState;

    public ReliableAsyncReplicationSourceChannel(DynamicSourceGroupConfigHolder groupConfig, String groupName, String memberName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationReliableAsyncGroupBacklog groupBacklog, IReplicationOutFilter outFilter, int batchSize, long intervalMilis, int intervalOperations, IAsyncHandlerProvider asyncHandlerProvider, Collection<SyncReplicationSourceChannel> keeperSyncChannelsCollection, IReplicationChannelDataFilter dataFilter, IReplicationSourceGroupStateListener stateListener, IReplicationGroupHistory groupHistory, ReplicationStatistics.ReplicationMode channelType, Object customBacklogMetadata) {
        super(groupConfig, groupName, memberName, replicationRouter, connection, groupBacklog, outFilter, batchSize, intervalMilis, intervalOperations, asyncHandlerProvider, false, dataFilter, stateListener, groupHistory, channelType, customBacklogMetadata);
        this._groupBacklog = groupBacklog;
        this._keeperSyncChannels = keeperSyncChannelsCollection.toArray(new AbstractReplicationSourceChannel[keeperSyncChannelsCollection.size()]);
        this._keeperMembersState = new IReplicationReliableAsyncGroupBacklog.KeeperMemberState[this._keeperSyncChannels.length];
        for (int i = 0; i < this._keeperSyncChannels.length; ++i) {
            this._keeperMembersState[i] = new IReplicationReliableAsyncGroupBacklog.KeeperMemberState(this._keeperSyncChannels[i].getMemberName());
        }
        this.start();
    }

    @Override
    protected List<IReplicationOrderedPacket> getPendingPackets() {
        return this._groupBacklog.getReliableAsyncPackets(this.getMemberName(), this.getBatchSize(), this.getKeeperMembersState(), this.getDataFilter(), this.getTargetLogicalVersion(), this._specificLogger);
    }

    private IReplicationReliableAsyncGroupBacklog.KeeperMemberState[] getKeeperMembersState() {
        for (int i = 0; i < this._keeperSyncChannels.length; ++i) {
            AbstractReplicationSourceChannel keeperChannel = this._keeperSyncChannels[i];
            this._keeperMembersState[i].cannotBypass = keeperChannel.isActive() && !keeperChannel.isInconsistent() && !keeperChannel.isSynchronizing();
        }
        return this._keeperMembersState;
    }

    @Override
    public ReplicationStatistics.ReplicationOperatingMode getChannelOpertingMode() {
        for (int i = 0; i < this._keeperSyncChannels.length; ++i) {
            AbstractReplicationSourceChannel channel = this._keeperSyncChannels[i];
            if (!channel.isActive() || channel.isInconsistent() || channel.getChannelOpertingMode() != ReplicationStatistics.ReplicationOperatingMode.SYNC) continue;
            return ReplicationStatistics.ReplicationOperatingMode.RELIABLE_ASYNC;
        }
        return ReplicationStatistics.ReplicationOperatingMode.ASYNC;
    }
}

