/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ConsistencyLevelViolationException;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationBacklogStateListener;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReplicationReliableAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.MemberAddedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.GroupConsistencyLevelPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.SyncMembersInSyncConsistencyLevelPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleControllerBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.packets.ReliableAsyncStateUpdatePacket;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.ConditionLatch;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.lrmi.DynamicSmartStub;
import com.gigaspaces.metrics.MetricRegistrator;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.kernel.JSpaceUtilities;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class ReliableAsyncReplicationSourceGroup
extends AbstractReplicationSourceGroup<ReliableAsyncSourceGroupConfig>
implements IReplicationBacklogStateListener {
    private final IReplicationReliableAsyncGroupBacklog _groupBacklog;
    private final Map<String, SyncReplicationSourceChannel> _syncChannelsMap;
    private final SyncReplicationSourceChannel[] _syncChannels;
    private final Map<String, ReliableAsyncReplicationSourceChannel> _asyncChannelsMap;
    private final CopyOnWriteArrayList<ReliableAsyncReplicationSourceChannel> _asyncChannels;
    private final IReplicationThrottleControllerBuilder _throttleController;
    private final int _syncChannelAsyncStateBatchSize;
    private final long _syncChannelIdleDelayMilis;
    private final int _asyncChannelBatchSize;
    private final long _asyncChannelIntervalMilis;
    private final int _asyncChannelIntervalOperations;
    private final long _completionNotifierOperationThreshold;
    private final boolean _singleTarget;
    private volatile IAsyncHandler _asyncCompletionNotifier;
    private volatile boolean _active;
    private volatile boolean _passive;
    private long _unsentConfirmedClearedPacketCount;

    public ReliableAsyncReplicationSourceGroup(DynamicSourceGroupConfigHolder groupConfig, IReplicationRouter replicationRouter, IReplicationReliableAsyncGroupBacklog groupBacklog, String myLookupName, IReplicationOutFilter outFilter, IReplicationThrottleControllerBuilder throttleController, IAsyncHandlerProvider asyncHandlerProvider, int syncChannelAsyncStateBatchSize, long syncChannelIdleDelayMilis, int asyncChannelBatchSize, long asyncChannelInterval, int asyncChannelIntervalOperations, IReplicationSourceGroupStateListener stateListener) {
        super(groupConfig, replicationRouter, groupBacklog, myLookupName, outFilter, asyncHandlerProvider, stateListener);
        this._groupBacklog = groupBacklog;
        this._syncChannelsMap = new CopyOnUpdateMap<String, SyncReplicationSourceChannel>();
        this._asyncChannelsMap = new CopyOnUpdateMap<String, ReliableAsyncReplicationSourceChannel>();
        this._throttleController = throttleController;
        this._syncChannelAsyncStateBatchSize = syncChannelAsyncStateBatchSize;
        this._syncChannelIdleDelayMilis = syncChannelIdleDelayMilis;
        this._asyncChannelBatchSize = asyncChannelBatchSize;
        this._asyncChannelIntervalMilis = asyncChannelInterval;
        this._asyncChannelIntervalOperations = asyncChannelIntervalOperations;
        ReliableAsyncSourceGroupConfig config = (ReliableAsyncSourceGroupConfig)this.getConfigHolder().getConfig();
        this._syncChannels = new SyncReplicationSourceChannel[config.getSyncMembersLookupNames().length];
        this._asyncChannels = new CopyOnWriteArrayList();
        this._completionNotifierOperationThreshold = config.getCompletionNotifierPacketsThreshold();
        this._singleTarget = this._syncChannels.length == 1;
        this._groupBacklog.setStateListener(this);
    }

    @Override
    protected AbstractReplicationSourceChannel createChannel(String memberLookupName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationChannelDataFilter dataFilter, IReplicationGroupHistory groupHistory, boolean dynamicMember, SourceGroupConfig groupConfig, Object customBacklogMetadata) {
        ReliableAsyncSourceGroupConfig config = (ReliableAsyncSourceGroupConfig)groupConfig;
        if (Arrays.asList(config.getSyncMembersLookupNames()).contains(memberLookupName)) {
            return this.createSyncChannel(memberLookupName, replicationRouter, connection, dataFilter, groupHistory, dynamicMember, customBacklogMetadata);
        }
        return this.createAsyncChannel(memberLookupName, replicationRouter, connection, dataFilter, groupHistory, config, customBacklogMetadata);
    }

    @Override
    protected void onCloseTemporaryChannel(String sourceMemberName, AbstractReplicationSourceChannel channel) {
        if (this._syncChannelsMap.remove(sourceMemberName) != null) {
            for (int i = 0; i < this._syncChannels.length; ++i) {
                if (this._syncChannels[i] != channel) continue;
                this._syncChannels[i] = null;
                break;
            }
        } else if (this._asyncChannels.remove(channel)) {
            this._asyncChannelsMap.remove(sourceMemberName);
        }
    }

    private AbstractReplicationSourceChannel createAsyncChannel(String memberLookupName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationChannelDataFilter dataFilter, IReplicationGroupHistory groupHistory, ReliableAsyncSourceGroupConfig groupConfig, Object customBacklogMetadata) {
        int batchSize = this._asyncChannelBatchSize;
        long intervalMilis = this._asyncChannelIntervalMilis;
        int intervalOperations = this._asyncChannelIntervalOperations;
        ReplicationStatistics.ReplicationMode channelType = ReplicationStatistics.ReplicationMode.MIRROR;
        AsyncChannelConfig specificConfig = (AsyncChannelConfig)groupConfig.getChannelConfig(memberLookupName);
        if (specificConfig != null) {
            batchSize = specificConfig.getBatchSize();
            intervalMilis = specificConfig.getIntervalMilis();
            intervalOperations = specificConfig.getIntervalOperations();
            channelType = specificConfig.getChannelType();
        }
        ReliableAsyncReplicationSourceChannel channel = new ReliableAsyncReplicationSourceChannel(this.getConfigHolder(), this.getGroupName(), memberLookupName, replicationRouter, connection, this._groupBacklog, this.getOutFilter(), batchSize, intervalMilis, intervalOperations, this.getAsyncHandlerProvider(), this._syncChannelsMap.values(), dataFilter, this.getStateListener(), groupHistory, channelType, customBacklogMetadata);
        this._asyncChannelsMap.put(memberLookupName, channel);
        this._asyncChannels.add(channel);
        return channel;
    }

    private AbstractReplicationSourceChannel createSyncChannel(String memberLookupName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationChannelDataFilter dataFilter, IReplicationGroupHistory groupHistory, boolean dynamicMember, Object customBacklogMetadata) {
        if (dynamicMember) {
            throw new UnsupportedOperationException("Cannot add dynamically a synchronous channel");
        }
        SyncReplicationSourceChannel channel = new SyncReplicationSourceChannel(this.getConfigHolder(), this.getGroupName(), memberLookupName, replicationRouter, connection, this._groupBacklog, this.getOutFilter(), this._throttleController.createController(this.getGroupName(), this.getMyLookupName(), memberLookupName), this.getAsyncHandlerProvider(), this._syncChannelAsyncStateBatchSize, this._syncChannelIdleDelayMilis, dataFilter, this.getStateListener(), groupHistory, ReplicationStatistics.ReplicationMode.BACKUP_SPACE, customBacklogMetadata);
        this._syncChannelsMap.put(memberLookupName, channel);
        return channel;
    }

    @Override
    public void beforeExecute(ReplicationOutContext replicationContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        this.validateActive();
        ReliableAsyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.add(groupContext, entryHolder, operationType);
    }

    @Override
    public void beforeExecuteGeneric(ReplicationOutContext replicationContext, Object operationData, ReplicationSingleOperationType operationType) {
        this.validateActive();
        ReliableAsyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.addGeneric(groupContext, operationData, operationType);
    }

    @Override
    public void beforeTransactionExecute(ReplicationOutContext replicationContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        this.validateActive();
        ReliableAsyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.addTransaction(groupContext, transaction, lockedEntries, operationType);
    }

    private void validateActive() {
        if (!this._active) {
            throw new IllegalStateException("Reliable async source group cannot be actively accesses when it is not in active state");
        }
    }

    @Override
    public int executeImpl(IReplicationGroupOutContext groupContext) {
        this.validateActive();
        if (groupContext.isEmpty()) {
            return 0;
        }
        int res = 0;
        ReliableAsyncReplicationGroupOutContext reliableAsyncGroupContext = (ReliableAsyncReplicationGroupOutContext)groupContext;
        if (this.isSingleTarget()) {
            res = this._syncChannels[0].execute(reliableAsyncGroupContext);
        } else {
            int i;
            Future[] _futures = new Future[this._syncChannels.length];
            for (i = 0; i < this._syncChannels.length; ++i) {
                _futures[i] = this._syncChannels[i].executeAsync(reliableAsyncGroupContext);
            }
            for (i = 0; i < _futures.length; ++i) {
                try {
                    _futures[i].get();
                    ++res;
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (!(cause instanceof Error)) continue;
                    throw (Error)cause;
                }
            }
        }
        for (ReliableAsyncReplicationSourceChannel channel : this._asyncChannels) {
            channel.execute(reliableAsyncGroupContext);
        }
        return res;
    }

    @Override
    public void execute(IReplicationUnreliableOperation operation) {
        this.validateActive();
        super.execute(operation);
    }

    @Override
    protected void validateGroupConsistencyLevelPolicy(GroupConsistencyLevelPolicy groupSlaPolicy, ReliableAsyncSourceGroupConfig sourceGroupConfig) {
        if (!(groupSlaPolicy instanceof SyncMembersInSyncConsistencyLevelPolicy)) {
            super.validateGroupConsistencyLevelPolicy(groupSlaPolicy, sourceGroupConfig);
        } else {
            SyncMembersInSyncConsistencyLevelPolicy syncMembersInSyncSlaPolicy = (SyncMembersInSyncConsistencyLevelPolicy)groupSlaPolicy;
            if (!syncMembersInSyncSlaPolicy.isAllSyncMembersNeedsToBeInSync() && syncMembersInSyncSlaPolicy.getMinNumberOfSyncMembers() > sourceGroupConfig.getSyncMembersLookupNames().length + 1) {
                throw new IllegalArgumentException("Cannot specify minimum number of synchronous members in replication group consistency level policy which is more than the number of synchronous members in the group.Number of members in the group is " + (sourceGroupConfig.getSyncMembersLookupNames().length + 1) + " while the minimal requested is " + syncMembersInSyncSlaPolicy.getMinNumberOfSyncMembers());
            }
        }
    }

    @Override
    public void monitorConsistencyLevel() throws ConsistencyLevelViolationException {
        super.monitorConsistencyLevel();
        GroupConsistencyLevelPolicy groupConsistencyLevelPolicy = this.getConfigHolder().getConfig().getGroupConsistencyLevelPolicy();
        if (GroupConsistencyLevelPolicy.isEmptyPolicy(groupConsistencyLevelPolicy)) {
            return;
        }
        if (groupConsistencyLevelPolicy instanceof SyncMembersInSyncConsistencyLevelPolicy) {
            if (this.isSingleTarget()) {
                ((SyncMembersInSyncConsistencyLevelPolicy)groupConsistencyLevelPolicy).checkConsistencyLevel(this._syncChannels[0]);
            } else {
                ((SyncMembersInSyncConsistencyLevelPolicy)groupConsistencyLevelPolicy).checkConsistencyLevel(this._syncChannels, this.getMyLookupName());
            }
        }
    }

    private ReliableAsyncReplicationGroupOutContext getGroupContext(ReplicationOutContext replicationContext) {
        ReliableAsyncReplicationGroupOutContext groupContext = (ReliableAsyncReplicationGroupOutContext)replicationContext.getGroupContext(this.getGroupName());
        if (groupContext == null) {
            groupContext = new ReliableAsyncReplicationGroupOutContext(this.getGroupName());
            replicationContext.setGroupContext(groupContext);
        }
        return groupContext;
    }

    @Override
    protected AbstractReplicationSourceChannel getChannel(String memberLookupName) {
        return super.getChannel(memberLookupName);
    }

    @Override
    protected void onMemberAdded(MemberAddedEvent memberAddedEvent, SourceGroupConfig newConfig) {
        if (this._active) {
            super.onMemberAdded(memberAddedEvent, newConfig);
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("Notifying reliable async keepers of member [" + memberAddedEvent.getMemberName() + "] addition");
            }
            this.notifyKeepersOfGroupMembersChange(newConfig);
            this._groupBacklog.makeMemberConfirmedOnAll(memberAddedEvent.getMemberName());
            this.notifyKeepersOfGroupMembersChange(newConfig);
        }
    }

    protected void notifyKeepersOfGroupMembersChange(SourceGroupConfig newConfig) {
        IAsyncHandler asyncCompletionNotifier = this._asyncCompletionNotifier;
        if (asyncCompletionNotifier != null) {
            ReliableAsyncSourceGroupConfig typedConfig = (ReliableAsyncSourceGroupConfig)newConfig;
            asyncCompletionNotifier.wakeUpAndWait(typedConfig.getCompletionNotifierInterval(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void onMemberRemoved(String memberName, SourceGroupConfig newConfig) {
        if (this._active) {
            this._asyncChannelsMap.remove(memberName);
            super.onMemberRemoved(memberName, newConfig);
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("Notifying reliable async keepers of member [" + memberName + "] removal");
            }
            this.notifyKeepersOfGroupMembersChange(newConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActive(MetricRegistrator metricRegistrator) {
        Object object = this._channelCreationLock;
        synchronized (object) {
            super.setActive(metricRegistrator);
            if (this._passive) {
                this.logGroupEvent("Becoming active - Backlog dump: " + this.getGroupBacklog().dumpState());
            }
            ReliableAsyncSourceGroupConfig sourceGroupConfig = (ReliableAsyncSourceGroupConfig)this.getConfigHolder().getConfig();
            if (this._passive && sourceGroupConfig.getSyncMembersLookupNames().length > 1) {
                this.createReplicationChannelsSequentially();
            } else {
                this.createReplicationChannels();
            }
            this.prepareChannelsArrays();
            this.spawnAsyncCompletionNotifier();
            this.registerWith(metricRegistrator);
            this._passive = false;
            this._active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReplicationChannelsSequentially() {
        Object object = this._channelCreationLock;
        synchronized (object) {
            ReliableAsyncSourceGroupConfig config = (ReliableAsyncSourceGroupConfig)this.getConfigHolder().getConfig();
            for (String memberLookupName : config.getSyncMembersLookupNames()) {
                block9: {
                    this.createChannel(memberLookupName, false, config, true, null);
                    final AbstractReplicationSourceChannel channel = this.getChannel(memberLookupName);
                    ConditionLatch conditionLatch = new ConditionLatch().timeout(30L, TimeUnit.SECONDS).pollingInterval(50L, TimeUnit.MILLISECONDS);
                    try {
                        conditionLatch.waitFor(new ConditionLatch.Predicate(){

                            @Override
                            public boolean isDone() throws InterruptedException {
                                return channel.isActive() || channel.isInconsistent() || channel.getConnection().getState() == ConnectionState.DISCONNECTED;
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (TimeoutException e) {
                        if (!this._specificLogger.isLoggable(Level.WARNING)) break block9;
                        this._specificLogger.warning(this.getLogPrefix() + "timeout occurred while waiting for active state of newly created channel to " + memberLookupName);
                    }
                }
                if (!this._specificLogger.isLoggable(Level.FINEST)) continue;
                this._specificLogger.finest(this.getLogPrefix() + "created channel to " + memberLookupName);
            }
            for (String memberLookupName : config.getAsyncMembersLookupNames()) {
                this.createChannel(memberLookupName, false, config, false, null);
                if (!this._specificLogger.isLoggable(Level.FINEST)) continue;
                this._specificLogger.finest(this.getLogPrefix() + "created channel to " + memberLookupName);
            }
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finest(this.getLogPrefix() + "created all channels");
            }
        }
    }

    private void prepareChannelsArrays() {
        int index = 0;
        Collection<SyncReplicationSourceChannel> syncValues = this._syncChannelsMap.values();
        for (SyncReplicationSourceChannel sourceChannel : syncValues) {
            this._syncChannels[index++] = sourceChannel;
        }
        index = 0;
        this._asyncChannels.clear();
        Collection<ReliableAsyncReplicationSourceChannel> asyncValues = this._asyncChannelsMap.values();
        for (ReliableAsyncReplicationSourceChannel sourceChannel : asyncValues) {
            this._asyncChannels.add(sourceChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassive(boolean closeProxy) {
        Object object = this._channelCreationLock;
        synchronized (object) {
            try {
                super.setPassive(closeProxy);
                DynamicSmartStub.markProxyAsClosed.set(closeProxy);
                this._active = false;
                this.closeAsyncCompletionNotifier();
                this.closeReplicationChannels();
                this.clearChannelsArrays();
                this._syncChannelsMap.clear();
                this._asyncChannelsMap.clear();
                this._passive = true;
            }
            finally {
                DynamicSmartStub.markProxyAsClosed.remove();
            }
        }
    }

    private void clearChannelsArrays() {
        for (int i = 0; i < this._syncChannels.length; ++i) {
            this._syncChannels[i] = null;
        }
        this._asyncChannels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() {
        Object object = this._channelCreationLock;
        synchronized (object) {
            this.closeAsyncCompletionNotifier();
        }
        super.onClose();
    }

    private void spawnAsyncCompletionNotifier() {
        ReliableAsyncSourceGroupConfig config = (ReliableAsyncSourceGroupConfig)this.getConfigHolder().getConfig();
        this._asyncCompletionNotifier = this.getAsyncHandlerProvider().start(new AsyncCompletionNotifier(), config.getCompletionNotifierInterval(), "AsyncCompletionNotifier-" + this.getMyLookupName() + "." + this.getGroupName(), false);
    }

    public boolean isSingleTarget() {
        return this._singleTarget;
    }

    private void closeAsyncCompletionNotifier() {
        if (this._asyncCompletionNotifier != null) {
            this._asyncCompletionNotifier.stop(3L, TimeUnit.SECONDS);
        }
        this._asyncCompletionNotifier = null;
    }

    @Override
    protected String[] getPotentialRemovedMembers(SourceGroupConfig config) {
        return ((ReliableAsyncSourceGroupConfig)config).getAsyncMembersLookupNames();
    }

    @Override
    public void onPacketsClearedAfterConfirmation(long packetsCount) {
        this._unsentConfirmedClearedPacketCount += packetsCount;
        if (this._unsentConfirmedClearedPacketCount >= this._completionNotifierOperationThreshold) {
            this._unsentConfirmedClearedPacketCount = 0L;
            IAsyncHandler asyncCompletionNotifier = this._asyncCompletionNotifier;
            if (asyncCompletionNotifier != null) {
                asyncCompletionNotifier.wakeUp();
            }
        }
    }

    public class AsyncCompletionNotifier
    extends AsyncCallable {
        private final ReliableAsyncStateUpdatePacket _updatePacket;
        private Throwable _pendingException;

        public AsyncCompletionNotifier() {
            this._updatePacket = new ReliableAsyncStateUpdatePacket(ReliableAsyncReplicationSourceGroup.this.getGroupName());
            this._pendingException = null;
        }

        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            ReliableAsyncReplicationSourceGroup.this.scanAndRemoveDroppedMembers();
            for (SyncReplicationSourceChannel channel : ReliableAsyncReplicationSourceGroup.this._syncChannelsMap.values()) {
                if (!channel.isActive()) continue;
                IReliableAsyncState reliableAsyncState = ReliableAsyncReplicationSourceGroup.this._groupBacklog.getReliableAsyncState(channel.getMemberName());
                this._updatePacket.setState(reliableAsyncState);
                IReplicationMonitoredConnection connection = channel.getConnection();
                try {
                    connection.dispatch(this._updatePacket);
                    this._pendingException = null;
                }
                catch (RemoteException remoteException) {
                }
                catch (RuntimeException rt) {
                    if (!ReliableAsyncReplicationSourceGroup.this._specificLogger.isLoggable(Level.WARNING) || JSpaceUtilities.isSameException(this._pendingException, rt)) continue;
                    this._pendingException = rt;
                    ReliableAsyncReplicationSourceGroup.this._specificLogger.log(Level.WARNING, "error while executing reliable async update", rt);
                }
                catch (Error er) {
                    if (!ReliableAsyncReplicationSourceGroup.this._specificLogger.isLoggable(Level.WARNING) || JSpaceUtilities.isSameException(this._pendingException, er)) continue;
                    this._pendingException = er;
                    ReliableAsyncReplicationSourceGroup.this._specificLogger.log(Level.WARNING, "error while executing reliable async update", er);
                }
            }
            return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
        }
    }
}

