/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationSourceAlreadyAttachedException;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandlerBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;

@InternalApi
public class ReliableAsyncSingleOriginReplicationTargetGroup
extends AbstractReplicationTargetGroup {
    private final IReplicationReliableAsyncProcessLogBuilder _processLogBuilder;
    private final IReplicationProcessLogExceptionHandlerBuilder _exceptionHandlerBuilder;
    private volatile AsyncReplicationTargetChannel _activeChannel;
    private volatile IReplicationReliableAsyncTargetProcessLog _activeProcessLog;

    public ReliableAsyncSingleOriginReplicationTargetGroup(TargetGroupConfig groupConfig, IReplicationRouter replicationRouter, IReplicationInFilter inFilter, IReplicationReliableAsyncProcessLogBuilder processLogBuilder, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandlerBuilder exceptionHandlerBuilder, IReplicationTargetGroupStateListener stateListener) {
        super(groupConfig, replicationRouter, replicationInFacade, inFilter, stateListener);
        this._processLogBuilder = processLogBuilder;
        this._exceptionHandlerBuilder = exceptionHandlerBuilder;
    }

    @Override
    protected AbstractReplicationTargetChannel createNewChannelImpl(ReplicationEndpointDetails sourceEndpointDetails, IReplicationMonitoredConnection sourceConnection, IBacklogHandshakeRequest handshakeRequest, IReplicationGroupHistory groupHistory) {
        this.closeChannel(this._activeChannel);
        IReplicationProcessLogExceptionHandler exceptionHandler = this._exceptionHandlerBuilder.createExceptionHandler(sourceConnection, sourceEndpointDetails.getLookupName(), this.getGroupName());
        IReplicationReliableAsyncTargetProcessLog processLog = this._processLogBuilder.createReliableAsyncProcessLog(this.getGroupConfig(), handshakeRequest, this.getReplicationInFacade(), exceptionHandler, this.getReplicationRouter().getMyLookupName(), this.getGroupName(), sourceEndpointDetails.getLookupName(), this._activeProcessLog, groupHistory, this._specificLogger);
        boolean wasEverActive = this._activeChannel != null;
        this._activeChannel = new AsyncReplicationTargetChannel(this.getGroupConfig(), this.getReplicationRouter().getMyLookupName(), this.getReplicationRouter().getMyUniqueId(), sourceEndpointDetails, sourceConnection, this.getGroupName(), processLog, this.getInFilter(), this.getStateListener(), groupHistory, wasEverActive);
        this._activeProcessLog = processLog;
        return this._activeChannel;
    }

    @Override
    protected void validateConnectChannelImpl(String sourceMemberLookupName) throws ReplicationSourceAlreadyAttachedException {
        boolean activeSourceIsStillAttached;
        if (this._activeChannel != null && (activeSourceIsStillAttached = this._activeChannel.isSourceAttached())) {
            throw new ReplicationSourceAlreadyAttachedException("Replication group " + this.getGroupName() + " only supports one active source member, currently active source is " + this._activeChannel.getSourceLookupName() + "[" + this._activeChannel.getSourceEndpointAddress() + "]");
        }
    }
}

