/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.GroupConsistencyLevelPolicy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;

@InternalApi
public class ReliableAsyncSourceGroupConfig
extends AsyncSourceGroupConfig {
    private final String[] _syncMembersLookupNames;
    private final String[] _asyncMembersLookupNames;
    private final int _backlogCompletionBatchSize;
    private final long _completionNotifierInterval;
    private final long _completionNotifierPacketsThreshold;

    public ReliableAsyncSourceGroupConfig(String groupName, BacklogConfig backlogConfig, GroupConsistencyLevelPolicy groupConsistencyLevelPolicy, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, Map<String, String[]> membersGrouping, String[] syncMembersLookupNames, String[] asyncMembersLookupNames, int backlogCompletionBatchSize, long completionNotifierInterval, long completionNotifierPacketsThreshold) {
        this(groupName, backlogConfig, groupConsistencyLevelPolicy, filters, lifeCycles, membersGrouping, syncMembersLookupNames, asyncMembersLookupNames, backlogCompletionBatchSize, completionNotifierInterval, completionNotifierPacketsThreshold, true);
    }

    public ReliableAsyncSourceGroupConfig(String groupName, BacklogConfig backlogConfig, GroupConsistencyLevelPolicy groupConsistencyLevelPolicy, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, Map<String, String[]> membersGrouping, String[] syncMembersLookupNames, String[] asyncMembersLookupNames, int backlogCompletionBatchSize, long completionNotifierInterval, long completionNotifierPacketsThreshold, boolean networkCompressionEnabled) {
        super(groupName, backlogConfig, groupConsistencyLevelPolicy, filters, lifeCycles, membersGrouping, networkCompressionEnabled, ReliableAsyncSourceGroupConfig.mergeMembersLists(syncMembersLookupNames, asyncMembersLookupNames));
        this._syncMembersLookupNames = syncMembersLookupNames;
        this._asyncMembersLookupNames = asyncMembersLookupNames;
        this._backlogCompletionBatchSize = backlogCompletionBatchSize;
        this._completionNotifierInterval = completionNotifierInterval;
        this._completionNotifierPacketsThreshold = completionNotifierPacketsThreshold;
    }

    private static String[] mergeMembersLists(String[] syncMembersLookupNames, String[] asyncMembersLookupNames) {
        LinkedList<String> merged = new LinkedList<String>(Arrays.asList(syncMembersLookupNames));
        merged.addAll(Arrays.asList(asyncMembersLookupNames));
        return merged.toArray(new String[merged.size()]);
    }

    public String[] getSyncMembersLookupNames() {
        return this._syncMembersLookupNames;
    }

    public String[] getAsyncMembersLookupNames() {
        return this._asyncMembersLookupNames;
    }

    public int getBacklogCompletionBatchSize() {
        return this._backlogCompletionBatchSize;
    }

    public long getCompletionNotifierInterval() {
        return this._completionNotifierInterval;
    }

    public long getCompletionNotifierPacketsThreshold() {
        return this._completionNotifierPacketsThreshold;
    }

    @Override
    public String toString() {
        return "ReliableAsyncSourceGroupConfig [_syncMembersLookupNames=" + Arrays.toString(this._syncMembersLookupNames) + ", _asyncMembersLookupNames=" + Arrays.toString(this._asyncMembersLookupNames) + ", _backlogCompletionBatchSize=" + this._backlogCompletionBatchSize + ", _completionNotifierInterval=" + this._completionNotifierInterval + ", , _completionNotifierPacketsThreshold=" + this._completionNotifierPacketsThreshold + ", " + super.toString() + "]";
    }
}

