/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.NoSuchReplicationMemberException;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReplicationReliableAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.MissingReliableAsyncTargetStateException;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicReliableAsyncSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilterBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.FetchReliableAsyncMissingMemberDataPacket;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IDynamicSourceGroupMemberLifeCycleBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IReplicationReliableAsyncMediator;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncMemberData;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SourceDelegationReplicationReliableAsyncMediator
implements IReplicationReliableAsyncMediator {
    protected final Logger _specificLogger;
    private final IReplicationConnection _sourceConnection;
    private final IReplicationReliableAsyncGroupBacklog _reliableAsyncGroupBacklog;
    private final DynamicReliableAsyncSourceGroupConfigHolder _groupConfigHolder;
    private final IReplicationRouter _router;
    private final IReplicationChannelDataFilterBuilder _filterBuilder;
    private final IDynamicSourceGroupMemberLifeCycleBuilder _lifeCycleBuilder;

    public SourceDelegationReplicationReliableAsyncMediator(DynamicReliableAsyncSourceGroupConfigHolder groupConfigHolder, IReplicationConnection sourceConnection, IReplicationReliableAsyncGroupBacklog reliableAsyncGroupBacklog, String sourceLookupName, String myLookupName, IReplicationRouter router, IReplicationChannelDataFilterBuilder filterBuilder, IDynamicSourceGroupMemberLifeCycleBuilder lifeCycleBuilder) {
        this._groupConfigHolder = groupConfigHolder;
        this._sourceConnection = sourceConnection;
        this._reliableAsyncGroupBacklog = reliableAsyncGroupBacklog;
        this._router = router;
        this._filterBuilder = filterBuilder;
        this._lifeCycleBuilder = lifeCycleBuilder;
        this._specificLogger = ReplicationLogUtils.createChannelSpecificLogger(sourceLookupName, myLookupName, this._groupConfigHolder.getConfig().getName());
    }

    @Override
    public void reliableAsyncSourceAdd(String sourceLookupName, IReplicationOrderedPacket packet) {
        packet.getData().setWeight(this._groupConfigHolder.getConfig().getBacklogConfig().getBackLogWeightPolicy().calculateWeight(packet.getData()));
        this._reliableAsyncGroupBacklog.reliableAsyncSourceAdd(sourceLookupName, packet);
    }

    @Override
    public void reliableAsyncSourceKeep(String sourceMemberName, IReplicationOrderedPacket packet) {
        packet.getData().setWeight(this._groupConfigHolder.getConfig().getBacklogConfig().getBackLogWeightPolicy().calculateWeight(packet.getData()));
        this._reliableAsyncGroupBacklog.reliableAsyncSourceKeep(sourceMemberName, packet);
    }

    @Override
    public void afterHandshake(IProcessLogHandshakeResponse response) {
        this._reliableAsyncGroupBacklog.afterHandshake(response);
    }

    @Override
    public void updateReliableAsyncState(IReliableAsyncState reliableAsyncState, String sourceMemberName) {
        boolean succesfullyUpdated = false;
        do {
            try {
                this._reliableAsyncGroupBacklog.updateReliableAsyncState(reliableAsyncState, sourceMemberName);
                succesfullyUpdated = true;
            }
            catch (MissingReliableAsyncTargetStateException e) {
                String missingMember = e.getMissingMember();
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("Received a missing replication member exception [" + missingMember + "] when updating async state, removing member from group");
                }
                this._groupConfigHolder.removeMember(missingMember);
                this._router.getAdmin().removeRemoteStubHolder(missingMember);
            }
            catch (NoSuchReplicationMemberException e) {
                String missingMemberName = e.getMissingMemberName();
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("Received no such replication member exception [" + missingMemberName + "] when updating async state, retrieving member data from source");
                }
                FetchReliableAsyncMissingMemberDataPacket packet = new FetchReliableAsyncMissingMemberDataPacket(this._groupConfigHolder.getConfig().getName(), missingMemberName);
                try {
                    DynamicSourceGroupMemberLifeCycle memberLifyCycle;
                    ReliableAsyncMemberData memberData = this._sourceConnection.dispatch(packet);
                    if (memberData == null) {
                        if (this._specificLogger.isLoggable(Level.FINER)) {
                            this._specificLogger.finer("The missing member [" + e.getMissingMemberName() + "] is not present at the source, ignoring current update");
                        }
                        return;
                    }
                    BacklogMemberLimitationConfig memberBacklogLimitations = memberData.getMemberBacklogLimitationConfig();
                    String filterName = memberData.getMemberFilterName();
                    Object[] filterConstructArgs = memberData.getMemberFilterConstructArguments();
                    String lifeCycleName = memberData.getMemberLifeCycleName();
                    Object[] lifeCycleConstructArgs = memberData.getMemberLifeCycleConstructArguments();
                    RouterStubHolder routerStub = memberData.getRouterStubHolder();
                    AsyncChannelConfig asyncChannelConfig = memberData.getAsyncChannelConfig();
                    IReplicationChannelDataFilter memberFilter = StringUtils.hasText(filterName) ? this._filterBuilder.createFilter(filterName, this._groupConfigHolder.getConfig().getName(), filterConstructArgs) : null;
                    DynamicSourceGroupMemberLifeCycle dynamicSourceGroupMemberLifeCycle = memberLifyCycle = StringUtils.hasText(lifeCycleName) ? this._lifeCycleBuilder.createLifeCycle(lifeCycleName, this._groupConfigHolder.getConfig().getName(), lifeCycleConstructArgs) : null;
                    if (routerStub != null) {
                        this._router.getAdmin().addRemoteRouterStub(routerStub);
                    }
                    if (this._specificLogger.isLoggable(Level.FINE)) {
                        this._specificLogger.fine("Synchronized new reliable async member [" + missingMemberName + "] state into replication group");
                    }
                    this._groupConfigHolder.addMember(missingMemberName, memberFilter, memberBacklogLimitations, asyncChannelConfig, memberLifyCycle);
                }
                catch (Exception innerE) {
                    if (!this._specificLogger.isLoggable(Level.WARNING)) break;
                    this._specificLogger.log(Level.WARNING, "Failed retrieving missing data for reliable async member [" + missingMemberName + "], skipping update reliable async state", innerE);
                    break;
                }
            }
        } while (!succesfullyUpdated);
    }

    @Override
    public IMarker getMarker(IReplicationOrderedPacket packet, String membersGroupName) {
        return this._reliableAsyncGroupBacklog.getMarker(packet, membersGroupName);
    }

    @Override
    public void performCompaction() {
        this._reliableAsyncGroupBacklog.performCompaction();
    }
}

