/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandlerBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.sync.IReplicationSyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;

public abstract class AbstractSyncReplicationTargetGroup
extends AbstractReplicationTargetGroup {
    private final IReplicationProcessLogExceptionHandlerBuilder _exceptionHandlerBuilder;

    public AbstractSyncReplicationTargetGroup(TargetGroupConfig groupConfig, IReplicationRouter replicationRouter, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandlerBuilder exceptionHandlerBuilder, IReplicationInFilter inFilter, IReplicationTargetGroupStateListener stateListener) {
        super(groupConfig, replicationRouter, replicationInFacade, inFilter, stateListener);
        this._exceptionHandlerBuilder = exceptionHandlerBuilder;
    }

    protected SyncReplicationTargetChannel createChannel(ReplicationEndpointDetails sourceEndpointDetails, IReplicationMonitoredConnection sourceConnection, IBacklogHandshakeRequest handshakeRequest, IReplicationGroupHistory groupHistory) {
        IReplicationProcessLogExceptionHandler exceptionHandler = this._exceptionHandlerBuilder.createExceptionHandler(sourceConnection, sourceEndpointDetails.getLookupName(), this.getGroupName());
        IReplicationSyncTargetProcessLog processLog = this.createProcessLog(this.getGroupConfig(), sourceEndpointDetails.getLookupName(), this.getReplicationInFacade(), exceptionHandler, groupHistory, sourceConnection);
        return new SyncReplicationTargetChannel(this.getGroupConfig(), this.getReplicationRouter().getMyLookupName(), this.getReplicationRouter().getMyUniqueId(), sourceEndpointDetails, sourceConnection, this.getGroupName(), processLog, this.getInFilter(), this.getStateListener(), groupHistory);
    }

    protected abstract IReplicationSyncTargetProcessLog createProcessLog(TargetGroupConfig var1, String var2, IReplicationInFacade var3, IReplicationProcessLogExceptionHandler var4, IReplicationGroupHistory var5, IReplicationConnection var6);
}

