/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationSourceAlreadyAttachedException;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.AbstractSyncReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandlerBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;

public abstract class AbstractSyncSingleOriginReplicationTargetGroup
extends AbstractSyncReplicationTargetGroup {
    protected volatile SyncReplicationTargetChannel _activeChannel;

    public AbstractSyncSingleOriginReplicationTargetGroup(TargetGroupConfig groupConfig, IReplicationRouter replicationRouter, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandlerBuilder exceptionHandlerBuilder, IReplicationInFilter inFilter, IReplicationTargetGroupStateListener stateListener) {
        super(groupConfig, replicationRouter, replicationInFacade, exceptionHandlerBuilder, inFilter, stateListener);
    }

    @Override
    protected void validateConnectChannelImpl(String sourceMemberLookupName) throws ReplicationSourceAlreadyAttachedException {
        boolean activeSourceIsStillAttached;
        if (this._activeChannel != null && (activeSourceIsStillAttached = this._activeChannel.isSourceAttached())) {
            throw new ReplicationSourceAlreadyAttachedException("Replication group " + this.getGroupName() + " only supports one active source member, currently active source is " + this._activeChannel.getSourceLookupName() + "[" + this._activeChannel.getSourceEndpointAddress() + "]");
        }
    }

    @Override
    protected AbstractReplicationTargetChannel createNewChannelImpl(ReplicationEndpointDetails sourceEndpointDetails, IReplicationMonitoredConnection sourceConnection, IBacklogHandshakeRequest handshakeRequest, IReplicationGroupHistory groupHistory) {
        this.closeChannel(this._activeChannel);
        this._activeChannel = this.createChannel(sourceEndpointDetails, sourceConnection, handshakeRequest, groupHistory);
        return this._activeChannel;
    }
}

