/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleController;
import com.gigaspaces.time.SystemTime;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BacklogAdjustedThrottleController
implements IReplicationThrottleController {
    private final int _defaultOperationPer1milisWhenInactive;
    private final int _minOperationPer1milisWhenActive;
    private final int _threshold;
    private final int _sampleRate;
    private final int _finalStageLength;
    private final Logger _specificLogger;
    private long _lastBacklogTimeStamp = -1L;
    private long _lastBacklogSize = -1L;
    private float _addaptiveTPPer1milis;
    private long _operations;
    private int _sampleIteration;
    private boolean _atFinalStage;
    private int _calibratedOperationsPer1milis;
    private final boolean _throttleWhenInactive;

    public BacklogAdjustedThrottleController(int maxTPWhenInactive, int minTPWhenActive, int threshold, int sampleRate, int finalStageLength, String groupName, String sourceMemberName, String targetMemberName, boolean throttleWhenInactive) {
        this._throttleWhenInactive = throttleWhenInactive;
        this._defaultOperationPer1milisWhenInactive = maxTPWhenInactive / 1000;
        this._minOperationPer1milisWhenActive = minTPWhenActive / 1000;
        this._threshold = threshold;
        this._sampleRate = sampleRate;
        this._finalStageLength = finalStageLength;
        this._addaptiveTPPer1milis = this._defaultOperationPer1milisWhenInactive;
        this._calibratedOperationsPer1milis = this._defaultOperationPer1milisWhenInactive;
        this._specificLogger = ReplicationLogUtils.createChannelSpecificLogger(sourceMemberName, targetMemberName, groupName);
    }

    @Override
    public synchronized boolean throttle(long backlogSize, int contextSize, boolean channelActive) {
        float throttleRatePer1ms;
        if (!channelActive && !this._throttleWhenInactive) {
            return true;
        }
        this._operations += (long)contextSize;
        if (channelActive) {
            if (backlogSize == 0L || backlogSize < (long)this._threshold) {
                if (this._specificLogger.isLoggable(Level.FINE)) {
                    this._specificLogger.fine("backlog size [" + backlogSize + "] is below the threshold [" + this._threshold + "], throttling ended");
                }
                return false;
            }
            if (this._lastBacklogTimeStamp == -1L) {
                this._lastBacklogTimeStamp = SystemTime.timeMillis();
                this._lastBacklogSize = backlogSize;
                return true;
            }
            long currentTimeStamp = SystemTime.timeMillis();
            long interval = currentTimeStamp - this._lastBacklogTimeStamp;
            if (interval >= (long)this._sampleRate) {
                if (!this._atFinalStage && backlogSize < (long)this._minOperationPer1milisWhenActive * 1000L * (long)this._finalStageLength) {
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.finer("Entering final stage, no throttling up allowed");
                    }
                    this._atFinalStage = true;
                }
                long backlogSizeDifference = backlogSize - this._lastBacklogSize;
                this._lastBacklogTimeStamp = currentTimeStamp;
                this._lastBacklogSize = backlogSize;
                float backlogGrowthRatePerSecond = (float)backlogSizeDifference / (float)interval * 1000.0f;
                float backlogProprotionalGrowthPerSecond = backlogGrowthRatePerSecond / (float)this._lastBacklogSize;
                float minReductionRateRequired = -0.01f;
                if (backlogProprotionalGrowthPerSecond > 0.0f && this._addaptiveTPPer1milis <= (float)this._minOperationPer1milisWhenActive) {
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.finer("Throttling does not keep up with backlog increase rate, throttling down to 1000 operations per second");
                    }
                    float f = 1.0f;
                }
                if (backlogProprotionalGrowthPerSecond > -0.01f) {
                    if (this._addaptiveTPPer1milis > (float)this._minOperationPer1milisWhenActive) {
                        float reduceFactor = 0.98f + (-0.01f - backlogProprotionalGrowthPerSecond) / 2.0f;
                        this._addaptiveTPPer1milis = Math.max((float)this._minOperationPer1milisWhenActive, this._addaptiveTPPer1milis * reduceFactor);
                        if (this._specificLogger.isLoggable(Level.FINEST)) {
                            this._specificLogger.finest("Throttling down to " + NumberFormat.getPercentInstance().format(reduceFactor));
                        }
                    }
                } else if (!this._atFinalStage && (double)backlogProprotionalGrowthPerSecond <= -0.1 && this._addaptiveTPPer1milis < (float)this._calibratedOperationsPer1milis) {
                    float throttleUpFactor = 1.02f;
                    this._addaptiveTPPer1milis = Math.min((float)this._calibratedOperationsPer1milis, this._addaptiveTPPer1milis * throttleUpFactor);
                    if (this._specificLogger.isLoggable(Level.FINEST)) {
                        this._specificLogger.finest("Throttling up to " + NumberFormat.getPercentInstance().format(throttleUpFactor));
                    }
                }
            }
            throttleRatePer1ms = this._addaptiveTPPer1milis;
        } else {
            throttleRatePer1ms = this._calibratedOperationsPer1milis;
        }
        if ((float)this._operations > throttleRatePer1ms) {
            this._sampleIteration = (int)((long)this._sampleIteration + this._operations);
            if (this._sampleIteration > this._minOperationPer1milisWhenActive * 1000 * 5 && this._specificLogger.isLoggable(Level.FINER)) {
                this._sampleIteration = 0;
                this._specificLogger.finer("Throttling, [throttle rate = " + throttleRatePer1ms * 1000.0f + " ops/per second, backlog size = " + backlogSize + ", channel active = " + channelActive + "]");
            }
            long sleepRate = (long)Math.max(1.0, Math.ceil((float)contextSize / throttleRatePer1ms));
            this._operations = (long)((float)this._operations - (float)sleepRate * throttleRatePer1ms);
            try {
                Thread.sleep(sleepRate);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    @Override
    public void suggestThroughPut(int throughPut) {
        if (throughPut == 0) {
            this._calibratedOperationsPer1milis = this._defaultOperationPer1milisWhenInactive;
        } else {
            int throughPutPer1Milis = throughPut / 1000;
            if (throughPutPer1Milis > this._defaultOperationPer1milisWhenInactive) {
                this._calibratedOperationsPer1milis = Math.max(throughPutPer1Milis, this._defaultOperationPer1milisWhenInactive);
            }
        }
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("calibrated throttle throughput to " + this._calibratedOperationsPer1milis * 1000);
        }
    }
}

