/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleController;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleControllerBuilder;

@InternalApi
public class ConstantReplicationThrottleController
implements IReplicationThrottleController,
IReplicationThrottleControllerBuilder {
    private final int _threshold;
    private final long _throttleDelay;

    public ConstantReplicationThrottleController(int threshold, long throttleDelay) {
        this._threshold = threshold;
        this._throttleDelay = throttleDelay;
    }

    @Override
    public boolean throttle(long backlogSize, int contextSize, boolean channelActive) {
        if (backlogSize < (long)this._threshold) {
            return false;
        }
        try {
            Thread.sleep(this._throttleDelay);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public IReplicationThrottleController createController(String groupName, String sourceMemberName, String targetMemberName) {
        return this;
    }

    @Override
    public void suggestThroughPut(int throughPut) {
    }
}

