/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.ISyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.utils.Textualizer;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class SyncReplicationGroupOutContext
extends ReplicationGroupOutContext
implements ISyncReplicationGroupOutContext {
    private List<IReplicationOrderedPacket> _orderedPackets;
    private IReplicationOrderedPacket _singlePacket;
    private long _weight = 0L;

    public SyncReplicationGroupOutContext(String name) {
        super(name);
    }

    @Override
    public void addOrderedPacket(IReplicationOrderedPacket packet) {
        if (this._singlePacket == null) {
            this._singlePacket = packet;
        } else if (this._orderedPackets != null) {
            this._orderedPackets.add(packet);
        } else {
            this._orderedPackets = new LinkedList<IReplicationOrderedPacket>();
            this._orderedPackets.add(this._singlePacket);
            this._orderedPackets.add(packet);
        }
        this._weight += (long)packet.getWeight();
        super.afterAddingOrderedPacket(packet);
    }

    @Override
    public List<IReplicationOrderedPacket> getOrderedPackets() {
        if (this.isSinglePacket()) {
            throw new IllegalStateException();
        }
        return this._orderedPackets;
    }

    @Override
    public boolean isSinglePacket() {
        return !this.isEmpty() && this._orderedPackets == null;
    }

    @Override
    public boolean isEmpty() {
        return this._singlePacket == null && this._orderedPackets == null;
    }

    @Override
    public IReplicationOrderedPacket getSinglePacket() {
        if (this._orderedPackets != null) {
            throw new IllegalStateException();
        }
        return this._singlePacket;
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.isSinglePacket() ? 1 : this._orderedPackets.size();
    }

    @Override
    public void clear() {
        this._singlePacket = null;
        this._orderedPackets = null;
        this._weight = 0L;
    }

    @Override
    public long getWeight() {
        return this._weight;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        if (this.isSinglePacket()) {
            textualizer.append("packet", this._singlePacket);
        } else {
            textualizer.append("packets", this._orderedPackets);
        }
        textualizer.append("weight", this._weight);
    }
}

