/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ReplicationException;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.CompletedFuture;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleController;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.ISyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReplicationConsumeTimeoutException;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.kernel.JSpaceUtilities;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@InternalApi
public class SyncReplicationSourceChannel
extends AbstractReplicationSourceChannel {
    private final IReplicationGroupBacklog _groupBacklog;
    private final IReplicationThrottleController _throttleController;
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final long _idleDelayMilis;
    private volatile boolean _syncState;
    private final int _asyncStateBatchSize;
    private final AsyncDispatcher _asyncDispatcher;
    private final IAsyncHandler _asyncHandler;
    private final Object _operatingModeLock = new Object();
    private IMarker _asyncMinimalCompletionMarker;
    private IMarker _beginOfSyncStateMarker;
    private volatile Throwable _unresolvedError;

    public SyncReplicationSourceChannel(DynamicSourceGroupConfigHolder groupConfig, String groupName, String memberName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationGroupBacklog groupBacklog, IReplicationOutFilter outFilter, IReplicationThrottleController throttleController, IAsyncHandlerProvider asyncHandlerProvider, int asyncStateBatchSize, long idleDelayMilis, IReplicationChannelDataFilter dataFilter, IReplicationSourceGroupStateListener stateListener, IReplicationGroupHistory groupHistory, ReplicationStatistics.ReplicationMode channelType, Object customBacklogMetadata) {
        super(groupConfig, groupName, memberName, replicationRouter, connection, groupBacklog, outFilter, asyncHandlerProvider, dataFilter, stateListener, groupHistory, channelType, customBacklogMetadata);
        this._groupBacklog = groupBacklog;
        this._throttleController = throttleController;
        this._asyncHandlerProvider = asyncHandlerProvider;
        this._asyncStateBatchSize = asyncStateBatchSize;
        this._idleDelayMilis = idleDelayMilis;
        this._syncState = true;
        this.start();
        this._asyncDispatcher = new AsyncDispatcher();
        this._asyncHandler = this._asyncHandlerProvider.start(this._asyncDispatcher, this._idleDelayMilis, "SyncChannelAsyncState-" + this.getMyLookupName() + "." + this.getGroupName() + "." + this.getMemberName(), false);
    }

    public Future<?> executeAsync(ISyncReplicationGroupOutContext context) {
        if (!this._syncState && this.delegateToAsyncRunner(context.size())) {
            return CompletedFuture.INSTANCE;
        }
        try {
            if (context.isSinglePacket()) {
                IReplicationOrderedPacket packet = context.getSinglePacket();
                return this.replicateAsync(packet);
            }
            List<IReplicationOrderedPacket> packets = context.getOrderedPackets();
            return this.replicateAsync(packets);
        }
        catch (RemoteException e) {
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.log(Level.FINE, "Caught remote exception during synchronous execution", e);
            }
            this.moveToAsyncIfNeeded();
            return CompletedFuture.INSTANCE;
        }
        catch (RuntimeException unexpectedException) {
            if (this._specificLogger.isLoggable(Level.SEVERE)) {
                this._specificLogger.log(Level.SEVERE, "Error in replication while replicating [" + ReplicationLogUtils.packetsToLogString(context) + "], the replication will be resent until the error is resolved", unexpectedException);
            }
            this.moveToAsyncIfNeeded();
            throw unexpectedException;
        }
        catch (Error unexpectedError) {
            if (this._specificLogger.isLoggable(Level.SEVERE)) {
                this._specificLogger.log(Level.SEVERE, "Error in replication while replicating [" + ReplicationLogUtils.packetsToLogString(context) + "], the replication will be resent until the error is resolved", unexpectedError);
            }
            this.moveToAsyncIfNeeded();
            throw unexpectedError;
        }
    }

    @Override
    protected void onAsyncReplicateErrorResult(Throwable t, IReplicationOrderedPacket packet) {
        this.moveToAsyncIfNeeded();
        if (t instanceof RemoteException) {
            return;
        }
        if (this._specificLogger.isLoggable(Level.SEVERE)) {
            this._specificLogger.log(Level.SEVERE, "Error in replication while replicating [" + packet + "]", t);
        }
    }

    @Override
    protected void onAsyncReplicateErrorResult(Throwable t, List<IReplicationOrderedPacket> packets) {
        this.moveToAsyncIfNeeded();
        if (t instanceof RemoteException) {
            return;
        }
        if (this._specificLogger.isLoggable(Level.SEVERE)) {
            this._specificLogger.log(Level.SEVERE, "Error in replication while replication [" + packets + "]", t);
        }
    }

    public int execute(ISyncReplicationGroupOutContext context) {
        if (!this._syncState && this.delegateToAsyncRunner(context.size())) {
            return 0;
        }
        try {
            if (context.isSinglePacket()) {
                IReplicationOrderedPacket packet = context.getSinglePacket();
                return this.replicate(packet);
            }
            List<IReplicationOrderedPacket> packets = context.getOrderedPackets();
            return this.replicateBatch(packets);
        }
        catch (RemoteException e) {
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.log(Level.FINE, "Caught remote exception during synchronous execution", e);
            }
            this.moveToAsyncIfNeeded();
        }
        catch (RuntimeException unexpectedException) {
            if (this._specificLogger.isLoggable(Level.SEVERE)) {
                this._specificLogger.log(Level.SEVERE, "Error in replication while replicating [" + ReplicationLogUtils.packetsToLogString(context) + "]", unexpectedException);
            }
            this.moveToAsyncIfNeeded(unexpectedException);
        }
        catch (Error unexpectedError) {
            if (this._specificLogger.isLoggable(Level.SEVERE)) {
                this._specificLogger.log(Level.SEVERE, "Error in replication while replicating [" + ReplicationLogUtils.packetsToLogString(context) + "]", unexpectedError);
            }
            this.moveToAsyncIfNeeded(unexpectedError);
            throw unexpectedError;
        }
        catch (ReplicationException e) {
            Level logLevel = this.getExceptionLogLevel(JSpaceUtilities.getRootCauseException(e));
            if (this._specificLogger.isLoggable(logLevel)) {
                this._specificLogger.log(logLevel, "Error in replication while replicating [" + ReplicationLogUtils.packetsToLogString(context) + "]", e);
            }
            this.moveToAsyncIfNeeded(e.getCause());
        }
        return 0;
    }

    private Level getExceptionLogLevel(Throwable rootCauseException) {
        if (rootCauseException instanceof ReplicationConsumeTimeoutException) {
            return Level.WARNING;
        }
        return Level.SEVERE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delegateToAsyncRunner(int contextSize) {
        boolean throttleAsChannelActive = this.isActive() && this.hasReachedAsyncMinimalCompletionMarker();
        boolean keepThrottling = this._throttleController.throttle(this._groupBacklog.size(this.getMemberName()), contextSize, throttleAsChannelActive);
        if (!keepThrottling) {
            return !this.moveToSyncIfNeeded(true);
        }
        Object object = this._operatingModeLock;
        synchronized (object) {
            return !this._syncState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveToSyncIfNeeded(boolean fromSyncCaller) {
        Object object = this._operatingModeLock;
        synchronized (object) {
            if (this.isActive() && !this._syncState && (this._asyncMinimalCompletionMarker == null || this._asyncMinimalCompletionMarker.isMarkerReached())) {
                if (fromSyncCaller) {
                    IMarker currentMarker = this._groupBacklog.getCurrentMarker(this.getMemberName());
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.finer("moved to sync state from backlog marked position " + currentMarker);
                    }
                    this._beginOfSyncStateMarker = currentMarker;
                } else if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("restored sync state");
                }
                if (this._unresolvedError != null) {
                    String msg = "pending error [" + this._unresolvedError.getMessage() + "] was resolved, channel synchronous mode is restored";
                    this.logEventInHistory(msg);
                    if (this._specificLogger.isLoggable(Level.INFO)) {
                        this._specificLogger.info(msg);
                    }
                } else {
                    this.logEventInHistory("restored sync state");
                }
                this._asyncMinimalCompletionMarker = null;
                this._unresolvedError = null;
                this._syncState = true;
            }
            return this._syncState;
        }
    }

    private boolean moveToAsyncIfNeeded() {
        return this.moveToAsyncIfNeeded(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveToAsyncIfNeeded(Throwable error) {
        Object object = this._operatingModeLock;
        synchronized (object) {
            if (this._syncState && !this.isClosed()) {
                int sampleTPBefore = this.getSampleTPBefore(10L, TimeUnit.SECONDS);
                IMarker currentMarker = this.getGroupBacklog().getCurrentMarker(this.getMemberName());
                String msg = "moving to async state (measured TP before state change " + sampleTPBefore + ") minimal async completion marked position " + currentMarker;
                this.logEventInHistory(msg);
                if (this._specificLogger.isLoggable(Level.FINE)) {
                    this._specificLogger.fine(msg);
                }
                this._throttleController.suggestThroughPut(sampleTPBefore);
                this._asyncMinimalCompletionMarker = currentMarker;
                this._unresolvedError = error;
                this._beginOfSyncStateMarker = null;
                this._syncState = false;
                if (error != null) {
                    msg = "channel changed to asynchronous mode until it will resolve the error [" + error.getMessage() + "]";
                    this.logEventInHistory(msg);
                    if (this._specificLogger.isLoggable(Level.INFO)) {
                        this._specificLogger.info(msg);
                    }
                }
            }
            return !this._syncState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasReachedAsyncMinimalCompletionMarker() {
        IMarker asyncMinimalCompletionMarker = this._asyncMinimalCompletionMarker;
        if (asyncMinimalCompletionMarker == null) {
            return true;
        }
        if (asyncMinimalCompletionMarker.isMarkerReached()) {
            Object object = this._operatingModeLock;
            synchronized (object) {
                if (asyncMinimalCompletionMarker == this._asyncMinimalCompletionMarker) {
                    this._asyncMinimalCompletionMarker = null;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void onActiveImpl() {
        if (this.getGroupBacklog().size(this.getMemberName()) > 0L) {
            this.moveToAsyncIfNeeded();
        }
        if (this._asyncHandler != null) {
            this._asyncHandler.wakeUp();
        }
    }

    @Override
    protected void onDisconnectedImpl() {
        this.moveToAsyncIfNeeded();
    }

    @Override
    protected void closeImpl() {
        if (this._asyncHandler != null) {
            this._asyncHandler.stop(3L, TimeUnit.SECONDS);
        }
    }

    public boolean isSync() {
        return this._syncState;
    }

    private List<IReplicationOrderedPacket> getPendingPackets() {
        return super.getPendingPackets(this._asyncStateBatchSize);
    }

    @Override
    public void flushPendingReplication() {
        if (this._asyncHandler != null) {
            this._asyncHandler.wakeUp();
        }
    }

    @Override
    public ReplicationStatistics.ReplicationOperatingMode getChannelOpertingMode() {
        if (this._syncState) {
            return ReplicationStatistics.ReplicationOperatingMode.SYNC;
        }
        return ReplicationStatistics.ReplicationOperatingMode.ASYNC;
    }

    @Override
    public String onDumpState() {
        return StringUtils.NEW_LINE + "mode [" + (this.isSync() ? "SYNC]" : "ASYNC]");
    }

    public class AsyncDispatcher
    extends AsyncCallable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsyncHandlerProvider.CycleResult call() {
            Object currentMarker;
            if (!SyncReplicationSourceChannel.this.isActive()) {
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
            IBacklogMemberState state = SyncReplicationSourceChannel.this.getGroupBacklog().getState(SyncReplicationSourceChannel.this.getMemberName());
            if (state.isBacklogDropped()) {
                return this.handleBacklogDroppedState(state);
            }
            Object object = SyncReplicationSourceChannel.this._operatingModeLock;
            synchronized (object) {
                currentMarker = SyncReplicationSourceChannel.this._beginOfSyncStateMarker;
                if (currentMarker == null && SyncReplicationSourceChannel.this.isSync()) {
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
                if (currentMarker != null && currentMarker.isMarkerReached()) {
                    if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                        SyncReplicationSourceChannel.this._specificLogger.finer("async state handler reached its end marker [" + currentMarker + "]");
                    }
                    if (SyncReplicationSourceChannel.this.isSynchronizing()) {
                        try {
                            SyncReplicationSourceChannel.this.signalSynchronizingDone();
                            SyncReplicationSourceChannel.this._beginOfSyncStateMarker = null;
                        }
                        catch (RemoteException e) {
                            if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                                SyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "AsyncDispatcher error while signaling synchronization is done.", e);
                            }
                        }
                    } else {
                        SyncReplicationSourceChannel.this._beginOfSyncStateMarker = null;
                    }
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
            }
            List packets = SyncReplicationSourceChannel.this.getPendingPackets();
            if (packets.isEmpty()) {
                currentMarker = SyncReplicationSourceChannel.this._operatingModeLock;
                synchronized (currentMarker) {
                    packets = SyncReplicationSourceChannel.this.getPendingPackets();
                    if (packets.isEmpty()) {
                        return this.moveToSyncStateUponEmptyBacklog(state);
                    }
                }
            }
            try {
                SyncReplicationSourceChannel.this.replicateBatchDelayed(packets);
                if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINEST)) {
                    SyncReplicationSourceChannel.this._specificLogger.finest("async state handler replicated " + packets.size() + " packets");
                }
                return IAsyncHandlerProvider.CycleResult.CONTINUE;
            }
            catch (RemoteException e) {
                if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                    SyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "AsyncDispatcher cycle error.", e);
                }
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
            catch (Throwable t) {
                if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                    SyncReplicationSourceChannel.this._specificLogger.log(Level.FINER, "AsyncDispatcher cycle error while replicating " + packets + "." + StringUtils.NEW_LINE + SyncReplicationSourceChannel.this.getGroupBacklog().toLogMessage(SyncReplicationSourceChannel.this.getMemberName()), JSpaceUtilities.getRootCauseException(t));
                }
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
        }

        private IAsyncHandlerProvider.CycleResult moveToSyncStateUponEmptyBacklog(IBacklogMemberState state) {
            if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINER)) {
                SyncReplicationSourceChannel.this._specificLogger.finer("async state handler reached end of backlog, backlog state " + state.toLogMessage());
            }
            SyncReplicationSourceChannel.this.moveToSyncIfNeeded(false);
            if (SyncReplicationSourceChannel.this.isSynchronizing()) {
                try {
                    SyncReplicationSourceChannel.this.signalSynchronizingDone();
                }
                catch (RemoteException e) {
                    if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                        SyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "AsyncDispatcher error while signaling synchronization is done.", e);
                    }
                    SyncReplicationSourceChannel.this.moveToAsyncIfNeeded();
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
            }
            return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
        }

        private IAsyncHandlerProvider.CycleResult handleBacklogDroppedState(IBacklogMemberState state) {
            block4: {
                try {
                    SyncReplicationSourceChannel.this.dispatchBacklogDropped(state);
                }
                catch (RemoteException e) {
                    if (SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.FINE)) {
                        SyncReplicationSourceChannel.this._specificLogger.log(Level.FINE, "Caught remote exception while asynchronous dispatcher notifies target of backlog dropped", e);
                    }
                }
                catch (Throwable t) {
                    if (!SyncReplicationSourceChannel.this._specificLogger.isLoggable(Level.SEVERE)) break block4;
                    SyncReplicationSourceChannel.this._specificLogger.log(Level.SEVERE, "Error in replication when attempting notify target of backlog dropped", t);
                }
            }
            return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
        }
    }
}

