/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IReplicationSyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleControllerBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.ISyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationSourceChannel;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class SyncReplicationSourceGroup
extends AbstractReplicationSourceGroup<SourceGroupConfig>
implements IReplicationSourceGroup {
    private final IReplicationSyncGroupBacklog _groupBacklog;
    private final Map<String, SyncReplicationSourceChannel> _channelsMap;
    private final SyncReplicationSourceChannel[] _channels;
    private final IReplicationThrottleControllerBuilder _throttleControllerBuilder;
    private final int _asyncStateBatchSize;
    private final long _idleDelayMilis;
    private final boolean _singleTarget;
    private final SyncReplicationSourceChannel _singleTargetChannel;
    private final ReplicationStatistics.ReplicationMode _channelType;

    public SyncReplicationSourceGroup(DynamicSourceGroupConfigHolder groupConfig, IReplicationRouter replicationRouter, IReplicationOutFilter outFilter, IReplicationThrottleControllerBuilder throttleControllerBuilder, IAsyncHandlerProvider asyncStateHandlerProvider, int asyncStateBatchSize, long idleDelayMilis, IReplicationSyncGroupBacklog groupBacklog, String myLookupName, IReplicationSourceGroupStateListener stateListener, ReplicationStatistics.ReplicationMode channelType) {
        super(groupConfig, replicationRouter, groupBacklog, myLookupName, outFilter, asyncStateHandlerProvider, stateListener);
        this._throttleControllerBuilder = throttleControllerBuilder;
        this._asyncStateBatchSize = asyncStateBatchSize;
        this._idleDelayMilis = idleDelayMilis;
        this._channelType = channelType;
        this._channelsMap = new HashMap<String, SyncReplicationSourceChannel>();
        this._groupBacklog = groupBacklog;
        this.createReplicationChannels();
        this._channels = this.prepareChannelsArray();
        this._singleTarget = this._channelsMap.size() == 1;
        this._singleTargetChannel = this._singleTarget ? this._channelsMap.values().iterator().next() : null;
    }

    private SyncReplicationSourceChannel[] prepareChannelsArray() {
        SyncReplicationSourceChannel[] result = new SyncReplicationSourceChannel[this._channelsMap.size()];
        int index = 0;
        Collection<SyncReplicationSourceChannel> values = this._channelsMap.values();
        for (SyncReplicationSourceChannel sourceChannel : values) {
            result[index++] = sourceChannel;
        }
        return result;
    }

    @Override
    public void beforeExecute(ReplicationOutContext replicationContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        ISyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.add(groupContext, entryHolder, operationType);
    }

    @Override
    public void beforeTransactionExecute(ReplicationOutContext replicationContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        ISyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.addTransaction(groupContext, transaction, lockedEntries, operationType);
    }

    @Override
    public void beforeExecuteGeneric(ReplicationOutContext replicationContext, Object operationData, ReplicationSingleOperationType operationType) {
        ISyncReplicationGroupOutContext groupContext = this.getGroupContext(replicationContext);
        this._groupBacklog.addGeneric(groupContext, operationData, operationType);
    }

    @Override
    public int executeImpl(IReplicationGroupOutContext groupContext) {
        int i;
        if (groupContext.isEmpty()) {
            return 0;
        }
        ISyncReplicationGroupOutContext syncGroupContext = (ISyncReplicationGroupOutContext)groupContext;
        int res = 0;
        if (this.isSingleTarget()) {
            return this._singleTargetChannel.execute(syncGroupContext);
        }
        Future[] _futures = new Future[this._channels.length];
        for (i = 0; i < this._channels.length; ++i) {
            _futures[i] = this._channels[i].executeAsync(syncGroupContext);
        }
        for (i = 0; i < _futures.length; ++i) {
            try {
                _futures[i].get();
                ++res;
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (!(cause instanceof Error)) continue;
                throw (Error)cause;
            }
        }
        return res;
    }

    private ISyncReplicationGroupOutContext getGroupContext(ReplicationOutContext replicationContext) {
        ISyncReplicationGroupOutContext groupContext = (ISyncReplicationGroupOutContext)replicationContext.getGroupContext(this.getGroupName());
        if (groupContext == null) {
            groupContext = new SyncReplicationGroupOutContext(this.getGroupName());
            replicationContext.setGroupContext(groupContext);
        }
        return groupContext;
    }

    @Override
    protected AbstractReplicationSourceChannel createChannel(String memberLookupName, IReplicationRouter replicationRouter, IReplicationMonitoredConnection connection, IReplicationChannelDataFilter dataFilter, IReplicationGroupHistory groupHistory, boolean dynamicMember, SourceGroupConfig groupConfig, Object customBacklogMetadata) {
        if (dynamicMember) {
            throw new UnsupportedOperationException("Cannot add dynamically a synchronous channel");
        }
        SyncReplicationSourceChannel channel = new SyncReplicationSourceChannel(this.getConfigHolder(), this.getGroupName(), memberLookupName, replicationRouter, connection, this._groupBacklog, this.getOutFilter(), this._throttleControllerBuilder.createController(this.getGroupName(), this.getMyLookupName(), memberLookupName), this.getAsyncHandlerProvider(), this._asyncStateBatchSize, this._idleDelayMilis, dataFilter, this.getStateListener(), groupHistory, this._channelType, customBacklogMetadata);
        this._channelsMap.put(memberLookupName, channel);
        return channel;
    }

    @Override
    protected void onCloseTemporaryChannel(String sourceMemberName, AbstractReplicationSourceChannel channel) {
        this._channelsMap.remove(sourceMemberName);
        for (int i = 0; i < this._channels.length; ++i) {
            if (this._channels[i] != channel) continue;
            this._channels[i] = null;
        }
    }

    @Override
    protected AbstractReplicationSourceChannel getChannel(String memberLookupName) {
        return super.getChannel(memberLookupName);
    }

    public boolean isSingleTarget() {
        return this._singleTarget;
    }
}

