/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.groups.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IReplicationSyncBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IReplicationSyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.AbstractReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleControllerBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.j_spaces.core.filters.ReplicationStatistics;

@InternalApi
public class SyncReplicationSourceGroupBuilder
extends AbstractReplicationSourceGroupBuilder<SourceGroupConfig> {
    private IAsyncHandlerProvider _asyncHandlerProvider;
    private int _asyncStateBatchSize;
    private IReplicationSyncBacklogBuilder _backlogBuilder;
    private long _asyncStateIdleDelayMilis;
    private IReplicationThrottleControllerBuilder _throttleControllerBuilder;
    private ReplicationStatistics.ReplicationMode _channelType;

    public SyncReplicationSourceGroupBuilder(DynamicSourceGroupConfigHolder groupConfig) {
        super(groupConfig);
    }

    public void setBacklogBuilder(IReplicationSyncBacklogBuilder backlogBuilder) {
        this._backlogBuilder = backlogBuilder;
    }

    public void setChannelType(ReplicationStatistics.ReplicationMode channelType) {
        this._channelType = channelType;
    }

    public void setThrottleController(IReplicationThrottleControllerBuilder throttleControllerBuilder) {
        this._throttleControllerBuilder = throttleControllerBuilder;
    }

    public void setAsyncHandlerProvider(IAsyncHandlerProvider asyncStateHandlerProvider) {
        this._asyncHandlerProvider = asyncStateHandlerProvider;
    }

    public void setAsyncStateBatchSize(int asyncStateBatchSize) {
        this._asyncStateBatchSize = asyncStateBatchSize;
    }

    public void setAsyncStateIdleDelay(long asyncStateIdleDelayMilis) {
        this._asyncStateIdleDelayMilis = asyncStateIdleDelayMilis;
    }

    @Override
    public IReplicationSourceGroup createGroupImpl(DynamicSourceGroupConfigHolder groupConfig, IReplicationRouter replicationRouter, IReplicationOutFilter outFilter, IReplicationSourceGroupStateListener stateListener) {
        IReplicationSyncGroupBacklog groupBacklog = this._backlogBuilder.createSyncGroupBacklog(groupConfig);
        return new SyncReplicationSourceGroup(groupConfig, replicationRouter, outFilter, this._throttleControllerBuilder, this._asyncHandlerProvider, this._asyncStateBatchSize, this._asyncStateIdleDelayMilis, groupBacklog, replicationRouter.getMyLookupName(), stateListener, this._channelType);
    }

    public String toString() {
        return "SyncReplicationSourceGroupBuilder [_groupConfig=" + this.getGroupConfig() + ", _asyncHandlerProvider=" + this._asyncHandlerProvider + ", _asyncStateBatchSize=" + this._asyncStateBatchSize + ", _backlogBuilder=" + this._backlogBuilder + ", _asyncStateIdleDelayMilis=" + this._asyncStateIdleDelayMilis + ", _throttleControllerBuilder=" + this._throttleControllerBuilder + "]";
    }
}

