/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.AbstractReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEvictEntryHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.ReplicationInExceptionHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.AnswerPacket;
import com.j_spaces.core.ExtendedAnswerHolder;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.cluster.ConflictingOperationPolicy;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Level;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public abstract class AbstractSpaceReplicationEntryEventHandler
extends AbstractReplicationEntryEventHandler
implements IReplicationInEvictEntryHandler {
    protected final SpaceEngine _engine;
    protected final ReplicationInExceptionHandler _exceptionHandler;

    public AbstractSpaceReplicationEntryEventHandler(SpaceEngine engine, ReplicationInExceptionHandler exceptionHandler) {
        this._engine = engine;
        this._exceptionHandler = exceptionHandler;
    }

    protected ConflictingOperationPolicy getConflictingOperationPolicy() {
        return this._engine.getConflictingOperationPolicy();
    }

    protected boolean ignoreOperation(boolean isTransient) {
        return this._engine.getCacheManager().isCacheExternalDB() && !isTransient && this._engine.getCacheManager().isCentralDB() && this._engine.getCacheManager().isEvictableCachePolicy() && !this._engine.hasMirror();
    }

    @Override
    public void writeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) throws Exception {
        this._engine.getTypeManager().loadServerTypeDesc(entry);
        long lease = entry.getTTL();
        if (this.ignoreOperation(entry.isTransient())) {
            return;
        }
        this.writeEntryIntoSpace(context, txn, entry, lease, twoPhaseCommit);
    }

    @Override
    public void updateEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry, IEntryPacket previousEntry, boolean partialUpdate, boolean overrideVersion) throws Exception {
        this._engine.getTypeManager().loadServerTypeDesc(entry);
        long lease = entry.getTTL();
        if (!this.shouldUpdateEntryInSpace(context, txn, twoPhaseCommit, entry)) {
            return;
        }
        this.updateEntryInSpace(context, txn, entry, previousEntry, partialUpdate, overrideVersion, lease, twoPhaseCommit);
    }

    @Override
    public void removeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) throws Exception {
        this._engine.getTypeManager().loadServerTypeDesc(entry);
        ITemplatePacket template = entry instanceof ITemplatePacket ? (ITemplatePacket)entry : TemplatePacketFactory.createFullPacket(entry);
        if (!this.shouldRemoveEntryFromSpace(entry.isTransient())) {
            return;
        }
        this.removeEntryFromSpace(context, txn, template, twoPhaseCommit);
    }

    @Override
    public void removeEntryByUid(IReplicationInContext context, Transaction transaction, boolean twoPhaseCommit, String uid, boolean isTransient, OperationID operationID) throws Exception {
        if (!this.shouldRemoveEntryFromSpace(isTransient)) {
            return;
        }
        ITemplatePacket entryPacket = TemplatePacketFactory.createUidPacket(uid, 0, false);
        entryPacket.setOperationID(operationID);
        this.removeEntryFromSpace(context, transaction, entryPacket, twoPhaseCommit);
    }

    @Override
    public void changeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, String typeName, String uid, Object id, int routingHash, int version, int previousVersion, long timeToLive, Collection<SpaceEntryMutator> mutators, boolean isTransient, OperationID operationID, IEntryData previousEntry) throws Exception {
        if (!this.shouldChangeEntryInSpace(context, txn, twoPhaseCommit, typeName, uid, isTransient, version)) {
            return;
        }
        this.changeEntryInSpace(context, txn, uid, version, mutators, isTransient, operationID, previousEntry, timeToLive, twoPhaseCommit);
    }

    protected void changeEntryInSpace(IReplicationInContext context, Transaction txn, String uid, int version, Collection<SpaceEntryMutator> mutators, boolean isTransient, OperationID operationID, IEntryData previousEntry, long timeToLive, boolean twoPhaseCommit) throws Exception {
        ITemplatePacket template = TemplatePacketFactory.createUidPacket(uid, version);
        int operationModifiers = 0;
        try {
            ExtendedAnswerHolder answerHolder = this.executeChangeOperation(context, txn, mutators, timeToLive, template, operationModifiers);
            IEntryData previousEntryData = answerHolder.getPreviousEntryData();
            IEntryData modifiedEntryData = answerHolder.getModifiedEntryData();
            if (modifiedEntryData == null) {
                IEntryData rejectedEntry = answerHolder.getRejectedEntry();
                Exception exception = answerHolder.getException();
                if (rejectedEntry == null) {
                    if (exception != null) {
                        throw exception;
                    }
                    this._exceptionHandler.handleEntryNotInSpaceOnChange(context.getContextLogger(), template);
                } else if (exception instanceof OperationTimeoutException) {
                    this._exceptionHandler.handleEntryLockedByTransactionOnChange(context.getContextLogger(), template);
                } else if (exception instanceof EntryVersionConflictException) {
                    this._exceptionHandler.handleEntryVersionConflictOnChange(context.getContextLogger(), template, (EntryVersionConflictException)((Object)exception));
                } else {
                    if (exception != null) {
                        throw exception;
                    }
                    throw new IllegalStateException("rejected entry upon change operation without any exception [" + template + "]");
                }
            }
            this.postChangeExecution(context, previousEntryData, modifiedEntryData);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ExtendedAnswerHolder executeChangeOperation(IReplicationInContext context, Transaction txn, Collection<SpaceEntryMutator> mutators, long timeToLive, ITemplatePacket template, int operationModifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        ExtendedAnswerHolder answerHolder = this._engine.change(template, txn, timeToLive, 0L, null, true, false, mutators, operationModifiers, false);
        IEntryData modifiedEntryData = answerHolder.getModifiedEntryData();
        if (modifiedEntryData == null) {
            Exception exception = answerHolder.getException();
            if (answerHolder.getRejectedEntry() != null && exception instanceof EntryVersionConflictException && this.getConflictingOperationPolicy().isOverride()) {
                this._exceptionHandler.handleEntryVersionConflictOnChange(context.getContextLogger(), template, (EntryVersionConflictException)((Object)exception), Level.INFO);
                template.setVersion(0);
                return this._engine.change(template, txn, timeToLive, 0L, null, true, false, mutators, operationModifiers, false);
            }
        }
        return answerHolder;
    }

    protected void postChangeExecution(IReplicationInContext context, IEntryData previousEntryData, IEntryData modifiedEntryData) {
    }

    @Override
    public void inEvictEntry(IReplicationInContext context, String uid, boolean isTransient, OperationID operationID) throws Exception {
        try {
            if (!this._engine.getCacheManager().isEvictableCachePolicy()) {
                return;
            }
            if (!this.shouldEvictEntryFromSpace(isTransient)) {
                return;
            }
            ITemplatePacket template = TemplatePacketFactory.createUidPacket(uid, 0, false);
            template.setOperationID(operationID);
            this._engine.read(template, null, 0L, false, true, null, false, true, false, 147456);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void writeEntryIntoSpace(IReplicationInContext context, Transaction txn, IEntryPacket entry, long lease, boolean twoPhaseCommit) throws Exception {
        try {
            if (this.getConflictingOperationPolicy().isOverride()) {
                this.updateOrWrite(context, txn, entry, lease, 0);
            } else {
                this._engine.write(entry, txn, lease, 0, true, false, null);
            }
        }
        catch (EntryAlreadyInSpaceException ex) {
            this._exceptionHandler.handleEntryAlreadyInSpaceOnWrite(context, entry);
        }
    }

    protected void updateEntryInSpace(IReplicationInContext context, Transaction txn, IEntryPacket entry, IEntryPacket previousEntry, boolean partialUpdate, boolean overrideVersion, long lease, boolean twoPhaseCommit) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        try {
            int updateModifiers = overrideVersion ? 524288 : 0;
            ExtendedAnswerHolder aHolder = this.executeUpdateOperation(context, txn, entry, previousEntry, partialUpdate, overrideVersion, lease, twoPhaseCommit, updateModifiers);
            IEntryData previousEntryData = aHolder != null ? aHolder.getPreviousEntryData() : null;
            IEntryData currentEntryData = aHolder != null ? aHolder.getModifiedEntryData() : null;
            this.postUpdateExecution(context, previousEntryData, currentEntryData);
            if (aHolder != null && aHolder.m_AnswerPacket != null && aHolder.m_AnswerPacket.m_EntryPacket == null && aHolder.m_AnswerPacket.m_leaseProxy == null) {
                this._exceptionHandler.handleEntryLockedByTransactionOnUpdate(context.getContextLogger(), entry);
            }
        }
        catch (EntryVersionConflictException ex) {
            this._exceptionHandler.handleEntryVersionConflictOnUpdate(context.getContextLogger(), entry, ex);
        }
        catch (EntryNotInSpaceException ex) {
            this._exceptionHandler.handleEntryNotInSpaceOnUpdate(context.getContextLogger(), entry, ex);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected ExtendedAnswerHolder executeUpdateOperation(IReplicationInContext context, Transaction txn, IEntryPacket entry, IEntryPacket previousEntry, boolean partialUpdate, boolean overrideVersion, long lease, boolean twoPhaseCommit, int updateModifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        if (partialUpdate) {
            return this._engine.update(entry, txn, lease, 0L, null, true, false, false, updateModifiers | 0x10);
        }
        return this.updateOrWrite(context, txn, entry, lease, updateModifiers);
    }

    protected void postUpdateExecution(IReplicationInContext context, IEntryData previousEntryData, IEntryData currentEntryData) {
    }

    protected void removeEntryFromSpace(IReplicationInContext context, Transaction txn, ITemplatePacket template, boolean twoPhaseCommit) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        try {
            AnswerHolder answerHolder;
            if (this.getConflictingOperationPolicy().isOverride()) {
                template.setVersion(0);
            }
            AnswerPacket aPacket = (answerHolder = this._engine.read(template, txn, 0L, true, true, null, false, true, false, 16384)) != null ? answerHolder.getAnswerPacket() : null;
            this.postRemoveExecution(context, aPacket);
            if (aPacket != null && aPacket.m_EntryPacket == null) {
                this._exceptionHandler.handleEntryLockedByTransactionOnTake(context.getContextLogger(), template);
            }
        }
        catch (EntryVersionConflictException ex) {
            this._exceptionHandler.handleEntryVersionConflictOnTake(context.getContextLogger(), template, ex);
        }
        catch (EntryNotInSpaceException ex) {
            if (this.getConflictingOperationPolicy().isOverride()) {
                return;
            }
            this._exceptionHandler.handleEntryNotInSpaceOnTake(context.getContextLogger(), template);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void postRemoveExecution(IReplicationInContext context, AnswerPacket aPacket) {
    }

    protected abstract ExtendedAnswerHolder updateOrWrite(IReplicationInContext var1, Transaction var2, IEntryPacket var3, long var4, int var6) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException;

    protected abstract boolean shouldUpdateEntryInSpace(IReplicationInContext var1, Transaction var2, boolean var3, IEntryPacket var4) throws Exception;

    protected abstract boolean shouldChangeEntryInSpace(IReplicationInContext var1, Transaction var2, boolean var3, String var4, String var5, boolean var6, int var7) throws Exception;

    protected abstract boolean shouldRemoveEntryFromSpace(boolean var1);

    protected abstract boolean shouldEvictEntryFromSpace(boolean var1);
}

