/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.handlers.AbstractSpaceReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.ReplicationInExceptionHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.j_spaces.core.ExtendedAnswerHolder;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.client.EntryVersionConflictException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ActiveActiveSpaceReplicationEntryEventHandler
extends AbstractSpaceReplicationEntryEventHandler {
    public ActiveActiveSpaceReplicationEntryEventHandler(SpaceEngine engine, boolean isCentralAndExternalDB) {
        super(engine, new ReplicationInExceptionHandler(engine.getFullSpaceName(), isCentralAndExternalDB));
    }

    @Override
    protected ExtendedAnswerHolder updateOrWrite(IReplicationInContext context, Transaction transaction, IEntryPacket entryPacket, long lease, int updateModifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        UpdateOrWriteContext ctx = new UpdateOrWriteContext(entryPacket, lease, 0L, transaction, null, updateModifiers | 0x1000, false, true, false);
        try {
            return this._engine.updateOrWrite(ctx, true, false, false);
        }
        catch (EntryVersionConflictException ex) {
            if (!this.getConflictingOperationPolicy().isOverride()) {
                throw ex;
            }
            this._exceptionHandler.handleEntryVersionConflictOnUpdate(context.getContextLogger(), entryPacket, ex, Level.INFO);
            entryPacket.setVersion(0);
            return this._engine.updateOrWrite(ctx, true, false, false);
        }
    }

    @Override
    protected boolean shouldUpdateEntryInSpace(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) throws Exception {
        if (this.ignoreOperation(entry.isTransient()) && !this._engine.getCacheManager().isVersionedExternalDB()) {
            ITemplatePacket templatePacket = TemplatePacketFactory.createFullPacket(entry);
            this.removeEntry(context, txn, twoPhaseCommit, templatePacket);
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldChangeEntryInSpace(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, String typeName, String uid, boolean isTransient, int version) throws Exception {
        if (this.ignoreOperation(isTransient) && !this._engine.getCacheManager().isVersionedExternalDB()) {
            ITemplatePacket templatePacket = TemplatePacketFactory.createUidPacket(uid, version);
            this.removeEntry(context, txn, twoPhaseCommit, templatePacket);
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldRemoveEntryFromSpace(boolean isTransient) {
        return true;
    }

    @Override
    protected boolean shouldEvictEntryFromSpace(boolean isTransient) {
        return true;
    }
}

