/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationBlobstoreBulkContext;
import com.gigaspaces.internal.cluster.node.impl.handlers.PrimaryBackupSpaceReplicationEntryEventHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.cache.blobStore.BlobStoreReplicationBulkConsumeHelper;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class BlobstorePrimaryBackupSpaceReplicationEntryEventHandler
extends PrimaryBackupSpaceReplicationEntryEventHandler {
    private static final String LOG_PREFIX = "[BlobstoreReplicationEntryHandler]";

    public BlobstorePrimaryBackupSpaceReplicationEntryEventHandler(SpaceEngine engine, boolean isCentralAndExternalDB) {
        super(engine, isCentralAndExternalDB);
    }

    @Override
    protected void writeEntryIntoSpace(IReplicationInContext context, Transaction txn, IEntryPacket entry, long lease, boolean twoPhaseCommit) throws Exception {
        this.handleBlobstoreReplicationBulkIfNeeded(context, false);
        super.writeEntryIntoSpace(context, txn, entry, lease, twoPhaseCommit);
    }

    @Override
    public void afterConsumption(IReplicationInContext context, boolean successful, long lastProcessedKey) {
        if (this._engine.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper() != null) {
            this._engine.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper().flushBulk(lastProcessedKey);
            this.logFlushAfterConsumption(context, successful, lastProcessedKey, Level.FINE);
        }
    }

    @Override
    public void beforeConsume(IReplicationInContext context) {
        ReplicationBlobstoreBulkContext replicationBlobstoreBulkContext = context.getReplicationBlobstoreBulkContext();
        BlobStoreReplicationBulkConsumeHelper blobStoreReplicationBulkConsumeHelper = this._engine.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper();
        if (blobStoreReplicationBulkConsumeHelper != null && replicationBlobstoreBulkContext != null && replicationBlobstoreBulkContext.getBlobStoreReplicationBulkConsumeHelper() == null) {
            replicationBlobstoreBulkContext.setBlobStoreReplicationBulkConsumeHelper(blobStoreReplicationBulkConsumeHelper);
        }
    }

    private void handleBlobstoreReplicationBulkIfNeeded(IReplicationInContext context, boolean take) {
        ReplicationBlobstoreBulkContext replicationBlobstoreBulkContext = context.getReplicationBlobstoreBulkContext();
        BlobStoreReplicationBulkConsumeHelper blobStoreReplicationBulkConsumeHelper = this._engine.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper();
        if (replicationBlobstoreBulkContext != null && blobStoreReplicationBulkConsumeHelper != null) {
            Level logLevel = Level.FINEST;
            if (replicationBlobstoreBulkContext.isPartOfBlobstoreBulk()) {
                if (!replicationBlobstoreBulkContext.shouldFlush()) {
                    this.logProcessingBulk(context, logLevel);
                    blobStoreReplicationBulkConsumeHelper.prepareForBulking(take);
                } else {
                    this.logNewBulkArrived(context, logLevel);
                    blobStoreReplicationBulkConsumeHelper.flushBulk(context.getLastProcessedKey());
                    blobStoreReplicationBulkConsumeHelper.prepareForBulking(take);
                }
            } else {
                this.logNonBulkEntryArrived(context, logLevel);
                blobStoreReplicationBulkConsumeHelper.flushBulk(context.getLastProcessedKey());
            }
        }
    }

    private void logNewBulkArrived(IReplicationInContext context, Level level) {
        Logger contextLogger = context.getContextLogger();
        int bulkId = context.getReplicationBlobstoreBulkContext().getBulkId();
        if (contextLogger != null && contextLogger.isLoggable(level)) {
            contextLogger.log(level, "[BlobstoreReplicationEntryHandler] an entry which is a part of a new blobstore bulk with id [" + bulkId + "] arrived, will flush the previous bulk, packetkey=" + context.getLastProcessedKey());
        }
    }

    private void logNonBulkEntryArrived(IReplicationInContext context, Level level) {
        Logger contextLogger = context.getContextLogger();
        if (contextLogger != null && contextLogger.isLoggable(level)) {
            contextLogger.log(level, "[BlobstoreReplicationEntryHandler] an entry which is not part of a blobstore bulk arrived, will flush the previous bulk, packetKey=" + context.getLastProcessedKey());
        }
    }

    private void logProcessingBulk(IReplicationInContext context, Level level) {
        Logger contextLogger = context.getContextLogger();
        int bulkId = context.getReplicationBlobstoreBulkContext().getBulkId();
        if (contextLogger != null && contextLogger.isLoggable(level)) {
            contextLogger.log(level, "[BlobstoreReplicationEntryHandler] processing replication blobstore bulk with id [" + bulkId + "], packetKey=" + context.getLastProcessedKey());
        }
    }

    private void logFlushAfterConsumption(IReplicationInContext context, boolean successful, long lastProcessedKey, Level level) {
        if (context.getContextLogger() != null && context.getContextLogger().isLoggable(level)) {
            int bulkId = 0;
            if (context.getReplicationBlobstoreBulkContext() != null) {
                bulkId = context.getReplicationBlobstoreBulkContext().getBulkId();
            }
            String bulkIdStr = Integer.toString(bulkId).equals("0") ? "none" : Integer.toString(bulkId);
            context.getContextLogger().log(level, "[BlobstoreReplicationEntryHandler] flushed the bulk [" + bulkIdStr + "] after consumption, successful? [" + successful + "], last flushed key=" + lastProcessedKey + ", thread=" + Thread.currentThread().getName());
        }
    }

    @Override
    protected void updateEntryInSpace(IReplicationInContext context, Transaction txn, IEntryPacket entry, IEntryPacket previousEntry, boolean partialUpdate, boolean overrideVersion, long lease, boolean twoPhaseCommit) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        this.handleBlobstoreReplicationBulkIfNeeded(context, false);
        super.updateEntryInSpace(context, txn, entry, previousEntry, partialUpdate, overrideVersion, lease, twoPhaseCommit);
    }

    @Override
    protected void changeEntryInSpace(IReplicationInContext context, Transaction txn, String uid, int version, Collection<SpaceEntryMutator> mutators, boolean isTransient, OperationID operationID, IEntryData previousEntry, long timeToLive, boolean twoPhaseCommit) throws Exception {
        this.handleBlobstoreReplicationBulkIfNeeded(context, false);
        super.changeEntryInSpace(context, txn, uid, version, mutators, isTransient, operationID, previousEntry, timeToLive, twoPhaseCommit);
    }

    @Override
    protected void removeEntryFromSpace(IReplicationInContext context, Transaction txn, ITemplatePacket template, boolean twoPhaseCommit) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        this.handleBlobstoreReplicationBulkIfNeeded(context, true);
        super.removeEntryFromSpace(context, txn, template, twoPhaseCommit);
    }
}

