/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.handlers.AbstractSpaceReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.PrimaryBackupReplicationInExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.view.EntryPacketServerEntryAdapter;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.AnswerPacket;
import com.j_spaces.core.ExtendedAnswerHolder;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.Modifiers;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Level;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class PrimaryBackupSpaceReplicationEntryEventHandler
extends AbstractSpaceReplicationEntryEventHandler {
    public PrimaryBackupSpaceReplicationEntryEventHandler(SpaceEngine engine, boolean isCentralAndExternalDB) {
        super(engine, new PrimaryBackupReplicationInExceptionHandler(engine.getFullSpaceName(), isCentralAndExternalDB));
    }

    @Override
    protected void writeEntryIntoSpace(IReplicationInContext context, Transaction txn, IEntryPacket entry, long lease, boolean twoPhaseCommit) throws Exception {
        this.protectEntryFromEvictionIfNeeded(context, entry.getUID(), twoPhaseCommit);
        super.writeEntryIntoSpace(context, txn, entry, lease, twoPhaseCommit);
    }

    @Override
    protected ExtendedAnswerHolder updateOrWrite(IReplicationInContext context, Transaction transaction, IEntryPacket entryPacket, long lease, int updateModifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        boolean applyOverrideVersion = !Modifiers.contains(updateModifiers, 524288) && this.getConflictingOperationPolicy().isOverride();
        int originalVersion = entryPacket.getVersion();
        UpdateOrWriteContext ctx = new UpdateOrWriteContext(entryPacket, lease, 0L, transaction, null, updateModifiers | 0x1000, false, true, false);
        try {
            return this._engine.updateOrWrite(ctx, true, false, false);
        }
        catch (EntryVersionConflictException ex) {
            if (applyOverrideVersion) {
                entryPacket.setVersion(originalVersion);
                this._exceptionHandler.handleEntryVersionConflictOnUpdate(context.getContextLogger(), entryPacket, ex, Level.INFO);
                ctx.operationModifiers = updateModifiers |= 0x80000;
            } else if (this.getConflictingOperationPolicy().isOverride()) {
                this._exceptionHandler.handleEntryVersionConflictOnUpdate(context.getContextLogger(), entryPacket, ex, Level.INFO);
                entryPacket.setVersion(0);
            } else {
                throw ex;
            }
            return this._engine.updateOrWrite(ctx, true, false, false);
        }
    }

    @Override
    protected boolean shouldUpdateEntryInSpace(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) {
        return !this.ignoreOperation(entry.isTransient());
    }

    @Override
    protected void updateEntryInSpace(IReplicationInContext context, Transaction txn, IEntryPacket entry, IEntryPacket previousEntry, boolean partialUpdate, boolean overrideVersion, long lease, boolean twoPhaseCommit) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        this.protectEntryFromEvictionIfNeeded(context, entry.getUID(), twoPhaseCommit);
        super.updateEntryInSpace(context, txn, entry, previousEntry, partialUpdate, overrideVersion, lease, twoPhaseCommit);
    }

    @Override
    protected void postUpdateExecution(IReplicationInContext context, IEntryData previousEntryData, IEntryData currentEntryData) {
        if (context.getContentContext() != null) {
            if (previousEntryData != null) {
                context.getContentContext().setSecondaryEntryData(previousEntryData);
            }
            if (currentEntryData != null) {
                context.getContentContext().setMainEntryData(currentEntryData);
            }
        }
    }

    @Override
    protected void changeEntryInSpace(IReplicationInContext context, Transaction txn, String uid, int version, Collection<SpaceEntryMutator> mutators, boolean isTransient, OperationID operationID, IEntryData previousEntry, long timeToLive, boolean twoPhaseCommit) throws Exception {
        this.protectEntryFromEvictionIfNeeded(context, uid, twoPhaseCommit);
        super.changeEntryInSpace(context, txn, uid, version, mutators, isTransient, operationID, previousEntry, timeToLive, twoPhaseCommit);
    }

    @Override
    protected void postChangeExecution(IReplicationInContext context, IEntryData previousEntryData, IEntryData modifiedEntryData) {
        if (context.getContentContext() != null) {
            if (previousEntryData != null) {
                context.getContentContext().setSecondaryEntryData(previousEntryData);
            }
            if (modifiedEntryData != null) {
                context.getContentContext().setMainEntryData(modifiedEntryData);
            }
        }
    }

    @Override
    protected boolean shouldChangeEntryInSpace(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, String typeName, String uid, boolean isTransient, int version) {
        return !this.ignoreOperation(isTransient);
    }

    @Override
    protected void removeEntryFromSpace(IReplicationInContext context, Transaction txn, ITemplatePacket template, boolean twoPhaseCommit) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        this.protectEntryFromEvictionIfNeeded(context, template.getUID(), twoPhaseCommit);
        super.removeEntryFromSpace(context, txn, template, twoPhaseCommit);
    }

    @Override
    protected void postRemoveExecution(IReplicationInContext context, AnswerPacket aPacket) {
        if (aPacket != null && aPacket.m_EntryPacket != null && context.getContentContext() != null) {
            context.getContentContext().setMainEntryData(new EntryPacketServerEntryAdapter(aPacket.m_EntryPacket));
        }
    }

    @Override
    protected boolean shouldRemoveEntryFromSpace(boolean isTransient) {
        return !this.ignoreOperation(isTransient);
    }

    @Override
    protected boolean shouldEvictEntryFromSpace(boolean isTransient) {
        return !this.ignoreOperation(isTransient);
    }

    private void protectEntryFromEvictionIfNeeded(IReplicationInContext context, String uid, boolean twoPhaseCommit) {
        if (!twoPhaseCommit && this._engine.getCacheManager().requiresEvictionReplicationProtection()) {
            IMarker marker = context.getContextMarker(this._engine.getCacheManager().getEvictionPolicyReplicationMembersGroupName());
            this._engine.getCacheManager().getEvictionReplicationsMarkersRepository().insert(uid, marker, false);
        }
    }
}

