/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationInExceptionHandler {
    private static final String WRITE = "Write";
    private static final String UPDATE = "Update";
    private static final String TAKE = "Take";
    private static final String CHANGE = "Change";
    protected String _spaceName;
    private final boolean _isCentralDB;

    public ReplicationInExceptionHandler(String spaceName, boolean isCentralDB) {
        this._spaceName = spaceName;
        this._isCentralDB = isCentralDB;
    }

    public void handleEntryLockedByTransactionOnTake(Logger logger, IEntryPacket entryPacket) {
        if (this._isCentralDB && !entryPacket.isTransient()) {
            return;
        }
        if (logger != null && logger.isLoggable(Level.SEVERE)) {
            this.logMessage(logger, TAKE, entryPacket.getTypeName(), entryPacket.getUID(), Level.SEVERE, "Entry is locked by another transaction.");
        }
    }

    public void handleEntryAlreadyInSpaceOnWrite(IReplicationInContext context, IEntryPacket entryPacket) {
        if (this._isCentralDB && !entryPacket.isTransient()) {
            return;
        }
        Level level = this.getDefaultExceptionLevel();
        if (context.getContextLogger() != null && context.getContextLogger().isLoggable(level)) {
            this.logMessage(context.getContextLogger(), WRITE, entryPacket.getTypeName(), entryPacket.getUID(), level, "Entry already in space");
        }
    }

    public void handleEntryNotInSpaceOnTake(Logger logger, IEntryPacket entryPacket) {
        Level logLevel = this.getDefaultExceptionLevel();
        if (logger != null && logger.isLoggable(logLevel) && (!this._isCentralDB || entryPacket.isTransient())) {
            this.logMessage(logger, TAKE, entryPacket.getTypeName(), entryPacket.getUID(), logLevel, "Entry not in space");
        } else if (logger != null && logger.isLoggable(Level.FINE)) {
            this.logMessage(logger, TAKE, entryPacket.getTypeName(), entryPacket.getUID(), Level.FINE, "Entry not in space");
        }
    }

    public void handleEntryVersionConflictOnTake(Logger logger, IEntryPacket entryPacket, EntryVersionConflictException ex) {
        Level logLevel = this.getDefaultExceptionLevel();
        if (logger != null && logger.isLoggable(logLevel)) {
            this.logMessage(logger, TAKE, entryPacket.getTypeName(), entryPacket.getUID(), logLevel, "Version conflict - in space entry version is <" + ex.getSpaceVersionID() + ">, replicated version <" + ex.getClientVersionID() + ">.");
        }
    }

    public void handleNoClassNameOnTake(Logger logger, String uid) {
        if (logger != null && logger.isLoggable(Level.SEVERE)) {
            logger.severe("Replication detected illegal Take operation on entry  uid=<" + uid + ">\n  Symptom: Entry class name wasn't replicated.\n  Ignoring the illegal operation \n  Please make sure that property <" + "cluster-config" + "." + "cache-loader" + "." + "external-data-source" + "> is set to 'true'.");
        }
    }

    public void handleEntryLockedByTransactionOnUpdate(Logger logger, IEntryPacket entryPacket) {
        if (this._isCentralDB && !entryPacket.isTransient()) {
            return;
        }
        if (logger != null && logger.isLoggable(Level.SEVERE)) {
            this.logMessage(logger, UPDATE, entryPacket.getTypeName(), entryPacket.getUID(), Level.SEVERE, "Entry is locked by another transaction.");
        }
    }

    public void handleEntryLockedByTransactionOnChange(Logger logger, ITemplatePacket entryPacket) {
        if (logger != null && logger.isLoggable(Level.SEVERE)) {
            this.logMessage(logger, CHANGE, entryPacket.getTypeName(), entryPacket.getUID(), Level.SEVERE, "Entry is locked by another transaction.");
        }
    }

    public void handleEntryVersionConflictOnUpdate(Logger logger, IEntryPacket entryPacket, EntryVersionConflictException ex) {
        this.handleEntryVersionConflictOnUpdate(logger, entryPacket, ex, this.getDefaultExceptionLevel());
    }

    public void handleEntryVersionConflictOnChange(Logger logger, ITemplatePacket entryPacket, EntryVersionConflictException ex) {
        this.handleEntryVersionConflictOnChange(logger, entryPacket, ex, this.getDefaultExceptionLevel());
    }

    public void handleEntryVersionConflictOnUpdate(Logger logger, IEntryPacket entryPacket, EntryVersionConflictException ex, Level logLevel) {
        if (logger != null && logger.isLoggable(logLevel)) {
            this.logMessage(logger, UPDATE, entryPacket.getTypeName(), entryPacket.getUID(), logLevel, "Version conflict - in space entry version is <" + ex.getSpaceVersionID() + ">, replicated version <" + ex.getClientVersionID() + ">.");
        }
    }

    public void handleEntryVersionConflictOnChange(Logger logger, ITemplatePacket entryPacket, EntryVersionConflictException ex, Level logLevel) {
        if (logger != null && logger.isLoggable(logLevel)) {
            this.logMessage(logger, CHANGE, entryPacket.getTypeName(), entryPacket.getUID(), logLevel, "Version conflict - in space entry version is <" + ex.getSpaceVersionID() + ">, replicated version <" + ex.getClientVersionID() + ">.");
        }
    }

    public void handleEntryNotInSpaceOnUpdate(Logger logger, IEntryPacket entryPacket, EntryNotInSpaceException ex) {
        Level logLevel = this.getDefaultExceptionLevel();
        if (logger != null && logger.isLoggable(logLevel)) {
            this.logMessage(logger, UPDATE, entryPacket.getTypeName(), entryPacket.getUID(), logLevel, "Entry is not in space");
        }
    }

    public void handleEntryNotInSpaceOnChange(Logger logger, ITemplatePacket entryPacket) {
        Level logLevel = this.getDefaultExceptionLevel();
        if (logger != null && logger.isLoggable(logLevel)) {
            this.logMessage(logger, CHANGE, entryPacket.getTypeName(), entryPacket.getUID(), logLevel, "Entry is not in space");
        }
    }

    protected Level getDefaultExceptionLevel() {
        return Level.SEVERE;
    }

    protected void logMessage(Logger logger, String operation, String className, String uid, Level logLevel, String symptom) {
        logger.log(logLevel, "Replication detected conflicting " + operation + " operation on entry - <" + className + "> uid=<" + uid + ">\n  Symptom: " + symptom + "\n  Ignoring the conflicting operation since it has already been applied to space [" + this._spaceName + "].\n  Please make sure that the entry was not simultaneously changed in two different space instances.");
    }
}

