/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseCancelledHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExpiredHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExtendedHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.ConflictingOperationPolicy;
import java.util.logging.Level;
import net.jini.core.lease.UnknownLeaseException;

@InternalApi
public class SpaceReplicationEntryLeaseEventHandler
implements IReplicationInEntryLeaseCancelledHandler,
IReplicationInEntryLeaseExtendedHandler,
IReplicationInEntryLeaseExpiredHandler {
    protected final SpaceEngine _engine;
    private final boolean _isPrimaryBackupSpace;

    public SpaceReplicationEntryLeaseEventHandler(SpaceEngine engine) {
        this._engine = engine;
        this._isPrimaryBackupSpace = this._engine.getClusterPolicy() != null && this._engine.getClusterPolicy().isPrimaryElectionAvailable();
    }

    protected LeaseManager getLeaseManager() {
        return this._engine.getLeaseManager();
    }

    private ConflictingOperationPolicy getConflictingOperationPolicy() {
        return this._engine.getConflictingOperationPolicy();
    }

    private boolean ignoreOperation(boolean isTransient) {
        return !isTransient && this._engine.getCacheManager().isCentralDB() && this._engine.getCacheManager().isCacheExternalDB() && this._engine.getCacheManager().isEvictableCachePolicy();
    }

    @Override
    public void inCancelEntryLeaseByUID(IReplicationInContext context, String typeName, String uid, boolean isTransient, int routingValue) {
        block8: {
            if (this._isPrimaryBackupSpace && this.ignoreOperation(isTransient)) {
                return;
            }
            try {
                IEntryHolder entryHolder = this.getLeaseManager().cancel(uid, typeName, 1, true, false, false);
                if (context.getContentContext() != null) {
                    if (entryHolder != null) {
                        IEntryData entryData = entryHolder.getEntryData();
                        context.getContentContext().setMainEntryData(entryData);
                    } else if (context.getContextLogger().isLoggable(Level.FINE)) {
                        context.getContextLogger().log(Level.FINE, "Cancellation of entry lease did not return an associated entry: Type name:" + typeName + " UID: " + uid);
                    }
                }
            }
            catch (UnknownLeaseException ex) {
                if (this.getConflictingOperationPolicy().isOverride()) {
                    return;
                }
                if (!context.getContextLogger().isLoggable(Level.WARNING)) break block8;
                context.getContextLogger().log(Level.WARNING, "Replicator: " + ((Object)((Object)ex)).getClass().getName() + ". Failed to cancel Entry lease: " + typeName + " UID: " + uid + " ObjectType: " + 1 + " in target [" + this._engine.getFullSpaceName() + "] space.\n" + ex.getMessage());
            }
        }
    }

    @Override
    public void inCancelEntryLease(IReplicationInContext context, IEntryPacket entryPacket) {
        this.inCancelEntryLeaseByUID(context, entryPacket.getTypeName(), entryPacket.getUID(), entryPacket.isTransient(), -1);
    }

    @Override
    public void inExtendEntryLeasePeriod(IReplicationInContext context, String typeName, String uid, boolean isTransient, long lease, int routingValue) throws UnknownLeaseException {
        if (this._isPrimaryBackupSpace && this.ignoreOperation(isTransient)) {
            return;
        }
        this.getLeaseManager().renew(uid, typeName, 1, lease, true, false, false);
    }

    @Override
    public void inEntryLeaseExpiredByUID(IReplicationInContext context, String typeName, String uid, boolean isTransient, OperationID operationID) {
        block8: {
            if (this._isPrimaryBackupSpace && this.ignoreOperation(isTransient)) {
                return;
            }
            try {
                IEntryHolder entryHolder = this.getLeaseManager().cancel(uid, typeName, 1, true, false, true, operationID, false);
                if (context.getContentContext() != null) {
                    if (entryHolder != null) {
                        IEntryData entryData = entryHolder.getEntryData();
                        context.getContentContext().setMainEntryData(entryData);
                    } else if (context.getContextLogger().isLoggable(Level.FINE)) {
                        context.getContextLogger().log(Level.FINE, "Expiration of entry lease did not return an associated entry: Type name:" + typeName + " UID: " + uid);
                    }
                }
            }
            catch (UnknownLeaseException ex) {
                Level logLevel;
                if (this.getConflictingOperationPolicy().isOverride()) {
                    return;
                }
                Level level = logLevel = this.getLeaseManager().isSlaveLeaseManagerForEntries() ? Level.FINE : Level.WARNING;
                if (!context.getContextLogger().isLoggable(logLevel)) break block8;
                context.getContextLogger().log(logLevel, "Replicator: " + ((Object)((Object)ex)).getClass().getName() + ". Failed to expire Entry lease: " + typeName + " UID: " + uid + " ObjectType: " + 1 + " in target [" + this._engine.getFullSpaceName() + "] space.\n" + ex.getMessage());
            }
        }
    }

    @Override
    public void inEntryLeaseExpired(IReplicationInContext context, IEntryPacket entryPacket) {
        this.inEntryLeaseExpiredByUID(context, entryPacket.getTypeName(), entryPacket.getUID(), entryPacket.isTransient(), entryPacket.getOperationID());
    }
}

