/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeIndexAddedHandler;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceReplicationMetadataEventHandler
implements IReplicationInDataTypeCreatedHandler,
IReplicationInDataTypeIndexAddedHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication");
    private final SpaceTypeManager _typeManager;
    private final SpaceEngine _spaceEngine;

    public SpaceReplicationMetadataEventHandler(SpaceTypeManager typeManager, SpaceEngine spaceEngine) {
        this._typeManager = typeManager;
        this._spaceEngine = spaceEngine;
    }

    @Override
    public void inDataTypeIntroduce(IReplicationInContext context, ITypeDesc typeDesc) throws Exception {
        block3: {
            try {
                this._typeManager.addTypeDesc(typeDesc);
                if (this._spaceEngine.getCacheManager().isBlobStoreCachePolicy()) {
                    this._spaceEngine.getCacheManager().getStorageAdapter().introduceDataType(typeDesc);
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, "Conflict in type introduction.", e);
            }
        }
    }

    @Override
    public void inDataTypeAddIndex(IReplicationInContext context, AddTypeIndexesRequestInfo requestInfo) throws Exception {
        block3: {
            try {
                this._typeManager.addIndexes(requestInfo.getTypeName(), requestInfo.getIndexes());
                if (this._spaceEngine.getCacheManager().isBlobStoreCachePolicy()) {
                    this._spaceEngine.getCacheManager().getStorageAdapter().addIndexes(requestInfo.getTypeName(), requestInfo.getIndexes());
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, "Error adding new index to type [" + requestInfo.getTypeName() + "].", e);
            }
        }
    }
}

