/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateLeaseExpiredHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateLeaseExtendedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateRemovedHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.ConflictingOperationPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.space.InternalSpaceException;

@InternalApi
public class SpaceReplicationTemplateEventHandler
implements IReplicationInNotifyTemplateCreatedHandler,
IReplicationInNotifyTemplateRemovedHandler,
IReplicationInNotifyTemplateLeaseExtendedHandler,
IReplicationInNotifyTemplateLeaseExpiredHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication");
    private final SpaceEngine _engine;
    private final SpaceTypeManager _typeManager;

    public SpaceReplicationTemplateEventHandler(SpaceEngine engine) {
        this._engine = engine;
        this._typeManager = engine.getTypeManager();
    }

    private LeaseManager getLeaseManager() {
        return this._engine.getLeaseManager();
    }

    private ConflictingOperationPolicy getConflictingOperationPolicy() {
        return this._engine.getConflictingOperationPolicy();
    }

    @Override
    public void inInsertNotifyTemplate(IReplicationInContext context, ITemplatePacket template, String templateUid, NotifyInfo notifyInfo) throws Exception {
        this._typeManager.loadServerTypeDesc(template);
        this._engine.notify(template, template.getTTL(), true, templateUid, null, notifyInfo);
    }

    @Override
    public void inRemoveNotifyTemplate(IReplicationInContext context, String typeName, String uid) {
        block3: {
            try {
                this.getLeaseManager().cancel(uid, typeName, 3, true, false, false);
            }
            catch (UnknownLeaseException e) {
                if (this.getConflictingOperationPolicy().isOverride()) {
                    return;
                }
                if (!_logger.isLoggable(Level.WARNING)) break block3;
                _logger.log(Level.WARNING, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to cancel NotifyTemplate lease: " + typeName + " UID: " + uid + " ObjectType: " + 3 + " in target [" + this._engine.getFullSpaceName() + "] space.\nThis NotifyTemplate might be already expired or canceled.");
            }
        }
    }

    @Override
    public void inExtendNotifyTemplateLeasePeriod(IReplicationInContext context, String typeName, String uid, long lease) throws UnknownLeaseException, InternalSpaceException {
        this.getLeaseManager().renew(uid, typeName, 3, lease, true, false, false);
    }

    @Override
    public void inNotifyTemplateLeaseExpired(IReplicationInContext context, String className, String uid, OperationID operationID) {
        block3: {
            try {
                this.getLeaseManager().cancel(uid, className, 3, true, false, true, operationID, false);
            }
            catch (UnknownLeaseException ex) {
                Level logLevel;
                if (this.getConflictingOperationPolicy().isOverride()) {
                    return;
                }
                Level level = logLevel = this.getLeaseManager().isSlaveLeaseManagerForNotifyTemplates() ? Level.FINE : Level.WARNING;
                if (!_logger.isLoggable(logLevel)) break block3;
                _logger.log(logLevel, "Replicator: " + ((Object)((Object)ex)).getClass().getName() + ". Failed to expire NotifyTemplate lease: " + className + " UID: " + uid + " ObjectType: " + 3 + " in target [" + this._engine.getFullSpaceName() + "] space.\nThis NotifyTemplate might be already canceled.");
            }
        }
    }
}

