/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.handlers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.AbstractReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalExecutionCallback;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transaction.DummyTransactionManager;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.OperationID;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;

@InternalApi
public class SpaceReplicationTransactionEventHandler
implements IReplicationInTransactionHandler,
ITransactionalExecutionCallback {
    private final SpaceEngine _spaceEngine;
    private final AbstractReplicationEntryEventHandler _entryHandler;
    private final DummyTransactionManager _txnManager;

    public SpaceReplicationTransactionEventHandler(SpaceEngine spaceEngine, AbstractReplicationEntryEventHandler entryHandler) {
        this._spaceEngine = spaceEngine;
        this._entryHandler = entryHandler;
        this._txnManager = DummyTransactionManager.getInstance();
    }

    @Override
    public void inTransaction(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        boolean fromReplication = true;
        boolean supportsTwoPhase = false;
        OperationID operationId = null;
        ServerTransaction txn = null;
        List packetsData = (List)((Object)transactionContext);
        try {
            txn = this._txnManager.create();
            this._spaceEngine.attachToXtn(txn, true);
            for (IReplicationTransactionalPacketEntryData packetEntryData : packetsData) {
                packetEntryData.executeTransactional(context, this, (Transaction)txn, false);
            }
            ServerTransaction transactionWithParticipantContent = this._spaceEngine.getSpaceImpl().createServerTransaction((TransactionManager)this._txnManager, txn.id, 1);
            this._spaceEngine.prepareAndCommit((TransactionManager)this._txnManager, transactionWithParticipantContent, operationId);
            this._spaceEngine.enableDuplicateExecutionProtection(transactionContext.getOperationID());
        }
        catch (Exception e) {
            if (txn != null) {
                try {
                    ServerTransaction transactionWithParticipantContent = this._spaceEngine.getSpaceImpl().createServerTransaction((TransactionManager)this._txnManager, txn.id, 1);
                    this._spaceEngine.abort((TransactionManager)this._txnManager, transactionWithParticipantContent, false, operationId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public void inTransactionPrepare(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        ServerTransaction transaction = transactionContext.getTransaction();
        this._spaceEngine.attachToXtn(transaction, true);
        List packetsData = (List)((Object)transactionContext);
        for (IReplicationTransactionalPacketEntryData packetEntryData : packetsData) {
            packetEntryData.executeTransactional(context, this, (Transaction)transaction, true);
        }
        if (this._spaceEngine.getOperationLogger().isLoggable(Level.FINEST)) {
            this._spaceEngine.getOperationLogger().finest("preparing transaction [" + this._spaceEngine.createTransactionDetailsString(transaction, null) + "]");
        }
        int prepareResult = this._spaceEngine.prepare((TransactionManager)transaction.mgr, transaction, false, false, null);
        if (this._spaceEngine.getOperationLogger().isLoggable(Level.FINEST)) {
            this._spaceEngine.getOperationLogger().finest("prepared transaction [" + this._spaceEngine.createTransactionDetailsString(transaction, null) + "] result=" + prepareResult);
        }
    }

    @Override
    public void inTransactionCommit(IReplicationInContext context, ITransactionInContext transactionContext) throws UnknownTransactionException, RemoteException {
        ServerTransaction transaction = transactionContext.getTransaction();
        if (this._spaceEngine.getCacheManager().requiresEvictionReplicationProtection()) {
            List packetsData = (List)((Object)transactionContext);
            for (IReplicationTransactionalPacketEntryData packetEntryData : packetsData) {
                IMarker marker = context.getContextMarker(this._spaceEngine.getCacheManager().getEvictionPolicyReplicationMembersGroupName());
                this._spaceEngine.getCacheManager().getEvictionReplicationsMarkersRepository().insert(packetEntryData.getUid(), marker, false);
            }
        }
        this._spaceEngine.commit((TransactionManager)transaction.mgr, transaction, false, null, true);
        this._spaceEngine.enableDuplicateExecutionProtection(transactionContext.getOperationID());
    }

    @Override
    public void inTransactionAbort(IReplicationInContext context, ITransactionInContext transactionContext) {
        block2: {
            ServerTransaction transaction = transactionContext.getTransaction();
            try {
                this._spaceEngine.abort((TransactionManager)transaction.mgr, transaction, false, null);
                this._spaceEngine.enableDuplicateExecutionProtection(transactionContext.getOperationID());
            }
            catch (UnknownTransactionException e) {
                if (context.getContextLogger() == null || !context.getContextLogger().isLoggable(Level.WARNING)) break block2;
                context.getContextLogger().warning("Replication of abort of two phase commit transaction [Metadata=" + transactionContext.getMetaData() + "] failed with unknown transaction exception, this could occur after failover where the transaction abort has already been replicated. ignoring operation");
            }
        }
    }

    @Override
    public void writeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) throws Exception {
        this._entryHandler.writeEntry(context, txn, twoPhaseCommit, entry);
    }

    @Override
    public void updateEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry, IEntryPacket previousEntryPacket, boolean partialUpdate, boolean overrideVersion, short flags) throws Exception {
        this._entryHandler.updateEntry(context, txn, twoPhaseCommit, entry, previousEntryPacket, partialUpdate, overrideVersion);
    }

    @Override
    public void changeEntry(IReplicationInContext context, Transaction transaction, boolean twoPhaseCommit, String typeName, String uid, Object id, int version, int previousVersion, long timeToLive, int routingHash, Collection<SpaceEntryMutator> spaceEntryMutators, boolean isTransient, OperationID operationID, IEntryData previousEntryData) throws Exception {
        this._entryHandler.changeEntry(context, transaction, twoPhaseCommit, typeName, uid, id, routingHash, version, previousVersion, timeToLive, spaceEntryMutators, isTransient, operationID, previousEntryData);
    }

    @Override
    public void removeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) throws Exception {
        this._entryHandler.removeEntry(context, txn, twoPhaseCommit, entry);
    }

    @Override
    public void removeEntryByUID(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, String uid, boolean isTransient, OperationID operationID) throws Exception {
        this._entryHandler.removeEntryByUid(context, txn, twoPhaseCommit, uid, isTransient, operationID);
    }
}

