/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.notification;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.config.MemberAddedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.MemberRemovedEvent;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationChannelDataFilter;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.FilterManager;

@InternalApi
public class NotificationDynamicSourceGroupMemberLifeCycle
extends DynamicSourceGroupMemberLifeCycle {
    private final SpaceImpl _space;
    private final SpaceContext _spaceContext;
    private final FilterManager _filterManager;
    private volatile NotifyTemplateHolder _tHolder;

    public NotificationDynamicSourceGroupMemberLifeCycle(SpaceImpl space, FilterManager filterManager, SpaceContext spaceContext) {
        this._space = space;
        this._filterManager = filterManager;
        this._spaceContext = spaceContext;
    }

    @Override
    public void beforeMemberAdded(MemberAddedEvent memberAddedEvent) {
        NotificationReplicationChannelDataFilter channelFilter = (NotificationReplicationChannelDataFilter)memberAddedEvent.getFilter();
        this._tHolder = channelFilter.getNotifyTemplateHolder();
        if (this._filterManager._isFilter[4]) {
            this._filterManager.invokeFilters(4, this._spaceContext, this._tHolder);
        }
        this._space.getEngine().getCacheManager().getTemplatesManager().registerDurableNotifyTemplate(this._tHolder);
        channelFilter.initTemplate();
    }

    @Override
    public void afterMemberAdded(MemberAddedEvent memberAddedEvent) {
        this._space.getEngine().getCacheManager().getTypeData(this._tHolder.getServerTypeDesc()).incNumDurableNotificationsStored();
    }

    @Override
    public void afterMemberRemoved(MemberRemovedEvent memberRemovedEvent) {
        this._space.getEngine().getCacheManager().getTypeData(this._tHolder.getServerTypeDesc()).decNumDurableNotificationsStored();
        this._space.getEngine().getCacheManager().getTemplatesManager().unregisterDurableNotifyTemplate(this._tHolder);
    }
}

