/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.notification;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelEntryDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationSpaceFilterEntry;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryDataContentExtractor;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationEntryDataConversionMetadata;
import com.gigaspaces.internal.query.RegexCache;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.FlatEntryData;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateEntryData;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.admin.TemplateInfo;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import com.j_spaces.core.filters.FilterManager;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class NotificationReplicationChannelDataFilter
extends ReliableAsyncChannelDataFilter {
    private static final Logger _spaceFilterLogger = Logger.getLogger("com.gigaspaces.filters");
    private final NotifyActionType _notifyType;
    private final RegexCache _regexCache;
    private final SpaceTypeManager _typeManager;
    private final FilterManager _filterManager;
    private final NotifyTemplateHolder _tHolder;
    private final boolean _hasProjectionTemplate;
    private TemplateEntryData _template = null;
    private final CacheManager _cacheManager;

    public NotificationReplicationChannelDataFilter(CacheManager cacheManager, String groupName, RegexCache regexCache, SpaceTypeManager typeManager, FilterManager filterManager, NotifyTemplateHolder tHolder) {
        this._cacheManager = cacheManager;
        this._typeManager = typeManager;
        this._tHolder = tHolder;
        this._filterManager = filterManager;
        this._notifyType = NotifyActionType.fromModifier(this._tHolder.getNotifyType());
        this._regexCache = regexCache;
        this._hasProjectionTemplate = this._tHolder.getProjectionTemplate() != null;
    }

    public IServerTypeDesc getTemplateTypeDesc() {
        return this._tHolder.getServerTypeDesc();
    }

    public boolean isTemplateOfType(String typeName) {
        return typeName != null && this._tHolder.getServerTypeDesc() != null && this._tHolder.getServerTypeDesc().getTypeName() != null && typeName.equals(this._tHolder.getServerTypeDesc().getTypeName());
    }

    public TemplateInfo createTemplateInfo() {
        return new TemplateInfo(this._tHolder.isFifoTemplate(), new Date(this._tHolder.getExpirationTime()), this._tHolder.getEntryData().getFixedPropertiesValues(), this._tHolder.getUidToOperateBy(), this._tHolder.getOperationModifiers());
    }

    @Override
    public ReplicationChannelEntryDataFilterResult filterBeforeReplicatingEntryData(IReplicationPacketEntryData packetEntryData, PlatformLogicalVersion targetLogicalVersion, IReplicationPacketEntryDataContentExtractor contentExtractor, Logger contextLogger, IReplicationPacketData<?> data) {
        boolean isUnmatched = false;
        ReplicationChannelEntryDataFilterResult result = ReplicationChannelEntryDataFilterResult.FILTER_DATA;
        block1 : switch (packetEntryData.getOperationType()) {
            case CANCEL_LEASE: 
            case ENTRY_LEASE_EXPIRED: {
                result = this.filterSingleEntry(contentExtractor.getMainEntryData(packetEntryData), packetEntryData.getOperationType()) ? ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.ENTRY_LEASE_EXPIRED).requiresFullEntryData().resultType(this._tHolder.getQueryResultType())) : ReplicationChannelEntryDataFilterResult.FILTER_DATA;
                break;
            }
            case REMOVE_ENTRY: {
                boolean filterEntry = this.filterSingleEntry(contentExtractor.getMainEntryData(packetEntryData), packetEntryData.getOperationType());
                if (!filterEntry) break;
                result = !packetEntryData.containsFullEntryData() ? ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.REMOVE_ENTRY).requiresFullEntryData().resultType(this._tHolder.getQueryResultType())) : ReplicationChannelEntryDataFilterResult.PASS;
                break;
            }
            case WRITE: {
                result = this.filterSingleEntry(contentExtractor.getMainEntryData(packetEntryData), packetEntryData.getOperationType()) ? ReplicationChannelEntryDataFilterResult.PASS : ReplicationChannelEntryDataFilterResult.FILTER_DATA;
                break;
            }
            case UPDATE: 
            case CHANGE: {
                boolean isUpdate = packetEntryData.getOperationType() == ReplicationSingleOperationType.UPDATE;
                IEntryData entryBeforeUpdate = contentExtractor.getSecondaryEntryData(packetEntryData);
                IEntryData entryAfterUpdate = contentExtractor.getMainEntryData(packetEntryData);
                if (entryBeforeUpdate == null && contextLogger.isLoggable(Level.WARNING)) {
                    String operation = isUpdate ? "update" : "change";
                    contextLogger.log(Level.WARNING, operation + " operation of entry [" + packetEntryData + "] is missing previous entry state, this may result with inconsistent durable notification state");
                }
                ReplicationEntryDataConversionMetadata metadata = new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.UPDATE).resultType(this._tHolder.getQueryResultType());
                MatchLevel matchLevel = this.filterUpdateEntry(entryAfterUpdate, entryBeforeUpdate, contextLogger, packetEntryData.getOperationType());
                switch (matchLevel) {
                    case BOTH: {
                        if (this._notifyType.isRematchedUpdate()) {
                            metadata.flags((short)4);
                        }
                        if (!packetEntryData.containsFullEntryData()) {
                            metadata.requiresFullEntryData();
                        } else {
                            metadata.entryData(entryAfterUpdate);
                        }
                        if (this._tHolder.getNotifyInfo().isReturnPrevValue()) {
                            metadata.requiresPrevValue();
                            result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
                            break block1;
                        }
                        if (!packetEntryData.containsFullEntryData() || this._notifyType.isRematchedUpdate() || !isUpdate) {
                            result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
                            break block1;
                        }
                        result = ReplicationChannelEntryDataFilterResult.PASS;
                        break block1;
                    }
                    case CURRENT: {
                        if (this._notifyType.isMatchedUpdate()) {
                            metadata.flags((short)2);
                        }
                        if (!packetEntryData.containsFullEntryData()) {
                            metadata.requiresFullEntryData();
                        } else {
                            metadata.entryData(entryAfterUpdate);
                        }
                        if (this._tHolder.getNotifyInfo().isReturnPrevValue()) {
                            metadata.requiresPrevValue();
                            result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
                            break block1;
                        }
                        if (!packetEntryData.containsFullEntryData() || this._notifyType.isMatchedUpdate() || !isUpdate) {
                            result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
                            break block1;
                        }
                        result = ReplicationChannelEntryDataFilterResult.PASS;
                        break block1;
                    }
                    case PREVIOUS: {
                        isUnmatched = true;
                        metadata.flags((short)1).entryData(entryBeforeUpdate);
                        if (this._tHolder.getNotifyInfo().isReturnPrevValue()) {
                            metadata.requiresPrevValue();
                        }
                        result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
                        break block1;
                    }
                    case NONE: {
                        result = ReplicationChannelEntryDataFilterResult.FILTER_DATA;
                        break block1;
                    }
                }
                throw new ReplicationInternalSpaceException("Unknown match level handling " + (Object)((Object)matchLevel));
            }
            default: {
                result = ReplicationChannelEntryDataFilterResult.FILTER_DATA;
            }
        }
        if (result.getFilterOperation() != IReplicationChannelDataFilter.FilterOperation.FILTER_DATA && this._filterManager._isFilter[15]) {
            IEntryData entryData = isUnmatched ? contentExtractor.getSecondaryEntryData(packetEntryData) : contentExtractor.getMainEntryData(packetEntryData);
            String uid = packetEntryData.getUid();
            boolean isTransient = packetEntryData.isTransient();
            NotificationReplicationSpaceFilterEntry filterEntry = null;
            if (this._filterManager.hasFilterRequiresFullSpaceFilterEntry(15)) {
                filterEntry = packetEntryData.getOperationType() == ReplicationSingleOperationType.UPDATE && !packetEntryData.containsFullEntryData() && !isUnmatched ? new NotificationReplicationSpaceFilterEntry(entryData, contentExtractor.getSecondaryEntryData(packetEntryData), uid, isTransient) : new NotificationReplicationSpaceFilterEntry(entryData, uid, isTransient);
            }
            Object[] arguments = new Object[]{filterEntry, this._tHolder};
            try {
                this._filterManager.invokeFilters(15, null, arguments);
            }
            catch (RuntimeException e) {
                if (_spaceFilterLogger.isLoggable(Level.FINE)) {
                    _spaceFilterLogger.log(Level.FINE, "Exception was thrown by filter on BEFORE_NOTIFY_TRIGGER.", e);
                }
                return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
            }
            if (filterEntry != null && filterEntry.isModified()) {
                FlatEntryData modifiedEntryData = new FlatEntryData(filterEntry.getFieldsValues(), filterEntry.getDynamicValues(), entryData.getEntryTypeDesc(), entryData.getVersion(), entryData.getExpirationTime(), false);
                ReplicationEntryDataConversionMetadata metadata = result.getFilterOperation() == IReplicationChannelDataFilter.FilterOperation.PASS ? new ReplicationEntryDataConversionMetadata(packetEntryData.getOperationType()).entryData(modifiedEntryData).resultType(this._tHolder.getQueryResultType()) : result.getConversionMetadata().entryData(modifiedEntryData);
                metadata.modifiedByFilter();
                result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
            }
        }
        if (result.getFilterOperation() == IReplicationChannelDataFilter.FilterOperation.PASS && contentExtractor.requiresConversion(packetEntryData, this._tHolder.getQueryResultType())) {
            ReplicationEntryDataConversionMetadata metadata = new ReplicationEntryDataConversionMetadata().resultType(this._tHolder.getQueryResultType());
            result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
        }
        if (this._hasProjectionTemplate) {
            if (result.getFilterOperation() == IReplicationChannelDataFilter.FilterOperation.PASS) {
                ReplicationEntryDataConversionMetadata metadata = new ReplicationEntryDataConversionMetadata().projectionTemplate(this._tHolder.getProjectionTemplate());
                result = ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
            } else if (result.getFilterOperation() == IReplicationChannelDataFilter.FilterOperation.CONVERT) {
                result.getConversionMetadata().projectionTemplate(this._tHolder.getProjectionTemplate());
            }
        }
        return result;
    }

    private boolean filterSingleEntry(ServerEntry entry, ReplicationSingleOperationType operationType) {
        if (entry == null) {
            return true;
        }
        if (!this.matchNotifyActionType(operationType)) {
            return false;
        }
        SpaceTypeDescriptor spaceTypeDescriptor = entry.getSpaceTypeDescriptor();
        String typeName = spaceTypeDescriptor.getTypeName();
        IServerTypeDesc typeDesc = this._typeManager.getServerTypeDesc(typeName);
        return this.getTemplate().isAssignableFrom(typeDesc) && this.getTemplate().match(this._cacheManager, entry, -1, null, this._regexCache);
    }

    private MatchLevel filterUpdateEntry(ServerEntry entry, ServerEntry prevEntry, Logger contextLogger, ReplicationSingleOperationType operationType) {
        if (!this.matchNotifyActionType(operationType)) {
            return MatchLevel.NONE;
        }
        boolean matchPrevious = false;
        boolean matchCurrent = false;
        SpaceTypeDescriptor spaceTypeDescriptor = entry.getSpaceTypeDescriptor();
        String typeName = spaceTypeDescriptor.getTypeName();
        IServerTypeDesc typeDesc = this._typeManager.getServerTypeDesc(typeName);
        if (this.getTemplate().isAssignableFrom(typeDesc)) {
            if (!matchPrevious && prevEntry != null && this.getTemplate().match(this._cacheManager, prevEntry, -1, null, this._regexCache)) {
                matchPrevious = true;
            }
            if (!matchCurrent && this.getTemplate().match(this._cacheManager, entry, -1, null, this._regexCache)) {
                matchCurrent = true;
            }
        }
        MatchLevel result = MatchLevel.NONE;
        if (matchPrevious && matchCurrent) {
            result = MatchLevel.BOTH;
        } else if (matchPrevious) {
            result = MatchLevel.PREVIOUS;
        } else if (matchCurrent) {
            result = MatchLevel.CURRENT;
        }
        if (result == MatchLevel.PREVIOUS && !this._notifyType.isUnmatched() || result == MatchLevel.BOTH && !this._notifyType.isUpdate() && !this._notifyType.isRematchedUpdate() || result == MatchLevel.CURRENT && !this._notifyType.isUpdate() && !this._notifyType.isMatchedUpdate()) {
            result = MatchLevel.NONE;
        }
        return result;
    }

    public synchronized void initTemplate() {
        if (this._template != null) {
            throw new IllegalStateException("Template has already been initiated");
        }
        ITemplatePacket templatePacket = this._tHolder.getGenerationTemplate().clone();
        templatePacket.setFieldsValues(this._tHolder.getEntryData().getFixedPropertiesValues());
        templatePacket.setCustomQuery(this._tHolder.getCustomQuery());
        this._template = new TemplateEntryData(templatePacket.getTypeDescriptor(), templatePacket, Long.MAX_VALUE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateEntryData getTemplate() {
        if (this._template == null) {
            NotificationReplicationChannelDataFilter notificationReplicationChannelDataFilter = this;
            synchronized (notificationReplicationChannelDataFilter) {
                return this._template;
            }
        }
        return this._template;
    }

    private boolean matchNotifyActionType(ReplicationSingleOperationType operationType) {
        switch (operationType) {
            case REMOVE_ENTRY: {
                return this._notifyType.isTake();
            }
            case UPDATE: 
            case CHANGE: {
                return this._notifyType.isUpdate() || this._notifyType.isUnmatched() || this._notifyType.isMatchedUpdate() || this._notifyType.isRematchedUpdate();
            }
            case WRITE: {
                return this._notifyType.isWrite();
            }
            case CANCEL_LEASE: 
            case ENTRY_LEASE_EXPIRED: {
                return this._notifyType.isLeaseExpiration();
            }
        }
        return false;
    }

    @Override
    public boolean filterBeforeReplicatingUnreliableOperation(IReplicationUnreliableOperation operation, PlatformLogicalVersion targetLogicalVersion) {
        return false;
    }

    @Override
    public void filterAfterReplicatedEntryData(IReplicationPacketEntryData data, PlatformLogicalVersion targetLogicalVersion, IReplicationPacketEntryDataContentExtractor contentExtractor, Logger contextLogger) {
        block4: {
            if (this._filterManager._isFilter[16]) {
                NotificationReplicationSpaceFilterEntry filterEntry = null;
                if (this._filterManager.hasFilterRequiresFullSpaceFilterEntry(16)) {
                    filterEntry = new NotificationReplicationSpaceFilterEntry(contentExtractor.getMainEntryData(data), data.getUid(), data.isTransient());
                }
                Object[] arguments = new Object[]{filterEntry, this._tHolder};
                try {
                    this._filterManager.invokeFilters(16, null, arguments);
                }
                catch (RuntimeException e) {
                    if (!_spaceFilterLogger.isLoggable(Level.FINE)) break block4;
                    _spaceFilterLogger.log(Level.FINE, "Exception was thrown by filter on AFTER_NOTIFY_TRIGGER.", e);
                }
            }
        }
    }

    @Override
    public boolean filterBeforeReplicatingEntryDataHasSideEffects() {
        return true;
    }

    @Override
    public Object[] getConstructionArgument() {
        ITemplatePacket generationTemplate = this._tHolder.getGenerationTemplate().clone();
        generationTemplate.setSerializeTypeDesc(true);
        return new Object[]{generationTemplate, this._tHolder.getNotifyInfo(), this._tHolder.getEventId()};
    }

    public NotifyTemplateHolder getNotifyTemplateHolder() {
        return this._tHolder;
    }

    private static enum MatchLevel {
        CURRENT,
        PREVIOUS,
        BOTH,
        NONE;

    }

    public static class DurableNotificationConversionFlags {
        public static final short UPDATE_TO_UMATCHED = 1;
        public static final short UPDATE_TO_MATCHED_UPDATE = 2;
        public static final short UPDATE_TO_REMATCHED_UPDATE = 4;

        public static boolean isUpdateToUnmatched(short flag) {
            return (flag & 1) == 1;
        }

        public static boolean isUpdateToMatchedUpdate(short flag) {
            return (flag & 2) == 2;
        }

        public static boolean isUpdateToRematchedUpdate(short flag) {
            return (flag & 4) == 4;
        }
    }
}

