/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

@InternalApi
public class BatchReplicatedDataPacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private List<IReplicationOrderedPacket> _batch;
    private long _startKey = 0L;
    private int _totalBatchKeySize = 0;
    private boolean _compressed = false;
    private transient boolean _clean = true;

    public BatchReplicatedDataPacket() {
    }

    public BatchReplicatedDataPacket(String groupName) {
        super(groupName);
    }

    public boolean isCompressed() {
        return this._compressed;
    }

    @Override
    public Object accept(IIncomingReplicationFacade replicationFacade) {
        IReplicationTargetGroup targetGroup = replicationFacade.getReplicationTargetGroup(this.getGroupName());
        if (this._compressed) {
            return targetGroup.processBatch(this.getSourceLookupName(), this.getSourceUniqueId(), this.decompressBatch());
        }
        return targetGroup.processBatch(this.getSourceLookupName(), this.getSourceUniqueId(), this._batch);
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._batch = (List)IOUtils.readObject(in);
        if (endpointLogicalVersion.greaterOrEquals(PlatformLogicalVersion.v14_0_0)) {
            this._compressed = in.readBoolean();
            if (this._compressed) {
                this._startKey = in.readLong();
                this._totalBatchKeySize = in.readInt();
            }
        }
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        if (endpointLogicalVersion.lessThan(PlatformLogicalVersion.v14_0_0)) {
            IOUtils.writeObject(out, this.decompressBatch());
        } else {
            IOUtils.writeObject(out, this._batch);
            out.writeBoolean(this._compressed);
            if (this._compressed) {
                out.writeLong(this._startKey);
                out.writeInt(this._totalBatchKeySize);
            }
        }
    }

    public void setBatch(List<IReplicationOrderedPacket> batch) {
        if (!this._clean || batch == null) {
            throw new IllegalStateException("Attempt to override packet batch when it was not released");
        }
        this._batch = batch;
        this._clean = false;
        this._startKey = this._batch.size() > 0 ? this._batch.get(0).getKey() : 0L;
        this._totalBatchKeySize = 0;
    }

    public List<IReplicationOrderedPacket> getBatch() {
        return this._batch;
    }

    public void clean() {
        this._clean = true;
        this._batch = null;
        this._compressed = false;
        this._startKey = 0L;
        this._totalBatchKeySize = 0;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("batch", this._batch);
    }

    public void compressBatch(boolean containsDiscardedPacket) {
        if (!containsDiscardedPacket) {
            return;
        }
        if (this._batch.size() == 1) {
            return;
        }
        ListIterator<IReplicationOrderedPacket> it = this._batch.listIterator();
        while (it.hasNext()) {
            IReplicationOrderedPacket packet = (IReplicationOrderedPacket)it.next();
            long packetKeyRange = packet.getEndKey() - packet.getKey() + 1L;
            if (packet.isDiscardedPacket()) {
                it.remove();
            }
            this._totalBatchKeySize = (int)((long)this._totalBatchKeySize + packetKeyRange);
        }
        if (this._batch.size() == 0) {
            this._batch.add(this.createDiscardedPacket(this._startKey, this._startKey + (long)this._totalBatchKeySize - 1L));
        }
        this._compressed = true;
    }

    public List<IReplicationOrderedPacket> decompressBatch() {
        if (!this._compressed) {
            return this._batch;
        }
        LinkedList<IReplicationOrderedPacket> result = new LinkedList<IReplicationOrderedPacket>();
        long currentStartKey = this._startKey;
        long globalEndKey = this._startKey + (long)this._totalBatchKeySize - 1L;
        for (IReplicationOrderedPacket packet : this._batch) {
            if (currentStartKey < packet.getKey()) {
                result.add(this.createDiscardedPacket(currentStartKey, packet.getKey() - 1L));
            }
            result.add(packet);
            currentStartKey = packet.getEndKey() + 1L;
        }
        long lastEndKey = ((IReplicationOrderedPacket)result.getLast()).getEndKey();
        if (lastEndKey < globalEndKey) {
            result.add(this.createDiscardedPacket(lastEndKey, globalEndKey));
        }
        return result;
    }

    private GlobalOrderDiscardedReplicationPacket createDiscardedPacket(long startKey, long endKey) {
        GlobalOrderDiscardedReplicationPacket packet = new GlobalOrderDiscardedReplicationPacket(startKey);
        if (endKey != startKey) {
            packet.setEndKey(endKey);
        }
        return packet;
    }

    @Override
    public String toString() {
        return "BatchReplicatedDataPacket{_batch=" + this._batch + ", _startKey=" + this._startKey + ", _totalBatchKeySize=" + this._totalBatchKeySize + ", _compressed=" + this._compressed + ", _clean=" + this._clean + '}';
    }
}

