/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ChannelBacklogDroppedPacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private IBacklogMemberState _memberState;

    public ChannelBacklogDroppedPacket() {
    }

    public ChannelBacklogDroppedPacket(String groupName, IBacklogMemberState memberState) {
        super(groupName);
        this._memberState = memberState;
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._memberState);
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._memberState = (IBacklogMemberState)IOUtils.readObject(in);
    }

    @Override
    public Object accept(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationTargetGroup targetGroup = incomingReplicationFacade.getReplicationTargetGroup(this.getGroupName());
        targetGroup.onChannelBacklogDropped(this.getSourceLookupName(), this.getSourceUniqueId(), this._memberState);
        return null;
    }

    public IBacklogMemberState getState() {
        return this._memberState;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("memberState", this._memberState.toLogMessage());
    }
}

